package de.siphalor.amecs;

import de.siphalor.amecs.api.AmecsKeyBinding;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import de.siphalor.amecs.keybinding.SkinLayerKeyBinding;
import de.siphalor.amecs.keybinding.ToggleAutoJumpKeyBinding;
import de.siphalor.amecs.mixin.ControlsListWidgetKeyBindingEntryAccessor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_459;
import net.minecraft.class_5251;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Arrays;
import java.util.Locale;

/**
 * Main class of Amecs (Alt-Meta-Escape-Control-Shift)
 */
@Environment(EnvType.CLIENT)
public class Amecs implements ClientModInitializer {
    /**
     * The mod id of Amecs
     */
    @SuppressWarnings("WeakerAccess")
    public static final String MOD_ID = "amecs";
    public static final String MOD_NAME_SHORT = "Amecs";

    private static final String LOGGER_PREFIX = "[" + MOD_NAME_SHORT + "] ";
    private static final Logger LOGGER = LogManager.getLogger();

    private static final String SKIN_LAYER_CATEGORY = MOD_ID + ".key.categories.skin_layers";

	public static final class_304 ESCAPE_KEYBINDING = KeyBindingHelper.registerKeyBinding(new AmecsKeyBinding(new class_2960(MOD_ID, "alternative_escape"), class_3675.class_307.field_1668, -1, "key.categories.ui", new KeyModifiers()));

    @Override
    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding(new ToggleAutoJumpKeyBinding(new class_2960(MOD_ID, "toggle_auto_jump"), class_3675.class_307.field_1668, 66, "key.categories.movement", new KeyModifiers()));

        Arrays.stream(class_1664.values())
                .map(playerModelPart -> new SkinLayerKeyBinding(new class_2960(MOD_ID, "toggle_" + playerModelPart.method_7429().toLowerCase(Locale.ENGLISH)), class_3675.class_307.field_1668, -1, SKIN_LAYER_CATEGORY, playerModelPart))
                .forEach(KeyBindingHelper::registerKeyBinding);
    }

    public static void sendToggleMessage(class_1657 playerEntity, boolean value, class_2561 option) {
        playerEntity.method_7353(new class_2588("amecs.toggled." + (value ? "on" : "off"), option), true);
    }

    public static boolean entryKeyMatches(class_459.class_462 entry, String keyFilter) {
        if (keyFilter == null) {
            return true;
        }
        switch (keyFilter) {
            case "":
                return ((IKeyBindingEntry) entry).amecs$getKeyBinding().method_1415();
            case "%":
                return ((ControlsListWidgetKeyBindingEntryAccessor) entry).getEditButton().method_25369().method_10866().method_10973() == class_5251.method_27718(class_124.field_1061);
            default:
                return StringUtils.containsIgnoreCase(((IKeyBindingEntry) entry).amecs$getKeyBinding().method_16007().getString(), keyFilter);
        }
    }

    public static void log(Level level, String message) {
        LOGGER.log(level, LOGGER_PREFIX + message);
    }
}
