package de.siphalor.amecs.gui;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.compat.NMUKProxy;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_459;
import net.minecraft.class_459.class_460;
import net.minecraft.class_6379;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

public class SearchFieldControlsListWidget extends class_459.class_461 {
	protected class_310 minecraft;

	private final class_342 textFieldWidget;

	private int lastEntryCount = 0;
	private final Set<class_459.class_462> entries = new TreeSet<>(Comparator.comparing(o -> ((IKeyBindingEntry) o).amecs$getKeyBinding()));

	public SearchFieldControlsListWidget(class_310 client) {
		minecraft = client;
		class_327 textRenderer = class_310.method_1551().field_1772;
		assert minecraft.field_1755 != null;

		textFieldWidget = new class_342(textRenderer, minecraft.field_1755.field_22789 / 2 - 125, 0, 250, 20, new class_2585(""));
		textFieldWidget.method_1887(class_1074.method_4662("amecs.search.placeholder"));
		textFieldWidget.method_1863(searchText -> {
			class_459 listWidget = null;
			for (class_364 child : client.field_1755.method_25396()) {
				if (child instanceof class_459) {
					listWidget = (class_459) child;
					break;
				}
			}
			assert listWidget != null;

			if (searchText.isEmpty()) {
				textFieldWidget.method_1887(class_1074.method_4662("amecs.search.placeholder"));
			} else {
				textFieldWidget.method_1887("");
			}

			searchText = searchText.trim();
			listWidget.method_25307(0);

			List<class_459.class_461> children = listWidget.method_25396();
			if (entries.isEmpty()) {
				for (class_459.class_461 entry : children) {
					if (entry instanceof class_459.class_462) {
						entries.add((class_459.class_462) entry);
					}
				}
				lastEntryCount = children.size();
			}
			int childrenCount = children.size();
			if (childrenCount != lastEntryCount) {
				Amecs.log(Level.INFO, "Controls search results changed externally - recompiling the list!");
				try {
					//noinspection JavaReflectionMemberAccess
					Constructor<class_459.class_462> c = class_459.class_462.class.getDeclaredConstructor(
							class_459.class, class_304.class, class_2561.class
					);
					c.setAccessible(true);
					entries.clear();
					class_304[] keyBindings = client.field_1690.field_1839.clone();
					Arrays.sort(keyBindings);
					String lastCat = null;
					class_459.class_462 entry;
					lastEntryCount = 1;
					for (class_304 keyBinding : keyBindings) {
						if (!Objects.equals(lastCat, keyBinding.method_1423())) {
							lastCat = keyBinding.method_1423();
							children.add(listWidget.new class_460(new class_2588(keyBinding.method_1423())));
							lastEntryCount++;
						}
						entry = c.newInstance(listWidget, keyBinding, new class_2588(keyBinding.method_1431()));
						children.add(entry);
						entries.add(entry);
						lastEntryCount++;
					}
				} catch (NoSuchMethodException | InstantiationException | IllegalAccessException | InvocationTargetException e) {
					Amecs.log(Level.ERROR, "An unexpected exception occured during recompilation of controls list!");
					e.printStackTrace();
				}
			}

			children.clear();

			children.add(this);

			String keyFilter = null;
			int keyDelimiterPos = searchText.indexOf('=');
			if (keyDelimiterPos == 0) {
				keyFilter = searchText.substring(1).trim();
				searchText = null;
			} else if (keyDelimiterPos > 0) {
				keyFilter = searchText.substring(keyDelimiterPos + 1).trim();
				searchText = searchText.substring(0, keyDelimiterPos).trim();
			}

			final boolean nmuk = FabricLoader.getInstance().isModLoaded("nmuk");
			String lastCat = null;
			boolean lastMatched = false;
			boolean includeCat = false;
			lastEntryCount = 1;
			for (class_459.class_462 entry : entries) {
				class_304 binding = ((IKeyBindingEntry) entry).amecs$getKeyBinding();
				if (nmuk && lastMatched && NMUKProxy.isAlternative(binding)) {
					children.add(entry);
					lastEntryCount++;
					continue;
				}

				final String cat = binding.method_1423();
				if (!cat.equals(lastCat)) {
					includeCat = StringUtils.containsIgnoreCase(class_1074.method_4662(cat), searchText);
				}
				if (
						(
								includeCat
										|| searchText == null
										|| StringUtils.containsIgnoreCase(class_1074.method_4662(((IKeyBindingEntry) entry).amecs$getKeyBinding().method_1431()), searchText)
						) && Amecs.entryKeyMatches(entry, keyFilter)
				) {
					if (!cat.equals(lastCat)) {
						children.add(listWidget.new class_460(new class_2588(cat)));
						lastCat = cat;
						lastEntryCount++;
					}
					children.add(entry);
					lastEntryCount++;
					lastMatched = true;
				} else {
					lastMatched = false;
				}
			}
			if (lastEntryCount <= 1) {
				class_2554 noResultsText = new class_2588(Amecs.MOD_ID + ".search.no_results");
				noResultsText.method_10862(noResultsText.method_10866().method_10977(class_124.field_1080));
				children.add(listWidget.new class_460(noResultsText));
			}
		});
	}

	@Override
	public List<? extends class_364> method_25396() {
		return Collections.singletonList(textFieldWidget);
	}

	@Override
	public boolean method_25402(double double_1, double double_2, int int_1) {
		return textFieldWidget.method_25402(double_1, double_2, int_1);
	}

	@Override
	public boolean method_25406(double double_1, double double_2, int int_1) {
		return textFieldWidget.method_25406(double_1, double_2, int_1);
	}

	@Override
	public boolean method_25404(int int_1, int int_2, int int_3) {
		return textFieldWidget.method_25404(int_1, int_2, int_3);
	}

	@Override
	public boolean method_25400(char char_1, int int_1) {
		return textFieldWidget.method_25400(char_1, int_1);
	}

	@Override
	public boolean method_25407(boolean boolean_1) {
		return textFieldWidget.method_25407(boolean_1);
	}

	@Override
	public void method_25343(class_4587 matrixStack, int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9) {
		textFieldWidget.field_22761 = var2;
		textFieldWidget.method_25394(matrixStack, var6, var7, var9);
	}

	@Override
	public List<? extends class_6379> method_37025() {
		return Collections.singletonList(textFieldWidget);
	}
}
