/*
 * Copyright 2020-2023 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.impl.mixin;

//- import com.mojang.blaze3d.vertex.PoseStack;
import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_459;
import net.minecraft.client.gui.components.*;
//- import net.minecraft.network.chat.TextComponent;
//- import net.minecraft.network.chat.MutableComponent;
//- import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//- import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.ArrayList;
//- import java.util.Arrays;
import java.util.List;

@SuppressWarnings("WeakerAccess")
@Environment(EnvType.CLIENT)
//# if MC_VERSION_NUMBER >= 11800
@Mixin(class_459.class_462.class)
//# else
//- @Mixin(ControlList.KeyEntry.class)
//# end
public abstract class MixinKeyBindingEntry
		//# if MC_VERSION_NUMBER >= 11800
		extends class_459.class_461
		//# else
		//- extends ControlList.Entry
		//# end
		implements IKeyBindingEntry {
	@Unique
	private static final String DESCRIPTION_SUFFIX = "." + AmecsAPI.MOD_ID + ".description";

	@Shadow
	@Final
	private class_304 key;
	@Shadow
	@Final
	private class_4185 changeButton;

	@Unique
	//# if MC_VERSION_NUMBER >= 12106
	//- private WidgetTooltipHolder description;
	//# elif MC_VERSION_NUMBER >= 11600
	private List<class_2561> description;
	//# else
	//- private List<String> description;
	//# end

	@Inject(method = "<init>", at = @At("RETURN"))
	public void onConstructed(
			/*# if MC_VERSION_NUMBER >= 11800 */class_459/*# else *//*- ControlList *//*# end */ parent,
			class_304 keyBinding,
			/*# if MC_VERSION_NUMBER >= 11600 */class_2561 text,/*# end */
			CallbackInfo callbackInfo
	) {
		String descriptionKey = key.method_1431() + DESCRIPTION_SUFFIX;
		if (class_1074.method_4663(descriptionKey)) {
			//# if MC_VERSION_NUMBER >= 12106
			//- description = new WidgetTooltipHolder();
			//- MutableComponent component = MutableComponent.create(new TranslatableContents(
			//- 		descriptionKey,
			//- 		"",
			//- 		new Object[0]
			//- ));
			//- description.set(Tooltip.create(component));
			//# elif MC_VERSION_NUMBER >= 11600
			String[] lines = StringUtils.split(class_1074.method_4662(descriptionKey), '\n');
			description = new ArrayList<>(lines.length);
			for (String line : lines) {
				//# if MC_VERSION_NUMBER >= 11900
				description.add(class_2561.method_43470(line));
				//# else
				//- description.add(new TextComponent(line));
				//# end
			}
			//# else
			//- description = Arrays.asList(StringUtils.split(I18n.get(descriptionKey), '\n'));
			//# end
		} else {
			description = null;
		}
	}

	//# if MC_VERSION_NUMBER >= 12109
	//- @Inject(method = "renderContent", at = @At("RETURN"), locals = LocalCapture.CAPTURE_FAILSOFT)
	//- public void onRendered(
	//- 		GuiGraphics context,
	//- 		int mouseX,
	//- 		int mouseY,
	//- 		boolean hovered,
	//- 		float delta,
	//- 		CallbackInfo callbackInfo,
	//- 		int x,
	//- 		int y
	//- ) {
	//# elif MC_VERSION_NUMBER >= 12000
	@Inject(method = "render", at = @At("RETURN"))
	public void onRendered(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
	//# elif MC_VERSION_NUMBER >= 11600
	//- @Inject(method = "render", at = @At("RETURN"))
	//- public void onRendered(PoseStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
	//# else
	//- @Inject(method = "render", at = @At("RETURN"))
	//- public void onRendered(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
	//# end
		if (description != null) {
			//# if MC_VERSION_NUMBER >= 12109
			//- description.refreshTooltipForNextRenderPass(
			//- 		context,
			//- 		mouseX,
			//- 		mouseY,
			//- 		isMouseOverTitle(y, 20, mouseX, mouseY),
			//- 		changeButton.isFocused(),
			//- 		new ScreenRectangle(x, y, changeButton.getX(), 20)
			//- );
			//# elif MC_VERSION_NUMBER >= 12106
			//- description.refreshTooltipForNextRenderPass(
			//- 		context,
			//- 		mouseX,
			//- 		mouseY,
			//- 		isMouseOverTitle(y, entryHeight, mouseX, mouseY),
			//- 		changeButton.isFocused(),
			//- 		new ScreenRectangle(x, y, entryWidth, entryHeight)
			//- );
			//# else
			if (isMouseOverTitle(y, entryHeight, mouseX, mouseY)) {
				//# if MC_VERSION_NUMBER >= 12000
				context.method_51434(class_310.method_1551().field_1772, description, mouseX, mouseY);
				//# elif MC_VERSION_NUMBER >= 11600
				//- Minecraft.getInstance().screen.renderComponentTooltip(poseStack, description, mouseX, mouseY);
				//# else
				//- Minecraft.getInstance().screen.renderTooltip(description, mouseX, mouseY);
				//# end
			}
			//# end
		}
	}

	@Unique
	private boolean isMouseOverTitle(int y, int entryHeight, int mouseX, int mouseY) {
		//# if MC_VERSION_NUMBER >= 11903
		return mouseY >= y && mouseY < y + entryHeight && mouseX < changeButton.method_46426();
		//# else
		//- return mouseY >= y && mouseY < y + entryHeight && mouseX < changeButton.x;
		//# end
	}

	@Inject(
			method = "method_19870(Lnet/minecraft/client/KeyMapping;Lnet/minecraft/client/gui/components/Button;)V",
			at = @At("HEAD")
	)
	public void onResetButtonClicked(class_304 keyBinding, class_4185 buttonWidget, CallbackInfo callbackInfo) {
		KeyBindingUtils.resetBoundModifiers(keyBinding);
	}

	@Inject(method = "method_19871(Lnet/minecraft/client/KeyMapping;Lnet/minecraft/client/gui/components/Button;)V", at = @At("HEAD"))
	public void onEditButtonClicked(class_304 keyBinding, class_4185 buttonWidget, CallbackInfo callbackInfo) {
		key.method_1422(class_3675.field_16237);
	}

	@Override
	public class_304 amecs$getKeyBinding() {
		return key;
	}
}
