/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.api;

import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class KeyModifiers {
    public static final KeyModifiers NO_MODIFIERS = new FinalKeyModifiers();
    private final boolean[] value;

    public static KeyModifiers getCurrentlyPressed() {
        return AmecsAPI.CURRENT_MODIFIERS;
    }

    public KeyModifiers() {
        this(new boolean[KeyModifier.getModifierCount()]);
    }

    @ApiStatus.Internal
    public KeyModifiers(boolean[] value) {
        if (value.length != KeyModifier.getModifierCount()) {
            throw new IllegalArgumentException("value.length != KeyModifier.getModifierCount(): " + KeyModifier.getModifierCount());
        }
        this.value = value;
    }

    public KeyModifiers(boolean alt, boolean control, boolean shift) {
        this();
        this.setAlt(alt);
        this.setControl(control);
        this.setShift(shift);
    }

    @Deprecated
    public boolean isPressed() {
        return this.equals(AmecsAPI.CURRENT_MODIFIERS);
    }

    public boolean contains(KeyModifiers other) {
        for (int i = 0; i < this.value.length; ++i) {
            if (!other.value[i] || this.value[i]) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    public KeyModifiers setValue(boolean[] value) {
        int length = this.value.length;
        if (value.length != length) {
            throw new IllegalArgumentException("value != this.value.length: " + length);
        }
        System.arraycopy(value, 0, this.value, 0, length);
        return this;
    }

    @ApiStatus.Internal
    public boolean[] getValue() {
        return this.value;
    }

    @ApiStatus.Internal
    public void copyModifiers(KeyModifiers other) {
        this.setValue(other.getValue());
    }

    public KeyModifiers setAlt(boolean value) {
        this.set(KeyModifier.ALT, value);
        return this;
    }

    public boolean getAlt() {
        return this.get(KeyModifier.ALT);
    }

    public KeyModifiers setControl(boolean value) {
        this.set(KeyModifier.CONTROL, value);
        return this;
    }

    public boolean getControl() {
        return this.get(KeyModifier.CONTROL);
    }

    public KeyModifiers setShift(boolean value) {
        this.set(KeyModifier.SHIFT, value);
        return this;
    }

    public boolean getShift() {
        return this.get(KeyModifier.SHIFT);
    }

    public void set(KeyModifier keyModifier, boolean value) {
        if (keyModifier != KeyModifier.NONE) {
            this.value[keyModifier.id] = value;
        }
    }

    public boolean get(KeyModifier keyModifier) {
        if (keyModifier == KeyModifier.NONE) {
            return true;
        }
        return this.value[keyModifier.id];
    }

    public boolean isUnset() {
        return !ArrayUtils.contains((boolean[])this.value, (boolean)true);
    }

    public void unset() {
        Arrays.fill(this.value, false);
    }

    public void cleanup(class_304 keyBinding) {
        class_3675.class_306 key = ((IKeyBinding)keyBinding).amecs$getBoundKey();
        this.set(KeyModifier.fromKey(key), false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyModifiers) {
            return this.equals((KeyModifiers)obj);
        }
        return false;
    }

    public boolean equals(KeyModifiers other) {
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return "KeyModifiers [alt=" + this.getAlt() + ", control=" + this.getControl() + ", shift=" + this.getShift() + "]";
    }

    @ApiStatus.Internal
    public String serializeValue() {
        StringBuilder sb = new StringBuilder();
        for (boolean b : this.value) {
            sb.append(b ? 1 : 0);
            sb.append(",");
        }
        sb.setLength(sb.length() - ",".length());
        return sb.toString();
    }

    @ApiStatus.Internal
    public static boolean[] deserializeValue(String value) {
        boolean[] ret = new boolean[KeyModifier.getModifierCount()];
        if (value.isEmpty()) {
            return ret;
        }
        if (!value.contains(",")) {
            long packedModifiers = Long.parseLong(value, 16);
            for (KeyModifier keyModifier : KeyModifier.VALUES) {
                if (keyModifier == KeyModifier.NONE) continue;
                long mask = 1L << keyModifier.id;
                ret[keyModifier.id] = (packedModifiers & mask) == mask;
            }
            return ret;
        }
        int i = 0;
        for (String p : value.split(",")) {
            ret[i++] = p.equals("1");
        }
        return ret;
    }

    private static class FinalKeyModifiers
    extends KeyModifiers {
        private static final String EXCEPTION_MESSAGE = "You must not alter this Modifiers object";

        private FinalKeyModifiers() {
        }

        @Override
        public KeyModifiers setValue(boolean[] value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void set(KeyModifier keyModifier, boolean value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void unset() {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }
    }
}

