/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AmecsLegacyDeprecationEmitter {
    @Generated
    private static final Logger log = LogManager.getLogger(AmecsLegacyDeprecationEmitter.class);
    private static final ReportingLevel REPORTING_LEVEL;
    private static final String MESSAGE = "Amecs API Legacy Implementation is deprecated, but still being used. Support will be dropped in 2027, please see https://github.com/Siphalor/amecs/blob/cross-version/amecs-api-legacy/MIGRATION.md";
    private static int reports;

    public static void invoke() {
        if (reports < AmecsLegacyDeprecationEmitter.REPORTING_LEVEL.maxReports) {
            ++reports;
            RuntimeException e = new RuntimeException();
            if (REPORTING_LEVEL == ReportingLevel.ERROR_MORE) {
                log.error("{}", (Object)MESSAGE, (Object)e);
            } else {
                log.warn("{}", (Object)MESSAGE, (Object)e);
            }
        }
    }

    @Generated
    private AmecsLegacyDeprecationEmitter() {
    }

    static {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        REPORTING_LEVEL = now.isBefore(LocalDate.of(2026, 1, 1).atStartOfDay(ZoneOffset.UTC)) ? ReportingLevel.DISABLED : (now.isBefore(LocalDate.of(2026, 5, 1).atStartOfDay(ZoneOffset.UTC)) ? ReportingLevel.WARN : (now.isBefore(LocalDate.of(2026, 8, 1).atStartOfDay(ZoneOffset.UTC)) ? ReportingLevel.WARN_MORE : ReportingLevel.ERROR_MORE));
        log.debug("Amecs Legacy Deprecation Reporting Level set to {}", (Object)REPORTING_LEVEL);
    }

    static enum ReportingLevel {
        DISABLED(0),
        WARN(1),
        WARN_MORE(10),
        ERROR_MORE(10);

        private final int maxReports;

        @Generated
        private ReportingLevel(int maxReports) {
            this.maxReports = maxReports;
        }
    }
}

