/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.gui;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.compat.NMUKProxy;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyBindingEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_459;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class SearchFieldControlsListWidget
extends class_459.class_461 {
    private final class_342 searchField;
    private int lastChildrenCount = 0;
    private final Set<class_459.class_462> allKeyEntries = new TreeSet<class_459.class_462>(Comparator.comparing(o -> ((IKeyBindingEntry)o).amecs$getKeyBinding()));

    public SearchFieldControlsListWidget(class_459 listWidget, class_310 minecraft) {
        assert (minecraft.field_1755 != null);
        this.searchField = new class_342(minecraft.field_1772, minecraft.field_1755.width / 2 - 125, 0, 250, 20, "");
        this.searchField.method_1887(class_1074.method_4662((String)"amecs.search.placeholder", (Object[])new Object[0]));
        this.searchField.method_1863(searchText -> {
            if (searchText.isEmpty()) {
                this.searchField.method_1887(class_1074.method_4662((String)"amecs.search.placeholder", (Object[])new Object[0]));
            } else {
                this.searchField.method_1887("");
            }
            searchText = searchText.trim();
            listWidget.setScrollAmount(0.0);
            List children = listWidget.children();
            if (this.allKeyEntries.isEmpty()) {
                for (class_459.class_461 entry : children) {
                    if (!(entry instanceof class_459.class_462)) continue;
                    this.allKeyEntries.add((class_459.class_462)entry);
                }
                this.lastChildrenCount = children.size();
            }
            if (children.size() != this.lastChildrenCount) {
                Amecs.log(Level.INFO, "Controls search results changed externally - recompiling the list!");
                try {
                    Constructor c = class_459.class_462.class.getDeclaredConstructor(class_459.class, class_304.class);
                    c.setAccessible(true);
                    this.allKeyEntries.clear();
                    Object[] keyBindings = minecraft.field_1690.field_1839;
                    Arrays.sort(keyBindings);
                    for (Object keyBinding : keyBindings) {
                        class_459.class_461 entry;
                        entry = (class_459.class_462)c.newInstance(listWidget, keyBinding);
                        this.allKeyEntries.add((class_459.class_462)entry);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Amecs.log(Level.ERROR, "An unexpected exception occurred during recompilation of controls list!", e);
                }
            }
            children.clear();
            children.add(this);
            String keyFilter = null;
            int keyDelimiterPos = searchText.indexOf(61);
            if (keyDelimiterPos == 0) {
                keyFilter = searchText.substring(1).trim();
                searchText = null;
            } else if (keyDelimiterPos > 0) {
                keyFilter = searchText.substring(keyDelimiterPos + 1).trim();
                searchText = searchText.substring(0, keyDelimiterPos).trim();
            }
            boolean nmuk = FabricLoader.getInstance().isModLoaded("nmuk");
            String lastCat = null;
            boolean lastMatched = false;
            boolean includeCat = false;
            for (class_459.class_462 entry : this.allKeyEntries) {
                class_304 binding = ((IKeyBindingEntry)entry).amecs$getKeyBinding();
                if (nmuk && lastMatched && NMUKProxy.isAlternative(binding)) {
                    children.add(entry);
                    continue;
                }
                String cat = binding.method_1423();
                if (!cat.equals(lastCat)) {
                    includeCat = StringUtils.containsIgnoreCase((CharSequence)class_1074.method_4662((String)cat, (Object[])new Object[0]), (CharSequence)searchText);
                }
                if ((includeCat || searchText == null || StringUtils.containsIgnoreCase((CharSequence)class_1074.method_4662((String)((IKeyBindingEntry)entry).amecs$getKeyBinding().method_1431(), (Object[])new Object[0]), (CharSequence)searchText)) && Amecs.entryKeyMatches(entry, keyFilter)) {
                    if (!cat.equals(lastCat)) {
                        class_459 class_4592 = listWidget;
                        Objects.requireNonNull(class_4592);
                        children.add(new class_459.class_460(class_4592, cat));
                        lastCat = cat;
                    }
                    children.add(entry);
                    lastMatched = true;
                    continue;
                }
                lastMatched = false;
            }
            if (children.size() <= 1) {
                class_459 class_4593 = listWidget;
                Objects.requireNonNull(class_4593);
                children.add(new class_459.class_460(class_4593, "amecs.search.no_results"));
            }
            this.lastChildrenCount = children.size();
        });
    }

    public List<? extends class_364> children() {
        return Collections.singletonList(this.searchField);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        return this.searchField.mouseClicked(double_1, double_2, int_1);
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        return this.searchField.mouseReleased(double_1, double_2, int_1);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        return this.searchField.keyPressed(int_1, int_2, int_3);
    }

    public boolean charTyped(char char_1, int int_1) {
        return this.searchField.charTyped(char_1, int_1);
    }

    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean var8, float tickDelta) {
        this.searchField.y = y;
        this.searchField.render(mouseX, mouseY, tickDelta);
    }

    public boolean changeFocus(boolean focused) {
        return this.searchField.changeFocus(focused);
    }
}

