/*
 * Copyright 2026 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.mixin;

import de.siphalor.amecs.gui.SearchFieldControlsListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_459;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_350.class)
public abstract class MixinEntryListWidget {
	@Shadow protected abstract int addEntry(class_350.class_351<?> entry);

	@Inject(method = "<init>", at = @At("RETURN"))
	//# if MC_VERSION_NUMBER >= 12003
	//- public void onConstruct(Minecraft client, int width, int height, int y0, int itemHeight, CallbackInfo ci) {
	//# else
	public void onConstruct(class_310 client, int width, int height, int y0, int y1, int itemHeight, CallbackInfo ci) {
	//# end
		//# if MC_VERSION_NUMBER >= 11802
		//noinspection ConstantValue,EqualsBetweenInconvertibleTypes
		if (getClass().equals(class_459.class)) {
			this.addEntry(new SearchFieldControlsListWidget((class_459) (Object) this, client));
		}
		//# else
		//- //noinspection ConstantValue,EqualsBetweenInconvertibleTypes
		//- if (getClass().equals(ControlList.class)) {
		//- 	this.addEntry(new SearchFieldControlsListWidget((ControlList) (Object) this, client));
		//- }
		//# end
	}
}
