/*
 * Copyright 2026 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.keybinding;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyMappingWithKeyModifiers;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifierCombination;
import net.minecraft.class_1664;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class SkinLayerKeyMapping extends AmecsKeyMappingWithKeyModifiers {
	private final class_1664 playerModelPart;

	public SkinLayerKeyMapping(
			class_2960 id,
			class_3675.class_307 type,
			int code,
			//# if MC_VERSION_NUMBER >= 12109
			class_11900 category,
			//# else
			//- String category,
			//# end
			class_1664 playerModelPart
	) {
		super(id, type, code, category, new AmecsKeyModifierCombination());
		this.playerModelPart = playerModelPart;
	}

	@Override
	public void onPressed() {
		class_310 client = class_310.method_1551();
		//# if MC_VERSION_NUMBER >= 12102
		client.field_1690.method_1635(playerModelPart, !client.field_1690.method_32594(playerModelPart));
		Amecs.sendToggleMessage(client.field_1724, client.field_1690.method_32594(playerModelPart), playerModelPart.method_7428());
		//# elif MC_VERSION_NUMBER >= 11700
		//- client.options.toggleModelPart(playerModelPart, !client.options.isModelPartEnabled(playerModelPart));
		//- Amecs.sendToggleMessage(client.player, client.options.isModelPartEnabled(playerModelPart), playerModelPart.getName());
		//# else
		//- client.options.toggleModelPart(playerModelPart);
		//- Amecs.sendToggleMessage(client.player, client.options.getModelParts().contains(playerModelPart), playerModelPart.getName());
		//# end
	}
}
