/*
 * Copyright 2026 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.key_mapping_descriptions.impl.mixin;

import java.util.ArrayList;
//- import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_459;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//- import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(EnvType.CLIENT)
//# if MC_VERSION_NUMBER >= 11800
@Mixin(class_459.class_462.class)
//# else
//- @Mixin(ControlList.KeyEntry.class)
//# end
public class MixinKeyBindingEntry {
	@Unique
	private static final String OLD_DESCRIPTION_SUFFIX = ".amecsapi.description";
	@Unique
	private static final String DESCRIPTION_SUFFIX = ".amecs.description";

	@Shadow
	@Final
	private class_304 key;
	@Shadow
	@Final
	private class_4185 changeButton;

	@Unique
	//# if MC_VERSION_NUMBER >= 12106
	//- private WidgetTooltipHolder description;
	//# elif MC_VERSION_NUMBER >= 11600
	private List<class_2561> description;
	//# else
	//- private List<String> description;
	//# end

	@Inject(method = "<init>", at = @At("RETURN"))
	public void onConstructed(
			/*# if MC_VERSION_NUMBER >= 11800 */class_459/*# else *//*- ControlList *//*# end */ parent,
			class_304 keyBinding,
			/*# if MC_VERSION_NUMBER >= 11600 */class_2561 text,/*# end */
			CallbackInfo callbackInfo
	) {
		String descriptionKey = key.method_1431() + OLD_DESCRIPTION_SUFFIX;
		if (!class_1074.method_4663(descriptionKey)) {
			descriptionKey = key.method_1431() + DESCRIPTION_SUFFIX;
		}
		if (!class_1074.method_4663(descriptionKey)) {
			description = null;
		} else {
			//# if MC_VERSION_NUMBER >= 12106
			//- description = new WidgetTooltipHolder();
			//- MutableComponent component = MutableComponent.create(new TranslatableContents(
			//- 		descriptionKey,
			//- 		"",
			//- 		new Object[0]
			//- ));
			//- description.set(Tooltip.create(component));
			//# elif MC_VERSION_NUMBER >= 11600
			String[] lines = StringUtils.split(class_1074.method_4662(descriptionKey), '\n');
			description = new ArrayList<>(lines.length);
			for (String line : lines) {
				//# if MC_VERSION_NUMBER >= 11900
				description.add(class_2561.method_43470(line));
				//# else
				//- description.add(new TextComponent(line));
				//# end
			}
			//# else
			//- description = Arrays.asList(StringUtils.split(I18n.get(descriptionKey), '\n'));
			//# end
		}
	}

	//# if MC_VERSION_NUMBER >= 12109
	//- @Inject(method = "renderContent", at = @At("RETURN"), locals = LocalCapture.CAPTURE_FAILSOFT)
	//- public void onRendered(
	//- 		GuiGraphics context,
	//- 		int mouseX,
	//- 		int mouseY,
	//- 		boolean hovered,
	//- 		float delta,
	//- 		CallbackInfo callbackInfo,
	//- 		int x,
	//- 		int y
	//- ) {
	//- 	//# elif MC_VERSION_NUMBER >= 12000
		//- @Inject(method = "render", at = @At("RETURN"))
		//- public void onRendered(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
		//# elif MC_VERSION_NUMBER >= 11600
		@Inject(method = "render", at = @At("RETURN"))
		public void onRendered(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
		//# else
		//- @Inject(method = "render", at = @At("RETURN"))
		//- public void onRendered(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta, CallbackInfo callbackInfo) {
		//# end
		if (description != null) {
			//# if MC_VERSION_NUMBER >= 12109
			//- description.refreshTooltipForNextRenderPass(
			//- 		context,
			//- 		mouseX,
			//- 		mouseY,
			//- 		isMouseOverTitle(y, 20, mouseX, mouseY),
			//- 		changeButton.isFocused(),
			//- 		new ScreenRectangle(x, y, changeButton.getX(), 20)
			//- );
			//# elif MC_VERSION_NUMBER >= 12106
			//- description.refreshTooltipForNextRenderPass(
			//- 		context,
			//- 		mouseX,
			//- 		mouseY,
			//- 		isMouseOverTitle(y, entryHeight, mouseX, mouseY),
			//- 		changeButton.isFocused(),
			//- 		new ScreenRectangle(x, y, entryWidth, entryHeight)
			//- );
			//# else
			if (isMouseOverTitle(y, entryHeight, mouseX, mouseY)) {
				//# if MC_VERSION_NUMBER >= 12000
				//- context.renderComponentTooltip(Minecraft.getInstance().font, description, mouseX, mouseY);
				//# elif MC_VERSION_NUMBER >= 11600
				class_310.method_1551().field_1755.method_30901(poseStack, description, mouseX, mouseY);
				//# else
				//- Minecraft.getInstance().screen.renderTooltip(description, mouseX, mouseY);
				//# end
			}
			//# end
		}
	}

	@Unique
	private boolean isMouseOverTitle(int y, int entryHeight, int mouseX, int mouseY) {
		//# if MC_VERSION_NUMBER >= 11903
		//- return mouseY >= y && mouseY < y + entryHeight && mouseX < changeButton.getX();
		//# else
		return mouseY >= y && mouseY < y + entryHeight && mouseX < changeButton.field_22760;
		//# end
	}
}
