/*
 * Copyright 2020 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.key_modifiers.impl.mixin;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifierCombination;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiers;
import de.siphalor.amecs.key_modifiers.impl.KeyBindingEditGuiHelper;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_458;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("WeakerAccess")
@Environment(EnvType.CLIENT)
//# if MC_VERSION_NUMBER >= 11800
//- @Mixin(KeyBindsScreen.class)
//# else
@Mixin(class_458.class)
//# end
public abstract class MixinKeybindsScreen
		extends /*# if MC_VERSION_NUMBER >= 11500 *//*- OptionsSubScreen *//*# else */class_437/*# end */ {
	@Shadow
	public class_304 selectedKey;

	@Shadow
	public long lastKeySelection;

	//# if MC_VERSION_NUMBER >= 11904
	//- @Shadow private KeyBindsList keyBindsList;
	//# end

	//# if MC_VERSION_NUMBER < 11500
	@Shadow @Final
	private class_315 options;
	//#end

	//# if MC_VERSION_NUMBER >= 11500
	//- public MixinKeybindsScreen(Screen screen, Options gameOptions, Component text) {
	//- 	super(screen, gameOptions, text);
	//- }
	//# else
	public MixinKeybindsScreen(class_2561 title) {
		super(title);
	}
	//# end

	@Inject(
			method = "mouseClicked",
			//# if MC_VERSION_NUMBER >= 12102
			//- at = @At(value = "INVOKE", target = "Lnet/minecraft/client/KeyMapping;setKey(Lcom/mojang/blaze3d/platform/InputConstants$Key;)V")
			//# else
			at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Options;setKey(Lnet/minecraft/client/KeyMapping;Lcom/mojang/blaze3d/platform/InputConstants$Key;)V")
			//# end
	)
	public void onClicked(
			//# if MC_VERSION_NUMBER >= 12109
			//- MouseButtonEvent mouseButtonEvent,
			//- boolean bl,
			//# else
			double x,
			double y,
			int type,
			//# end
			CallbackInfoReturnable<Boolean> callbackInfoReturnable
	) {
		class_3675.class_306 key = ((IKeyMapping) selectedKey).amecs$getBoundKey();
		AmecsKeyModifierCombination keyModifiers = ((IKeyMapping) selectedKey).amecs$getBoundKeyModifiers();
		if (!key.equals(class_3675.field_16237)) {
			AmecsKeyModifier modifier = AmecsKeyModifiers.fromKey(key);
			if (modifier != null) {
				keyModifiers.set(modifier, true);
			}
		}
	}

	@Inject(
			method = "keyPressed",
			at = @At(
					value = "INVOKE",
					//# if MC_VERSION_NUMBER >= 12102
					//- target = "Lnet/minecraft/client/KeyMapping;setKey(Lcom/mojang/blaze3d/platform/InputConstants$Key;)V",
					//# else
					target = "Lnet/minecraft/client/Options;setKey(Lnet/minecraft/client/KeyMapping;Lcom/mojang/blaze3d/platform/InputConstants$Key;)V",
					//# end
					ordinal = 1
			),
			cancellable = true
	)
	public void onKeyPressed(
			//# if MC_VERSION_NUMBER >= 12109
			//- KeyEvent keyEvent,
			//# else
			int keyCode,
			int scanCode,
			int modifiers,
			//# end
			CallbackInfoReturnable<Boolean> callbackInfoReturnable
	) {
		//# if MC_VERSION_NUMBER >= 12109
		//- InputConstants.Key key = InputConstants.getKey(keyEvent);
		//# else
		class_3675.class_306 key = class_3675.method_15985(keyCode, scanCode);
		//# end

		KeyBindingEditGuiHelper.handleKeyPress(selectedKey, key);

		this.lastKeySelection = class_156.method_658();
		//# if MC_VERSION_NUMBER >= 11904
		//- this.keyBindsList.resetMappingAndUpdateButtons();
		//# else
		class_304.method_1426();
		//# end
		callbackInfoReturnable.setReturnValue(true);
	}
}
