/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;

@Environment(value=EnvType.CLIENT)
public class ModifierPrefixTextProvider {
    private static final String SUFFIX = " + ";
    private static final String COMPRESSED_SUFFIX = "+";
    private final String translationKey;

    public ModifierPrefixTextProvider(AmecsKeyModifier modifier) {
        this(modifier.getTranslationKey());
    }

    public ModifierPrefixTextProvider(String translationKey) {
        this.translationKey = translationKey;
    }

    public String getComponent(Variation variation) {
        String text = variation.getTranslation(this.translationKey);
        text = variation == Variation.COMPRESSED ? text + COMPRESSED_SUFFIX : text + SUFFIX;
        return text;
    }

    public static enum Variation {
        COMPRESSED(".tiny"),
        TINY(".tiny"),
        SHORT(".short"),
        NORMAL("");

        public static final Variation[] VALUES;
        public static final Variation WIDEST;
        public static final Variation SMALLEST;
        public final String translateKeySuffix;

        private Variation(String translateKeySuffix) {
            this.translateKeySuffix = translateKeySuffix;
        }

        public String getTranslation(String translationKey) {
            return class_1074.method_4662((String)(translationKey + this.translateKeySuffix), (Object[])new Object[0]);
        }

        public Variation getNextVariation(int amount) {
            int targetOrdinal = this.ordinal() + amount;
            if (targetOrdinal < 0 || targetOrdinal >= VALUES.length) {
                return null;
            }
            return VALUES[targetOrdinal];
        }

        public Variation getSmaller() {
            return this.getNextVariation(-1);
        }

        static {
            VALUES = Variation.values();
            WIDEST = NORMAL;
            SMALLEST = COMPRESSED;
        }
    }
}

