/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.api;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.impl.DefaultKeyModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AmecsKeyModifiers {
    private static final Map<String, AmecsKeyModifier> MODIFIERS_BY_NAME = new HashMap<String, AmecsKeyModifier>();
    static final List<AmecsKeyModifier> MODIFIERS = new ArrayList<AmecsKeyModifier>(5);
    private static boolean sealed = false;
    public static AmecsKeyModifier ALT = new DefaultKeyModifier("alt", 0, 342, 346);
    public static AmecsKeyModifier SHIFT = new DefaultKeyModifier("shift", 2, 340, 344);
    public static AmecsKeyModifier CONTROL = new DefaultKeyModifier("control", 1, 341, 345);

    public static void register(AmecsKeyModifier keyModifier) {
        AmecsKeyModifiers.requireUnsealed();
        keyModifier.arrayIndex = MODIFIERS.size();
        MODIFIERS_BY_NAME.put(keyModifier.getName(), keyModifier);
        MODIFIERS.add(keyModifier);
    }

    @ApiStatus.Internal
    public static void seal() {
        AmecsKeyModifiers.requireUnsealed();
        sealed = true;
    }

    public static Collection<AmecsKeyModifier> getAll() {
        AmecsKeyModifiers.requireSealed();
        return MODIFIERS;
    }

    @Nullable
    public static AmecsKeyModifier getByName(String name) {
        return MODIFIERS_BY_NAME.get(name);
    }

    @Nullable
    public static AmecsKeyModifier fromKeyCode(int keyCode) {
        AmecsKeyModifiers.requireSealed();
        for (AmecsKeyModifier keyModifier : MODIFIERS_BY_NAME.values()) {
            if (!keyModifier.matches(keyCode)) continue;
            return keyModifier;
        }
        return null;
    }

    @Nullable
    public static AmecsKeyModifier fromKey(class_3675.class_306 key) {
        AmecsKeyModifiers.requireSealed();
        if (key == null || key.method_1442() != class_3675.class_307.field_1668) {
            return null;
        }
        return AmecsKeyModifiers.fromKeyCode(key.method_1444());
    }

    private static void requireUnsealed() {
        if (sealed) {
            throw new IllegalStateException("Cannot register new key modifiers after the API has been sealed");
        }
    }

    private static void requireSealed() {
        if (!sealed) {
            throw new IllegalStateException("Cannot access key modifiers before the API has been sealed");
        }
    }

    @Generated
    private AmecsKeyModifiers() {
    }
}

