/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifierCombination;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiers;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiersApi;
import de.siphalor.amecs.key_modifiers.impl.AmecsKeyMappingManagerLayer;
import de.siphalor.amecs.key_modifiers.impl.AmecsKeyModifiersModule;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class AmecsKeyMappingManager {
    private static final List<AmecsKeyMappingManagerLayer> LAYERS = new ArrayList<AmecsKeyMappingManagerLayer>();
    private static final List<class_304> PRESSED_MAPPINGS = new ArrayList<class_304>(10);

    private AmecsKeyMappingManager() {
    }

    public static void prependLayer(AmecsKeyMappingManagerLayer layer) {
        LAYERS.add(0, layer);
    }

    public static boolean register(class_304 mapping) {
        for (AmecsKeyMappingManagerLayer layer : LAYERS) {
            if (!layer.accepts(mapping)) continue;
            return layer.register(mapping);
        }
        return false;
    }

    public static void onKeyPressed(class_3675.class_306 input) {
        for (AmecsKeyMappingManagerLayer layer : LAYERS) {
            layer.getMappingsForInput(input).forEach(keyBinding -> ((IKeyMapping)keyBinding).amecs$incrementTimesPressed());
        }
    }

    public static void updatePressedStates() {
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        for (AmecsKeyMappingManagerLayer layer : LAYERS) {
            layer.getAllMappings().forEach(keyBinding -> {
                class_3675.class_306 key = ((IKeyMapping)keyBinding).amecs$getBoundKey();
                boolean pressed = !keyBinding.method_1415() && key.method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((long)windowHandle, (int)key.method_1444());
                AmecsKeyMappingManager.setKeyBindingPressed(keyBinding, pressed);
            });
        }
    }

    public static boolean unregister(class_304 keyBinding) {
        if (keyBinding == null) {
            return false;
        }
        boolean removed = false;
        for (AmecsKeyMappingManagerLayer layer : LAYERS) {
            removed |= layer.unregister(keyBinding);
        }
        return removed;
    }

    public static void updateKeysByCode() {
        LAYERS.forEach(AmecsKeyMappingManagerLayer::clear);
        AmecsKeyModifiersModule.getIdToKeyBindingMap().values().forEach(AmecsKeyMappingManager::register);
    }

    public static void setKeyBindingPressed(class_304 keyBinding, boolean pressed) {
        if (pressed != keyBinding.method_1434()) {
            if (pressed) {
                PRESSED_MAPPINGS.add(keyBinding);
            } else {
                PRESSED_MAPPINGS.remove(keyBinding);
            }
        }
        keyBinding.method_23481(pressed);
    }

    public static void unpressAll() {
        AmecsKeyModifiersModule.getIdToKeyBindingMap().values().forEach(keyBinding -> ((IKeyMapping)keyBinding).amecs$reset());
    }

    public static void setKeyPressed(class_3675.class_306 keyCode, boolean pressed) {
        AmecsKeyModifier modifier = AmecsKeyModifiers.fromKeyCode(keyCode.method_1444());
        if (modifier != null) {
            AmecsKeyModifiersModule.CURRENT_MODIFIERS.set(modifier, pressed);
        }
        for (AmecsKeyMappingManagerLayer layer : LAYERS) {
            layer.getMappingsForInput(keyCode).forEach(keyBinding -> AmecsKeyMappingManager.setKeyBindingPressed(keyBinding, pressed));
        }
        if (modifier != null && !pressed) {
            AmecsKeyMappingManager.handleReleasedModifier();
        }
    }

    private static void handleReleasedModifier() {
        PRESSED_MAPPINGS.removeIf(pressedKeyBinding -> {
            AmecsKeyModifierCombination boundModifiers = AmecsKeyModifiersApi.getBoundModifiers(pressedKeyBinding);
            if (!AmecsKeyModifiersModule.CURRENT_MODIFIERS.contains(boundModifiers)) {
                pressedKeyBinding.method_23481(false);
                return true;
            }
            return false;
        });
    }

    static {
        LAYERS.add(new AmecsKeyMappingManagerLayer());
    }
}

