/*
 * Copyright 2026 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiersApi;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import java.util.*;
import java.util.stream.Stream;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class AmecsKeyMappingManagerLayer {
	private final Map<class_3675.class_306, Collection<class_304>> mappingsByInput = new HashMap<>(100);

	public void clear() {
		mappingsByInput.clear();
	}

	public boolean register(class_304 mapping) {
		if (!accepts(mapping)) return false;

		class_3675.class_306 boundInput = ((IKeyMapping) mapping).amecs$getBoundKey();

		Collection<class_304> mappingsForInput = mappingsByInput.computeIfAbsent(boundInput, k -> new ArrayList<>());
		if (mappingsForInput.add(mapping)) {
			return false;
		}
		return mappingsForInput.add(mapping);
	}

	public boolean accepts(class_304 mapping) {
		return true;
	}

	public boolean unregister(class_304 mapping) {
		class_3675.class_306 boundInput = ((IKeyMapping) mapping).amecs$getBoundKey();

		Collection<class_304> mappingsForInput = mappingsByInput.get(boundInput);
		if (mappingsForInput == null) return false;

		return mappingsForInput.removeAll(Collections.singleton(mapping));
	}

	public Stream<class_304> getAllMappings() {
		return mappingsByInput.values().stream().flatMap(Collection::stream);
	}

	public Stream<class_304> getMappingsForInput(class_3675.class_306 input) {
		Collection<class_304> mappingsForInput = mappingsByInput.getOrDefault(input, Collections.emptyList());
		if (mappingsForInput.isEmpty()) return Stream.empty();

		// If there are two key bindings, alt + y and shift + y, and you press shift + alt + y, both will be triggered.
		// This is intentional.
		List<class_304> matchingMappings = mappingsForInput.stream()
				.filter(AmecsKeyMappingManagerLayer::areExactModifiersPressed)
				.toList();
		if (matchingMappings.isEmpty())
			return mappingsForInput.stream().filter(mapping -> AmecsKeyModifiersApi.getBoundModifiers(mapping).isUnset());
		return matchingMappings.stream();
	}

	private static boolean areExactModifiersPressed(class_304 keyBinding) {
		return AmecsKeyModifiersApi.getBoundModifiers(keyBinding).equals(AmecsKeyModifiersModule.CURRENT_MODIFIERS);
	}
}
