/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiersApi;
import de.siphalor.amecs.key_modifiers.impl.AmecsKeyModifiersModule;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class AmecsKeyMappingManagerLayer {
    private final Map<class_3675.class_306, Collection<class_304>> mappingsByInput = new HashMap<class_3675.class_306, Collection<class_304>>(100);

    public void clear() {
        this.mappingsByInput.clear();
    }

    public boolean register(class_304 mapping) {
        if (!this.accepts(mapping)) {
            return false;
        }
        class_3675.class_306 boundInput = ((IKeyMapping)mapping).amecs$getBoundKey();
        Collection mappingsForInput = this.mappingsByInput.computeIfAbsent(boundInput, k -> new ArrayList());
        if (mappingsForInput.add(mapping)) {
            return false;
        }
        return mappingsForInput.add(mapping);
    }

    public boolean accepts(class_304 mapping) {
        return true;
    }

    public boolean unregister(class_304 mapping) {
        class_3675.class_306 boundInput = ((IKeyMapping)mapping).amecs$getBoundKey();
        Collection<class_304> mappingsForInput = this.mappingsByInput.get(boundInput);
        if (mappingsForInput == null) {
            return false;
        }
        return mappingsForInput.removeAll(Collections.singleton(mapping));
    }

    public Stream<class_304> getAllMappings() {
        return this.mappingsByInput.values().stream().flatMap(Collection::stream);
    }

    public Stream<class_304> getMappingsForInput(class_3675.class_306 input) {
        Collection mappingsForInput = this.mappingsByInput.getOrDefault(input, Collections.emptyList());
        if (mappingsForInput.isEmpty()) {
            return Stream.empty();
        }
        List<class_304> matchingMappings = mappingsForInput.stream().filter(AmecsKeyMappingManagerLayer::areExactModifiersPressed).toList();
        if (matchingMappings.isEmpty()) {
            return mappingsForInput.stream().filter(mapping -> AmecsKeyModifiersApi.getBoundModifiers(mapping).isUnset());
        }
        return matchingMappings.stream();
    }

    private static boolean areExactModifiersPressed(class_304 keyBinding) {
        return AmecsKeyModifiersApi.getBoundModifiers(keyBinding).equals(AmecsKeyModifiersModule.CURRENT_MODIFIERS);
    }
}

