/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifierCombination;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiers;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiersApi;
import de.siphalor.amecs.key_modifiers.impl.AmecsKeyModifiersModule;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class AmecsKeyModifierOptions {
    @Generated
    private static final Logger log = LogManager.getLogger(AmecsKeyModifierOptions.class);
    private static final String KEY_MODIFIERS_PREFIX = "key_modifiers_";
    private static final File OLD_OPTIONS_FILE = new File(class_310.method_1551().field_1697, "options.amecsapi.txt");
    private static final File OPTIONS_FILE = new File(class_310.method_1551().field_1697, "options.amecs.key_modifiers.txt");
    private static final Int2ObjectMap<AmecsKeyModifier> KEY_MODIFIERS_BY_LEGACY_ID = new Int2ObjectArrayMap();

    private static void initLegacyModifiers() {
        AmecsKeyModifiers.getAll().forEach(modifier -> {
            if (modifier.getLegacyId() != null) {
                KEY_MODIFIERS_BY_LEGACY_ID.put(modifier.getLegacyId().intValue(), modifier);
            }
        });
    }

    public static void write(class_304[] allKeyBindings) {
        AmecsKeyModifierOptions.initLegacyModifiers();
        ArrayList<class_304> bindingsWithChangedModifiers = new ArrayList<class_304>(allKeyBindings.length);
        for (class_304 keyBinding : allKeyBindings) {
            if (keyBinding.method_1427()) continue;
            bindingsWithChangedModifiers.add(keyBinding);
        }
        if (bindingsWithChangedModifiers.isEmpty()) {
            if (OPTIONS_FILE.exists()) {
                try {
                    Files.delete(OPTIONS_FILE.toPath());
                }
                catch (IOException e) {
                    log.error("Failed to cleanup Amecs API key binding modifier file - weird.", (Throwable)e);
                }
            }
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(OPTIONS_FILE, StandardCharsets.UTF_8));){
            for (class_304 binding : bindingsWithChangedModifiers) {
                AmecsKeyModifierCombination modifiers = AmecsKeyModifiersApi.getBoundModifiers(binding);
                writer.write(KEY_MODIFIERS_PREFIX);
                writer.write(binding.method_1431());
                writer.write(": ");
                writer.write(AmecsKeyModifierOptions.serializeKeyModifiers(modifiers));
                ((Writer)writer).write(10);
            }
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            log.error("Failed to save Amecs API modifiers to options file", (Throwable)e);
        }
    }

    public static void read() {
        AmecsKeyModifierOptions.initLegacyModifiers();
        File optionsFile = OLD_OPTIONS_FILE.exists() ? OLD_OPTIONS_FILE : OPTIONS_FILE;
        try (BufferedReader reader = new BufferedReader(new FileReader(optionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                AmecsKeyModifierOptions.readLine(line);
            }
            if (optionsFile == OLD_OPTIONS_FILE) {
                optionsFile.delete();
            }
        }
        catch (IOException e) {
            log.error("Failed to load Amecs API options file", (Throwable)e);
        }
    }

    private static void readLine(String line) {
        try {
            int colon = line.indexOf(58);
            if (colon <= 0) {
                log.warn("Invalid line in Amecs API options file: {}", (Object)line);
                return;
            }
            String id = line.substring(0, colon);
            if (!id.startsWith(KEY_MODIFIERS_PREFIX)) {
                log.warn("Invalid entry in Amecs API options file: {}", (Object)id);
                return;
            }
            id = id.substring(KEY_MODIFIERS_PREFIX.length());
            class_304 mapping = AmecsKeyModifiersModule.getIdToKeyBindingMap().get(id);
            if (mapping == null) {
                log.warn("Unknown keybinding identifier in Amecs API options file: {}", (Object)id);
                return;
            }
            AmecsKeyModifierCombination modifiers = AmecsKeyModifierOptions.deserializeKeyModifiers(line.substring(colon + 1));
            if (mapping.method_1415()) {
                if (!modifiers.isUnset()) {
                    log.warn("Found modifiers for unbound keybinding in Amecs API options file. Ignoring them: {}", (Object)id);
                }
                return;
            }
            AmecsKeyModifiersApi.getBoundModifiers(mapping).copyFrom(modifiers);
        }
        catch (Throwable e) {
            log.error("Invalid line in Amecs API options file: {}", (Object)line, (Object)e);
        }
    }

    @ApiStatus.Internal
    public static String serializeKeyModifiers(AmecsKeyModifierCombination keyModifiers) {
        Collection<AmecsKeyModifier> modifiers = keyModifiers.getAll();
        if (modifiers.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AmecsKeyModifier modifier : modifiers) {
            sb.append(modifier.getName()).append(",");
        }
        sb.setLength(sb.length() - ",".length());
        return sb.toString();
    }

    private static AmecsKeyModifierCombination deserializeKeyModifiers(String value) {
        if ((value = value.trim()).isEmpty()) {
            return AmecsKeyModifierCombination.NO_MODIFIERS;
        }
        AmecsKeyModifierCombination keyModifiers = new AmecsKeyModifierCombination();
        if (!value.contains(",")) {
            try {
                long packedModifiers = Long.parseLong(value, 16);
                for (AmecsKeyModifier keyModifier : AmecsKeyModifiers.getAll()) {
                    if (keyModifier.getLegacyId() == null) continue;
                    long mask = 1L << keyModifier.getLegacyId();
                    keyModifiers.set(keyModifier, (packedModifiers & mask) == mask);
                }
                return keyModifiers;
            }
            catch (NumberFormatException packedModifiers) {
                // empty catch block
            }
        }
        int i = 0;
        for (String part : value.split(",")) {
            if ("1".equals(part = part.trim())) {
                modifier = (AmecsKeyModifier)KEY_MODIFIERS_BY_LEGACY_ID.get(i);
                if (modifier != null) {
                    keyModifiers.set(modifier, true);
                }
            } else if (!"0".equals(part)) {
                modifier = AmecsKeyModifiers.getByName(part);
                if (modifier != null) {
                    keyModifiers.set(modifier, false);
                } else {
                    log.warn("Encountered unknown key modifier {} in config file, modifier will not be applied", (Object)part);
                }
            }
            ++i;
        }
        return keyModifiers;
    }

    @Generated
    private AmecsKeyModifierOptions() {
    }
}

