/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.key_modifiers.api;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiers;
import de.siphalor.amecs.key_modifiers.impl.AmecsKeyModifiersModule;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class AmecsKeyModifierCombination {
    public static final AmecsKeyModifierCombination NO_MODIFIERS = new Immutable();
    private boolean[] value;

    public static AmecsKeyModifierCombination getCurrentlyPressed() {
        return AmecsKeyModifiersModule.CURRENT_MODIFIERS;
    }

    public AmecsKeyModifierCombination(boolean alt, boolean control, boolean shift) {
        this();
        this.setAlt(alt);
        this.setControl(control);
        this.setShift(shift);
    }

    public AmecsKeyModifierCombination(AmecsKeyModifier ... modifiers) {
        this();
        for (AmecsKeyModifier modifier : modifiers) {
            this.requireModifierRegistered(modifier);
            this.set(modifier, true);
        }
    }

    public AmecsKeyModifierCombination() {
        this(new boolean[AmecsKeyModifiers.MODIFIERS.size()]);
    }

    private AmecsKeyModifierCombination(boolean[] value) {
        if (value.length > AmecsKeyModifiers.MODIFIERS.size()) {
            throw new IllegalArgumentException("value.length > KeyModifier.getModifierCount(): " + AmecsKeyModifiers.MODIFIERS.size());
        }
        this.value = value;
    }

    public boolean contains(AmecsKeyModifierCombination other) {
        for (int i = 0; i < this.value.length; ++i) {
            if (!other.value[i] || this.value[i]) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    public void copyFrom(AmecsKeyModifierCombination other) {
        this.value = (boolean[])other.value.clone();
    }

    public AmecsKeyModifierCombination setAlt(boolean value) {
        this.setUnchecked(AmecsKeyModifiers.ALT, value);
        return this;
    }

    public boolean getAlt() {
        return this.getUnchecked(AmecsKeyModifiers.ALT);
    }

    public AmecsKeyModifierCombination setControl(boolean value) {
        this.setUnchecked(AmecsKeyModifiers.CONTROL, value);
        return this;
    }

    public boolean getControl() {
        return this.getUnchecked(AmecsKeyModifiers.CONTROL);
    }

    public AmecsKeyModifierCombination setShift(boolean value) {
        this.setUnchecked(AmecsKeyModifiers.SHIFT, value);
        return this;
    }

    public boolean getShift() {
        return this.getUnchecked(AmecsKeyModifiers.SHIFT);
    }

    public void set(AmecsKeyModifier keyModifier, boolean value) {
        if (keyModifier.arrayIndex >= this.value.length) {
            this.requireModifierRegistered(keyModifier);
            this.value = Arrays.copyOf(this.value, AmecsKeyModifiers.MODIFIERS.size());
        }
        this.setUnchecked(keyModifier, value);
    }

    public boolean get(AmecsKeyModifier keyModifier) {
        this.requireModifierRegistered(keyModifier);
        if (keyModifier.arrayIndex >= this.value.length) {
            return false;
        }
        return this.getUnchecked(keyModifier);
    }

    private void requireModifierRegistered(AmecsKeyModifier keyModifier) {
        if (!keyModifier.isRegistered()) {
            throw new IllegalArgumentException("Modifier " + keyModifier.getTranslationKey() + " is not registered yet");
        }
    }

    private void setUnchecked(AmecsKeyModifier keyModifier, boolean value) {
        this.value[keyModifier.arrayIndex] = value;
    }

    private boolean getUnchecked(AmecsKeyModifier keyModifier) {
        return this.value[keyModifier.arrayIndex];
    }

    public Collection<AmecsKeyModifier> getAll() {
        ArrayList<AmecsKeyModifier> result = new ArrayList<AmecsKeyModifier>(AmecsKeyModifiers.MODIFIERS.size());
        for (int i = 0; i < this.value.length; ++i) {
            if (!this.value[i]) continue;
            result.add(AmecsKeyModifiers.MODIFIERS.get(i));
        }
        return result;
    }

    public boolean isUnset() {
        return !ArrayUtils.contains((boolean[])this.value, (boolean)true);
    }

    public void unset() {
        Arrays.fill(this.value, false);
    }

    public void cleanup(class_304 keyBinding) {
        class_3675.class_306 key = ((IKeyMapping)keyBinding).amecs$getBoundKey();
        AmecsKeyModifier keyModifier = AmecsKeyModifiers.fromKey(key);
        if (keyModifier != null) {
            this.set(keyModifier, false);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AmecsKeyModifierCombination) {
            return this.equals((AmecsKeyModifierCombination)obj);
        }
        return false;
    }

    public boolean equals(AmecsKeyModifierCombination other) {
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return "AmecsK [alt=" + this.getAlt() + ", control=" + this.getControl() + ", shift=" + this.getShift() + "]";
    }

    private static class Immutable
    extends AmecsKeyModifierCombination {
        private static final String EXCEPTION_MESSAGE = "You must not alter this Modifiers object";

        private Immutable() {
        }

        @Override
        public AmecsKeyModifierCombination setAlt(boolean value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public AmecsKeyModifierCombination setControl(boolean value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public AmecsKeyModifierCombination setShift(boolean value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void copyFrom(AmecsKeyModifierCombination other) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void set(AmecsKeyModifier keyModifier, boolean value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void unset() {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }
    }
}

