/*
 * Copyright 2020 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.siphalor.amecs.key_modifiers.impl;

import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifier;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifierCombination;
import de.siphalor.amecs.key_modifiers.api.AmecsKeyModifiers;
import de.siphalor.amecs.key_modifiers.impl.duck.IKeyMapping;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class KeyBindingEditGuiHelper {
	public static void handleKeyPress(class_304 keyBinding, class_3675.class_306 key) {
		if (keyBinding.method_1415()) {
			keyBinding.method_1422(key);
		} else {
			handleAdditionalKeyPress(keyBinding, key);
		}
	}

	public static void handleAdditionalKeyPress(class_304 keyBinding, class_3675.class_306 nextKey) {
		class_3675.class_306 mainKey = ((IKeyMapping) keyBinding).amecs$getBoundKey();
		AmecsKeyModifierCombination keyModifiers = ((IKeyMapping) keyBinding).amecs$getBoundKeyModifiers();
		AmecsKeyModifier mainKeyModifier = AmecsKeyModifiers.fromKey(mainKey);

		AmecsKeyModifier nextKeyModifier = AmecsKeyModifiers.fromKey(nextKey);

		if (nextKeyModifier == null) {
			if (mainKeyModifier != null) {
				// swap'em around
				keyModifiers.set(mainKeyModifier, true);
				setKey(keyBinding, nextKey);
			} else {
				// shouldn't happen, as editing should already have been aborted
				setKey(keyBinding, nextKey);
			}
		} else {
			// add to existing modifiers
			keyModifiers.set(nextKeyModifier, true);
			if (mainKeyModifier != null) {
				// special case, if e.g. both left and right shift are pressed:
				// we don't want to end up with Shift + Shift
				keyModifiers.set(mainKeyModifier, false);
			}
		}
	}

	private static void setKey(class_304 keyBinding, class_3675.class_306 key) {
		//# if MC_VERSION_NUMBER >= 12102
		keyBinding.method_1422(key);
		//# else
		//- Minecraft.getInstance().options.setKey(keyBinding, key);
		//# end
	}
}
