package de.siphalor.amecs.gui;

//- import com.mojang.blaze3d.vertex.PoseStack;
import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.compat.NMUKProxy;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import lombok.val;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_459;
import net.minecraft.class_459.class_460;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
//- import net.minecraft.network.chat.TextComponent;
//- import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

@Environment(EnvType.CLIENT)
public class SearchFieldControlsListWidget
		//# if MC_VERSION_NUMBER >= 11802
		extends class_459.class_461
		//# else
		//- extends ControlList.Entry
		//# end
{
	private final class_342 searchField;

	private int lastEntryCount = 0;
	//# if MC_VERSION_NUMBER >= 11802
	private final Set<class_459.class_462> entries =
	//# else
	//- private final Set<ControlList.KeyEntry> entries =
	//# end
			new TreeSet<>(Comparator.comparing(o -> ((IKeyBindingEntry) o).amecs$getKeyBinding()));

	public SearchFieldControlsListWidget(
			//# if MC_VERSION_NUMBER >= 11802
			class_459 listWidget,
			//# else
			//- ControlList listWidget,
			//# end
			class_310 minecraft
	) {
		class_327 font = minecraft.field_1772;
		assert minecraft.field_1755 != null;

		//# if MC_VERSION_NUMBER >= 12109
		//- setHeight(20);
		//# end
		searchField = new class_342(
				font,
				minecraft.field_1755.field_22789 / 2 - 125,
				0,
				250,
				20,
				//# if MC_VERSION_NUMBER >= 11900
				class_2561.method_43473()
				//# else
				//- TextComponent.EMPTY
				//# end
		);
		searchField.method_1887(class_1074.method_4662("amecs.search.placeholder"));
		searchField.method_1863(searchText -> {
			if (searchText.isEmpty()) {
				searchField.method_1887(class_1074.method_4662("amecs.search.placeholder"));
			} else {
				searchField.method_1887("");
			}

			searchText = searchText.trim();
			listWidget.method_25307(0);

			//# if MC_VERSION_NUMBER >= 12109
			//- val children = new ArrayList<>(listWidget.children());
			//# else
			val children = listWidget.method_25396();
			//# end
			if (entries.isEmpty()) {
				//# if MC_VERSION_NUMBER >= 11802
				for (class_459.class_461 entry : children) {
					if (entry instanceof class_459.class_462) {
						entries.add((class_459.class_462) entry);
					}
				}
				//# else
				//- for (ControlList.Entry entry : children) {
				//- 	if (entry instanceof ControlList.KeyEntry) {
				//- 		entries.add((ControlList.KeyEntry) entry);
				//- 	}
				//- }
				//# end
				lastEntryCount = children.size();
			}
			int childrenCount = children.size();
			if (childrenCount != lastEntryCount) {
				Amecs.log(Level.INFO, "Controls search results changed externally - recompiling the list!");
				try {
					//# if MC_VERSION_NUMBER >= 11802
					Constructor<class_459.class_462> c = class_459.class_462.class.getDeclaredConstructor(
							class_459.class, class_304.class, class_2561.class
					);
					class_459.class_462 entry;
					//# else
					//- Constructor<ControlList.KeyEntry> c = ControlList.KeyEntry.class.getDeclaredConstructor(
					//- 		ControlList.class, KeyMapping.class, Component.class
					//- );
					//- ControlList.KeyEntry entry;
					//# end
					entries.clear();
					class_304[] keyBindings = minecraft.field_1690.field_1839;
					Arrays.sort(keyBindings);
					//# if MC_VERSION_NUMBER >= 12109
					//- KeyMapping.Category lastCat = null;
					//# else
					String lastCat = null;
					//# end
					lastEntryCount = 1;
					for (class_304 keyBinding : keyBindings) {
						if (!Objects.equals(lastCat, keyBinding.method_1423())) {
							lastCat = keyBinding.method_1423();
							//# if MC_VERSION_NUMBER >= 12109
							//- children.add(listWidget.new CategoryEntry(keyBinding.getCategory()));
							//# elif MC_VERSION_NUMBER >= 11900
							children.add(listWidget.new class_460(class_2561.method_43471(keyBinding.method_1423())));
							//# else
							//- children.add(listWidget.new CategoryEntry(new TranslatableComponent(keyBinding.getCategory())));
							//# end
							lastEntryCount++;
						}
						//# if MC_VERSION_NUMBER >= 11900
						entry = c.newInstance(listWidget, keyBinding, class_2561.method_43471(keyBinding.method_1431()));
						//# else
						//- entry = c.newInstance(listWidget, keyBinding, new TranslatableComponent(keyBinding.getName()));
						//# end
						children.add(entry);
						entries.add(entry);
						lastEntryCount++;
					}
				} catch (NoSuchMethodException | InstantiationException | IllegalAccessException | InvocationTargetException e) {
					Amecs.log(Level.ERROR, "An unexpected exception occurred during recompilation of controls list!", e);
				}
			}

			children.clear();

			children.add(this);

			String keyFilter = null;
			int keyDelimiterPos = searchText.indexOf('=');
			if (keyDelimiterPos == 0) {
				keyFilter = searchText.substring(1).trim();
				searchText = null;
			} else if (keyDelimiterPos > 0) {
				keyFilter = searchText.substring(keyDelimiterPos + 1).trim();
				searchText = searchText.substring(0, keyDelimiterPos).trim();
			}

			final boolean nmuk = FabricLoader.getInstance().isModLoaded("nmuk");
			//# if MC_VERSION_NUMBER >= 12109
			//- KeyMapping.Category lastCat = null;
			//# else
			String lastCat = null;
			//# end
			boolean lastMatched = false;
			boolean includeCat = false;
			lastEntryCount = 1;
			//# if MC_VERSION_NUMBER >= 11802
			for (class_459.class_462 entry : entries) {
			//# else
			//- for (ControlList.KeyEntry entry : entries) {
			//# end
				class_304 binding = ((IKeyBindingEntry) entry).amecs$getKeyBinding();
				if (nmuk && lastMatched && NMUKProxy.isAlternative(binding)) {
					children.add(entry);
					lastEntryCount++;
					continue;
				}

				val cat = binding.method_1423();
				if (!cat.equals(lastCat)) {
					//# if MC_VERSION_NUMBER >= 12109
					//- includeCat = StringUtils.containsIgnoreCase(cat.label().getString(256), searchText);
					//# else
					includeCat = StringUtils.containsIgnoreCase(class_1074.method_4662(cat), searchText);
					//# end
				}
				if (
						(
								includeCat
										|| searchText == null
										|| StringUtils.containsIgnoreCase(class_1074.method_4662(((IKeyBindingEntry) entry).amecs$getKeyBinding().method_1431()), searchText)
						) && Amecs.entryKeyMatches(entry, keyFilter)
				) {
					if (!cat.equals(lastCat)) {
						//# if MC_VERSION_NUMBER >= 12109
						//- children.add(listWidget.new CategoryEntry(cat));
						//# elif MC_VERSION_NUMBER >= 11900
						children.add(listWidget.new class_460(class_2561.method_43471(cat)));
						//# else
						//- children.add(listWidget.new CategoryEntry(new TranslatableComponent(cat)));
						//# end
						lastCat = cat;
						lastEntryCount++;
					}
					children.add(entry);
					lastEntryCount++;
					lastMatched = true;
				} else {
					lastMatched = false;
				}
			}
			if (lastEntryCount <= 1) {
				//# if MC_VERSION_NUMBER >= 11900
				class_5250 noResultsText = class_2561.method_43471(Amecs.MOD_ID + ".search.no_results");
				//# else
				//- MutableComponent noResultsText = new TranslatableComponent(Amecs.MOD_ID + ".search.no_results");
				//# end
				noResultsText.method_10862(noResultsText.method_10866().method_10977(class_124.field_1080));
				// FIXME
				// children.add(listWidget.new CategoryEntry(noResultsText));
			}

			//# if MC_VERSION_NUMBER >= 12109
			//- listWidget.replaceEntries(children);
			//# end
		});
	}

	@Override
	public List<? extends class_364> method_25396() {
		return Collections.singletonList(searchField);
	}

	//# if MC_VERSION_NUMBER >= 11700
	@Override
	public List<? extends class_6379> method_37025() {
		return Collections.singletonList(searchField);
	}
	//# end

	//# if MC_VERSION_NUMBER >= 12109
	//- @Override
	//- public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
	//- 	return searchField.mouseClicked(mouseButtonEvent, bl);
	//- }

	//- @Override
	//- public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
	//- 	return searchField.mouseReleased(mouseButtonEvent);
	//- }

	//- @Override
	//- public boolean keyPressed(KeyEvent keyEvent) {
	//- 	return searchField.keyPressed(keyEvent);
	//- }

	//- @Override
	//- public boolean charTyped(CharacterEvent characterEvent) {
	//- 	return searchField.charTyped(characterEvent);
	//- }

	//- @Override
	//- public void setY(int y) {
	//- 	super.setY(y);
	//- 	searchField.setY(y);
	//- }

	//- @Override
	//- public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
	//- 	searchField.renderWidget(guiGraphics, mouseX, mouseY, tickDelta);
	//- }
	//# else
	@Override
	public boolean method_25402(double double_1, double double_2, int int_1) {
		return searchField.method_25402(double_1, double_2, int_1);
	}

	@Override
	public boolean method_25406(double double_1, double double_2, int int_1) {
		return searchField.method_25406(double_1, double_2, int_1);
	}

	@Override
	public boolean method_25404(int int_1, int int_2, int int_3) {
		return searchField.method_25404(int_1, int_2, int_3);
	}

	@Override
	public boolean method_25400(char char_1, int int_1) {
		return searchField.method_25400(char_1, int_1);
	}
	@Override
	public void method_25343(
			//# if MC_VERSION_NUMBER >= 12000
			class_332 drawContext,
			//# else
			//- PoseStack drawContext,
			//# end
			int index,
			int y,
			int x,
			int entryWidth,
			int entryHeight,
			int mouseX,
			int mouseY,
			boolean var8,
			float tickDelta
	) {
		//# if MC_VERSION_NUMBER >= 11903
		searchField.method_46419(y);
		//# else
		//- searchField.y = y;
		//# end
		searchField.method_25394(drawContext, mouseX, mouseY, tickDelta);
	}
	//# end

	//# if MC_VERSION_NUMBER >= 11904
	@Override
	public void method_25365(boolean focused) {
		searchField.method_25365(focused);
	}
	//# else
	//- @Override
	//- public boolean changeFocus(boolean focused) {
	//- 	return searchField.changeFocus(focused);
	//- }
	//# end

	//# if MC_VERSION_NUMBER >= 11904
	@Override
	public void method_48269() {

	}
	//# end
}
