package de.siphalor.capsaicin.impl.food;

import com.mojang.datafixers.util.Pair;
import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.capsaicin.api.food.FoodModifications;
import de.siphalor.capsaicin.api.food.FoodProperties;
import de.siphalor.capsaicin.impl.food.properties.FoodPropertiesImpl;
import de.siphalor.capsaicin.impl.util.IItem;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4174;

@ApiStatus.Internal
public class FoodHandler {
	public static final ThreadLocal<FoodHandler> INSTANCE = ThreadLocal.withInitial(FoodHandler::new);

	private FoodProperties foodProperties;
	private int eatingTime;
	private class_1799 stack;
	private class_4174 stackFoodComponent;
	private class_2680 blockState;
	private class_1309 user;

	public class_1799 getStack() {
		return stack;
	}

	public class_2680 getBlockState() {
		return blockState;
	}

	public class_1309 getUser() {
		return user;
	}

	public void withStack(class_1799 stack) {
		this.stack = stack;
		class_1792 item = stack.method_7909();
		if (item instanceof IItem iItem) {
			stackFoodComponent = iItem.capsaicin$getVanillaFoodComponent();
			if (stackFoodComponent != null) {
				foodProperties = FoodPropertiesImpl.from(stackFoodComponent);
			}
		} else {
			stackFoodComponent = null;
		}
		if (item != null) {
			// Must not call stack.getMaxUseTime() here!
			// This would cause a stack overflow
			eatingTime = item.method_7881(stack);
		} else {
			eatingTime = 0;
		}
	}

	public void withBlockState(class_2680 blockState, FoodProperties foodProperties) {
		this.blockState = blockState;
		this.foodProperties = foodProperties;
		this.eatingTime = 0;
	}

	public void withUser(class_1309 user) {
		this.user = user;
	}

	public void reset() {
		foodProperties = null;
		stack = null;
		stackFoodComponent = null;
		blockState = null;
		user = null;
	}

	public boolean canApply() {
		return stack != null || blockState != null;
	}

	public FoodContext createContext() {
		if (canApply()) {
			return new FoodContextImpl(stack, blockState, foodProperties.getHunger(), foodProperties.getSaturationModifier(), user);
		}
		return null;
	}

	public class_4174 getFoodComponent() {
		FoodProperties propertiesIn;
		if (stack != null && stackFoodComponent != null) {
			propertiesIn = FoodProperties.from(stackFoodComponent);
		} else {
			propertiesIn = new FoodPropertiesImpl(foodProperties.getHunger(), foodProperties.getSaturationModifier(), false, new ArrayList<>());
		}
		FoodProperties propertiesOut = getFoodProperties(propertiesIn);
		if (propertiesOut == propertiesIn && !propertiesIn.isChanged()) {
			if (stackFoodComponent != null) {
				return stackFoodComponent;
			}
			return new class_4174.class_4175()
					.method_19238(propertiesIn.getHunger())
					.method_19237(propertiesIn.getSaturationModifier())
					.method_19242();
		}

		class_4174.class_4175 builder = new class_4174.class_4175()
				.method_19238(propertiesOut.getHunger())
				.method_19237(propertiesOut.getSaturationModifier());
		if (propertiesOut.isAlwaysEdible()) {
			builder.method_19240();
		}
		for (Pair<class_1293, Float> statusEffect : propertiesOut.getStatusEffects()) {
			builder.method_19239(statusEffect.getFirst(), statusEffect.getSecond());
		}
		if (stackFoodComponent.method_19234()) {
			builder.method_19241();
		}
		if (stackFoodComponent.method_19232()) {
			builder.method_19236();
		}
		return builder.method_19242();
	}

	public FoodProperties getFoodProperties(FoodProperties foodProperties) {
		return FoodModifications.PROPERTIES_MODIFIERS.apply(foodProperties, createContext());
	}

	public int getEatingTime() {
		return FoodModifications.EATING_TIME_MODIFIERS.apply(eatingTime, createContext());
	}
}
