/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.capsaicin.impl.food;

import com.mojang.datafixers.util.Pair;
import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.capsaicin.api.food.FoodModifications;
import de.siphalor.capsaicin.api.food.FoodProperties;
import de.siphalor.capsaicin.impl.food.FoodContextImpl;
import de.siphalor.capsaicin.impl.food.properties.FoodPropertiesImpl;
import de.siphalor.capsaicin.impl.util.IItem;
import java.util.ArrayList;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4174;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FoodHandler {
    public static final ThreadLocal<FoodHandler> INSTANCE = ThreadLocal.withInitial(FoodHandler::new);
    private FoodProperties foodProperties;
    private int eatingTime;
    private class_1799 stack;
    private class_4174 stackFoodComponent;
    private class_2680 blockState;
    private class_1309 user;

    public class_1799 getStack() {
        return this.stack;
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public class_1309 getUser() {
        return this.user;
    }

    public void withStack(class_1799 stack) {
        this.stack = stack;
        class_1792 item = stack.method_7909();
        if (item instanceof IItem) {
            IItem iItem = (IItem)item;
            this.stackFoodComponent = iItem.capsaicin$getVanillaFoodComponent();
            if (this.stackFoodComponent != null) {
                this.foodProperties = FoodPropertiesImpl.from(this.stackFoodComponent);
            }
        } else {
            this.stackFoodComponent = null;
        }
        this.eatingTime = item != null ? item.method_7881(stack) : 0;
    }

    public void withBlockState(class_2680 blockState, FoodProperties foodProperties) {
        this.blockState = blockState;
        this.foodProperties = foodProperties;
        this.eatingTime = 0;
    }

    public void withUser(class_1309 user) {
        this.user = user;
    }

    public void reset() {
        this.foodProperties = null;
        this.stack = null;
        this.stackFoodComponent = null;
        this.blockState = null;
        this.user = null;
    }

    public boolean canApply() {
        return this.stack != null || this.blockState != null;
    }

    public FoodContext createContext() {
        if (this.canApply()) {
            return new FoodContextImpl(this.stack, this.blockState, this.foodProperties.getHunger(), this.foodProperties.getSaturationModifier(), this.user);
        }
        return null;
    }

    public class_4174 getFoodComponent() {
        FoodProperties propertiesIn = this.stack != null && this.stackFoodComponent != null ? FoodProperties.from(this.stackFoodComponent) : new FoodPropertiesImpl(this.foodProperties.getHunger(), this.foodProperties.getSaturationModifier(), false, new ArrayList<Pair<class_1293, Float>>());
        FoodProperties propertiesOut = this.getFoodProperties(propertiesIn);
        if (propertiesOut == propertiesIn && !propertiesIn.isChanged()) {
            if (this.stackFoodComponent != null) {
                return this.stackFoodComponent;
            }
            return new class_4174.class_4175().method_19238(propertiesIn.getHunger()).method_19237(propertiesIn.getSaturationModifier()).method_19242();
        }
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(propertiesOut.getHunger()).method_19237(propertiesOut.getSaturationModifier());
        if (propertiesOut.isAlwaysEdible()) {
            builder.method_19240();
        }
        for (Pair<class_1293, Float> statusEffect : propertiesOut.getStatusEffects()) {
            builder.method_19239((class_1293)statusEffect.getFirst(), ((Float)statusEffect.getSecond()).floatValue());
        }
        if (this.stackFoodComponent.method_19234()) {
            builder.method_19241();
        }
        if (this.stackFoodComponent.method_19232()) {
            builder.method_19236();
        }
        return builder.method_19242();
    }

    public FoodProperties getFoodProperties(FoodProperties foodProperties) {
        return FoodModifications.PROPERTIES_MODIFIERS.apply(foodProperties, this.createContext());
    }

    public int getEatingTime() {
        return FoodModifications.EATING_TIME_MODIFIERS.apply(this.eatingTime, this.createContext());
    }
}

