package de.siphalor.capsaicin.api.food;

import de.siphalor.capsaicin.impl.food.FoodHandler;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4174;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface DynamicFoodPropertiesAccess {
	/**
	 * Creates a new instance in the current execution context
	 * (certain data is inherited from the current execution context).
	 * @return the new instance
	 */
	static @NotNull DynamicFoodPropertiesAccess create() {
		return FoodHandler.createInheriting();
	}

	/**
	 * Sets the stack to be used for the calculations.
	 * Will remove block state data.
	 * @param stack the stack
	 * @return this instance
	 */
	@NotNull DynamicFoodPropertiesAccess withStack(@NotNull class_1799 stack);

	/**
	 * Sets the block state to be used for the calculations.
	 * Will remove stack data.
	 * @param blockState the block state
	 * @param foodProperties the food properties
	 * @return this instance
	 */
	@NotNull DynamicFoodPropertiesAccess withBlockState(@NotNull class_2680 blockState, @NotNull FoodProperties foodProperties);

	/**
	 * Sets the user to be used for the calculations.
	 * @param user the user
	 * @return this instance
	 */
	DynamicFoodPropertiesAccess withUser(class_1309 user);

	/**
	 * Gets the basic, unmodified food component.
	 * @return the food component
	 */
	class_4174 getStackOriginalFoodComponent();

	/**
	 * Returns whether the instance is ready to be used.
	 * Either a stack or a block state must be set.<br />
	 * If <code>false</code> is returned, {@link #getModifiedFoodComponent()} will return <code>null</code>
	 * and {@link #getModifiedEatingTime()} will return <code>0</code>.
	 * @return whether the instance is ready
	 */
	boolean isReady();

	/**
	 * Gets the modified food component or <code>null</code> if the instance is not ready.
	 * @return the food component
	 * @see #isReady()
	 */
	@Nullable class_4174 getModifiedFoodComponent();

	/**
	 * Gets the modified eating time or <code>0</code> if the instance is not ready.
	 * @return the eating time
	 * @see #isReady()
	 */
	int getModifiedEatingTime();
}
