package de.siphalor.capsaicin.impl.food;

import com.mojang.datafixers.util.Pair;
import de.siphalor.capsaicin.api.food.*;
import de.siphalor.capsaicin.impl.food.properties.FoodPropertiesImpl;
import de.siphalor.capsaicin.impl.util.IItem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4174;

@ApiStatus.Internal
public class FoodHandler implements DynamicFoodPropertiesAccess {
	public static final ThreadLocal<FoodHandler> INSTANCE = ThreadLocal.withInitial(FoodHandler::new);

	private FoodProperties foodProperties;
	private int eatingTime;
	private class_1799 stack;
	private class_4174 stackFoodComponent;
	private class_2680 blockState;
	private class_1309 user;

	public static FoodHandler createInheriting() {
		FoodHandler parent = INSTANCE.get();
		FoodHandler foodHandler = new FoodHandler();
		foodHandler.foodProperties = parent.foodProperties;
		foodHandler.stack = parent.stack;
		foodHandler.stackFoodComponent = parent.stackFoodComponent;
		foodHandler.blockState = parent.blockState;
		foodHandler.user = parent.user;
		return foodHandler;
	}

	public class_1799 getStack() {
		return stack;
	}

	public class_4174 getStackOriginalFoodComponent() {
		return stackFoodComponent;
	}

	public class_2680 getBlockState() {
		return blockState;
	}

	public class_1309 getUser() {
		return user;
	}

	public @NotNull FoodHandler withStack(@NotNull class_1799 stack) {
		this.blockState = null;

		this.stack = stack;
		class_1792 item = stack.method_7909();
		if (item instanceof CamoFoodItem camoFoodItem) {
			this.stack = camoFoodItem.getCamoFoodStack(stack, new CamoFoodContextImpl(user));
			if (this.stack == null) {
				return this;
			}
			item = this.stack.method_7909();
		}
		if (item instanceof IItem iItem) {
			stackFoodComponent = iItem.capsaicin$getVanillaFoodComponent();
			if (stackFoodComponent != null) {
				foodProperties = FoodPropertiesImpl.from(stackFoodComponent);
			}
		} else {
			stackFoodComponent = null;
		}
		if (item != null) {
			// Must not call stack.getMaxUseTime() here!
			// This would cause a stack overflow
			eatingTime = item.method_7881(this.stack);
		} else {
			eatingTime = 0;
		}
		return this;
	}

	public @NotNull FoodHandler withBlockState(@NotNull class_2680 blockState, @NotNull FoodProperties foodProperties) {
		this.stack = null;
		this.stackFoodComponent = null;

		this.blockState = blockState;
		this.foodProperties = foodProperties;
		this.eatingTime = 0;
		return this;
	}

	public FoodHandler withUser(class_1309 user) {
		this.user = user;
		return this;
	}

	public void reset() {
		foodProperties = null;
		stack = null;
		stackFoodComponent = null;
		blockState = null;
		user = null;
	}

	public boolean isReady() {
		return stack != null || blockState != null;
	}

	public FoodContext createContext() {
		if (foodProperties == null) {
			return new FoodContextImpl(stack, blockState, 0, 0, user);
		}
		return new FoodContextImpl(stack, blockState, foodProperties.getHunger(), foodProperties.getSaturationModifier(), user);
	}

	@Override
	public @Nullable class_4174 getModifiedFoodComponent() {
		if (!isReady()) {
			return null;
		}

		FoodProperties propertiesIn;
		if (foodProperties == null) {
			propertiesIn = new FoodPropertiesImpl(0, 0F, false, new ArrayList<>());
		} else {
			propertiesIn = new FoodPropertiesImpl(foodProperties.getHunger(), foodProperties.getSaturationModifier(), false, new ArrayList<>());
		}
		FoodProperties propertiesOut = getFoodProperties(propertiesIn);
		if (propertiesOut == propertiesIn && !propertiesIn.isChanged()) {
			if (stackFoodComponent != null) {
				return stackFoodComponent;
			}
			return new class_4174.class_4175()
					.method_19238(propertiesIn.getHunger())
					.method_19237(propertiesIn.getSaturationModifier())
					.method_19242();
		}

		class_4174.class_4175 builder = new class_4174.class_4175()
				.method_19238(propertiesOut.getHunger())
				.method_19237(propertiesOut.getSaturationModifier());
		if (propertiesOut.isAlwaysEdible()) {
			builder.method_19240();
		}
		for (Pair<class_1293, Float> statusEffect : propertiesOut.getStatusEffects()) {
			builder.method_19239(statusEffect.getFirst(), statusEffect.getSecond());
		}
		if (stackFoodComponent.method_19234()) {
			builder.method_19241();
		}
		if (stackFoodComponent.method_19232()) {
			builder.method_19236();
		}
		return builder.method_19242();
	}

	protected FoodProperties getFoodProperties(FoodProperties foodProperties) {
		return FoodModifications.PROPERTIES_MODIFIERS.apply(foodProperties, createContext());
	}

	@Override
	public int getModifiedEatingTime() {
		if (!isReady()) {
			return 0;
		}
		return FoodModifications.EATING_TIME_MODIFIERS.apply(eatingTime, createContext());
	}
}
