package de.siphalor.capsaicin.impl.mixin;

import de.siphalor.capsaicin.impl.food.FoodHandler;
import de.siphalor.capsaicin.impl.util.IItem;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_1792.class)
public class MixinItem implements IItem {
	@Shadow @Final private @Nullable class_4174 foodComponent;

	@Inject(method = "getFoodComponent", at = @At("TAIL"), cancellable = true)
	public void onGetFoodComponent(CallbackInfoReturnable<class_4174> cir) {
		FoodHandler foodHandler = FoodHandler.INSTANCE.get();
		if (foodHandler.isReady()) {
			class_4174 newFoodComponent = foodHandler.getModifiedFoodComponent();
			if (newFoodComponent != foodComponent) {
				cir.setReturnValue(newFoodComponent);
			}
		}
	}

	@Inject(method = "use", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/Item;getFoodComponent()Lnet/minecraft/item/FoodComponent;"), locals = LocalCapture.CAPTURE_FAILHARD)
	public void onUseFood(class_1937 world, class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> cir, class_1799 stack) {
		FoodHandler foodHandler = FoodHandler.INSTANCE.get();
		foodHandler.reset();
		foodHandler.withUser(player).withStack(stack);
	}

	@Inject(method = "use", at = @At("RETURN"))
	public void onUseReturn(CallbackInfoReturnable<class_1271<class_1799>> cir) {
		FoodHandler.INSTANCE.get().reset();
	}

	@Override
	public class_4174 capsaicin$getVanillaFoodComponent() {
		return foodComponent;
	}
}
