package de.siphalor.capsaicin.impl.mixin.client.polymer;

import de.siphalor.capsaicin.impl.food.FoodHandler;
import eu.pb4.polymer.api.client.registry.ClientPolymerItem;
import eu.pb4.polymer.api.item.PolymerItemUtils;
import eu.pb4.polymer.impl.client.compat.AppleSkinCompatibility;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.food.FoodValues;

@Mixin(AppleSkinCompatibility.class)
public class MixinPolymerAppleskinPlugin {
	@Inject(method = "lambda$registerEvents$0", remap = false, at = @At(
			value = "INVOKE",
			target = "Lsqueek/appleskin/api/food/FoodValues;<init>(IF)V"
	), cancellable = true, locals = LocalCapture.CAPTURE_FAILSOFT)
	private static void fixPolymerAppleskin(FoodValuesEvent event, CallbackInfo ci, class_2960 id, ClientPolymerItem polymerItem) {
		class_1792 actualItem = polymerItem.registryEntry();
		if (actualItem != null) {
			FoodHandler foodHandler = FoodHandler.INSTANCE.get();
			class_1799 actualStack = new class_1799(actualItem, event.itemStack.method_7947());
			class_2487 realNbt = event.itemStack.method_7941(PolymerItemUtils.REAL_TAG);
			if (realNbt != null) {
				actualStack.method_7980(realNbt);
			}
			foodHandler.withUser(class_310.method_1551().field_1724).withStack(actualStack);
			class_4174 originalFoodComponent = foodHandler.getStackOriginalFoodComponent();
			if (originalFoodComponent != null) {
				event.defaultFoodValues = new FoodValues(originalFoodComponent.method_19230(), originalFoodComponent.method_19231());
			}
			class_4174 foodComponent = foodHandler.getModifiedFoodComponent();
			if (foodComponent != null) {
				event.modifiedFoodValues = new FoodValues(foodComponent.method_19230(), foodComponent.method_19231());
			}
			foodHandler.reset();
			ci.cancel();
		}
	}
}
