/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.capsaicin.impl.modifier;

import de.siphalor.capsaicin.api.modifier.Modifier;
import de.siphalor.capsaicin.api.modifier.Modifiers;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class UniqueModifiers<Value, Context>
implements Modifiers<Value, Context> {
    private final Set<class_2960> registeredIds = new HashSet<class_2960>();
    private final SortedSet<Entry<Value, Context>> modifiers = new TreeSet<Entry<Value, Context>>();

    @Override
    public void register(Modifier<Value, Context> modifier, class_2960 id, int priority) {
        if (!this.registeredIds.add(id)) {
            throw new IllegalArgumentException("Modifier with id " + String.valueOf(id) + " already registered!");
        }
        this.modifiers.add(new Entry<Value, Context>(modifier, id, priority));
    }

    @Override
    public Value apply(Value value, Context context) {
        for (Entry entry : this.modifiers) {
            try {
                value = entry.modifier().apply(value, context);
            }
            catch (Exception e) {
                if (entry.modifier().ignoreErrors()) {
                    e.printStackTrace();
                    continue;
                }
                throw new RuntimeException("Error while applying modifier " + String.valueOf(entry.id()), e);
            }
        }
        return value;
    }

    private static class Entry<Value, Context>
    implements Comparable<Entry<Value, Context>> {
        private final Modifier<Value, Context> modifier;
        private final class_2960 id;
        private final long idHash;
        private final int priority;

        private Entry(@NotNull Modifier<Value, Context> modifier, @NotNull class_2960 id, int priority) {
            this.modifier = modifier;
            this.id = id;
            this.idHash = id.hashCode();
            this.priority = priority;
        }

        @Override
        public int compareTo(@NotNull Entry<Value, Context> o) {
            int cmp = Integer.compare(this.priority, o.priority);
            if (cmp == 0) {
                return Long.compare(this.idHash, o.idHash);
            }
            return cmp;
        }

        public Modifier<Value, Context> modifier() {
            return this.modifier;
        }

        public class_2960 id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.idHash == entry.idHash && this.priority == entry.priority;
        }

        public int hashCode() {
            return Objects.hash(this.idHash, this.priority);
        }
    }
}

