/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.util;

import lombok.Generated;

public interface CoatColor {
    public static final CoatColor BLACK = CoatColor.rgb(0);
    public static final CoatColor WHITE = CoatColor.rgb(0xFFFFFF);
    public static final CoatColor TRANSPARENT = CoatColor.rgba(0);

    public int getRed();

    default public float getRedF() {
        return (float)this.getRed() / 255.0f;
    }

    public int getGreen();

    default public float getGreenF() {
        return (float)this.getGreen() / 255.0f;
    }

    public int getBlue();

    default public float getBlueF() {
        return (float)this.getBlue() / 255.0f;
    }

    public int getAlpha();

    default public float getAlphaF() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRgba();

    public int getArgb();

    public CoatColor withRed(int var1);

    public CoatColor withGreen(int var1);

    public CoatColor withBlue(int var1);

    public CoatColor withAlpha(int var1);

    public static CoatColor rgb(int rgb) {
        return CoatColor.rgb(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static CoatColor rgb(int red, int green, int blue) {
        return CoatColor.rgba(red, green, blue, 255);
    }

    public static CoatColor rgba(int rgba) {
        return CoatColor.rgba(rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF);
    }

    public static CoatColor rgba(int red, int green, int blue, int alpha) {
        return new Static(red, green, blue, alpha, red << 24 | green << 16 | blue << 8 | alpha, alpha << 24 | red << 16 | green << 8 | blue);
    }

    public static CoatColor argb(int argb) {
        return CoatColor.rgba(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public static CoatColor argb(int alpha, int red, int green, int blue) {
        return CoatColor.rgba(red, green, blue, alpha);
    }

    public static final class Static
    implements CoatColor {
        private final int red;
        private final int green;
        private final int blue;
        private final int alpha;
        private final int rgba;
        private final int argb;

        @Override
        public CoatColor withRed(int red) {
            return CoatColor.rgba(red, this.green, this.blue, this.alpha);
        }

        @Override
        public CoatColor withGreen(int green) {
            return CoatColor.rgba(this.red, green, this.blue, this.alpha);
        }

        @Override
        public CoatColor withBlue(int blue) {
            return CoatColor.rgba(this.red, this.green, blue, this.alpha);
        }

        @Override
        public CoatColor withAlpha(int alpha) {
            return CoatColor.rgba(this.red, this.green, this.blue, alpha);
        }

        @Generated
        public Static(int red, int green, int blue, int alpha, int rgba, int argb) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.rgba = rgba;
            this.argb = argb;
        }

        @Override
        @Generated
        public int getRed() {
            return this.red;
        }

        @Override
        @Generated
        public int getGreen() {
            return this.green;
        }

        @Override
        @Generated
        public int getBlue() {
            return this.blue;
        }

        @Override
        @Generated
        public int getAlpha() {
            return this.alpha;
        }

        @Override
        @Generated
        public int getRgba() {
            return this.rgba;
        }

        @Override
        @Generated
        public int getArgb() {
            return this.argb;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Static)) {
                return false;
            }
            Static other = (Static)o;
            if (this.getRed() != other.getRed()) {
                return false;
            }
            if (this.getGreen() != other.getGreen()) {
                return false;
            }
            if (this.getBlue() != other.getBlue()) {
                return false;
            }
            if (this.getAlpha() != other.getAlpha()) {
                return false;
            }
            if (this.getRgba() != other.getRgba()) {
                return false;
            }
            return this.getArgb() == other.getArgb();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRed();
            result = result * 59 + this.getGreen();
            result = result * 59 + this.getBlue();
            result = result * 59 + this.getAlpha();
            result = result * 59 + this.getRgba();
            result = result * 59 + this.getArgb();
            return result;
        }

        @Generated
        public String toString() {
            return "CoatColor.Static(red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ", alpha=" + this.getAlpha() + ", rgba=" + this.getRgba() + ", argb=" + this.getArgb() + ")";
        }
    }
}

