/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.input;

import de.siphalor.coat.input.ConfigInput;
import de.siphalor.coat.input.InputChangeListener;
import de.siphalor.coat.util.CoatUtil;
import de.siphalor.coat.util.EnumeratedMaterial;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class CycleButtonConfigInput<T>
extends class_362
implements ConfigInput<T> {
    private static final String NULL_TEXT_KEY = "coat.input.enumerated.null";
    private static final class_2561 NULL_TEXT = class_2561.method_43471((String)"coat.input.enumerated.null");
    private static final int BUTTON_PADDING = 2;
    private static final int DEFAULT_WIDTH = 100;
    private final EnumeratedMaterial<T> enumeratedMaterial;
    private final boolean nullAllowed;
    private final class_4185 button;
    private int preferredWidth = 100;
    private T value;
    private InputChangeListener<T> changeListener;

    public CycleButtonConfigInput(EnumeratedMaterial<T> enumeratedMaterial, boolean nullAllowed, T value) {
        this.enumeratedMaterial = enumeratedMaterial;
        this.nullAllowed = nullAllowed;
        this.value = value;
        this.determinePreferredWidth();
        this.button = new class_4185(0, 0, this.preferredWidth, 20, this.getButtonText(), _button -> this.onClick());
    }

    private void determinePreferredWidth() {
        class_327 font = class_310.method_1551().field_1772;
        this.preferredWidth = Arrays.stream(this.enumeratedMaterial.values()).mapToInt(value -> font.method_27525((class_5348)this.enumeratedMaterial.asText(value))).max().orElse(100) + 4;
    }

    @Override
    public int method_25364() {
        return this.button.method_25364();
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    private void onClick() {
        this.setValue(this.nextValue());
    }

    private T nextValue() {
        for (int i = 0; i < this.enumeratedMaterial.values().length; ++i) {
            if (this.enumeratedMaterial.values()[i] != this.value) continue;
            if (i + 1 < this.enumeratedMaterial.values().length) {
                return this.enumeratedMaterial.values()[i + 1];
            }
            if (this.nullAllowed) {
                return null;
            }
            return this.enumeratedMaterial.values()[0];
        }
        return this.enumeratedMaterial.values()[0];
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (this.value != value) {
            this.value = value;
            this.valueChanged();
        }
    }

    private void valueChanged() {
        if (this.value != null) {
            this.button.method_25355(this.enumeratedMaterial.asText(this.value));
        } else {
            this.button.method_25355(this.getButtonText());
        }
        if (this.changeListener != null) {
            this.changeListener.inputChanged(this.value);
        }
    }

    @Override
    public void setChangeListener(InputChangeListener<T> changeListener) {
        this.changeListener = changeListener;
    }

    private class_2561 getButtonText() {
        if (this.value != null) {
            return this.enumeratedMaterial.asText(this.value);
        }
        try {
            return this.enumeratedMaterial.asText(null);
        }
        catch (Exception e) {
            return NULL_TEXT;
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.button.method_25405(mouseX, mouseY);
    }

    public List<? extends class_364> method_25396() {
        return Collections.singletonList(this.button);
    }

    @Override
    public void method_25365(boolean focused) {
        this.button.method_25407(true);
    }

    @Override
    public void render(class_4587 context, int x, int y, int width, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        CoatUtil.setButtonPosition(this.button, x, y);
        this.button.method_25358(width);
        this.method_25394(context, mouseX, mouseY, tickDelta);
    }

    public void method_25394(class_4587 context, int mouseX, int mouseY, float tickDelta) {
        this.button.method_25394(context, mouseX, mouseY, tickDelta);
    }
}

