/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.input;

import de.siphalor.coat.input.ConfigInput;
import de.siphalor.coat.input.InputChangeListener;
import java.text.NumberFormat;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;

public class SliderConfigInput<N extends Number>
extends class_357
implements ConfigInput<N> {
    private final Class<N> valueClass;
    private final N min;
    private final N max;
    private InputChangeListener<N> changeListener;
    private int precision;

    public SliderConfigInput(N value, N min, N max) {
        super(0, 0, 100, 20, (class_2561)class_2561.method_43473(), SliderConfigInput.toInternalValue(value, min, max));
        this.valueClass = value.getClass();
        this.min = min;
        this.max = max;
        if (this.valueClass == Double.class || this.valueClass == Float.class) {
            this.precision = Math.max((int)Math.log10(((Number)min).doubleValue()), (int)Math.log10(((Number)max).doubleValue()));
            this.precision = Math.max(0, 4 - this.precision);
        } else {
            this.precision = 0;
        }
        this.method_25346();
    }

    protected static double toInternalValue(Number value, Number min, Number max) {
        return class_3532.method_15350((double)((value.doubleValue() - min.doubleValue()) / (max.doubleValue() - min.doubleValue())), (double)0.0, (double)1.0);
    }

    @Override
    public N getValue() {
        return this.getRealValue();
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
    }

    @Override
    public void setValue(N realValue) {
        this.field_22753 = SliderConfigInput.toInternalValue(realValue, this.min, this.max);
        this.method_25344();
        this.method_25346();
    }

    @Override
    public void setChangeListener(InputChangeListener<N> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void render(class_4587 graphics, int x, int y, int width, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.method_48229(x, y);
        this.method_25358(width);
        this.method_25394(graphics, mouseX, mouseY, tickDelta);
    }

    protected void method_25346() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(this.precision);
        format.setMinimumFractionDigits(this.precision);
        this.method_25355((class_2561)class_2561.method_43470((String)format.format(this.getRealValue())));
    }

    protected void method_25344() {
        this.changeListener.inputChanged(this.getRealValue());
    }

    protected N getRealValue() {
        Double realValue = ((Number)this.min).doubleValue() + this.field_22753 * (((Number)this.max).doubleValue() - ((Number)this.min).doubleValue());
        if (this.valueClass != Float.class && this.valueClass != Double.class) {
            realValue = Math.round(realValue);
        }
        if (this.valueClass == Byte.class) {
            return (N)((Number)((Number)realValue).byteValue());
        }
        if (this.valueClass == Short.class) {
            return (N)((Number)((Number)realValue).shortValue());
        }
        if (this.valueClass == Integer.class) {
            return (N)((Number)((Number)realValue).intValue());
        }
        if (this.valueClass == Long.class) {
            return (N)((Number)((Number)realValue).longValue());
        }
        if (this.valueClass == Float.class) {
            return (N)Float.valueOf(((Number)realValue).floatValue());
        }
        if (this.valueClass == Double.class) {
            return (N)realValue;
        }
        throw new RuntimeException("Number class " + this.valueClass.getSimpleName() + " is not supported!");
    }

    @Generated
    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

