/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.util;

import com.mojang.blaze3d.systems.RenderSystem;
import de.siphalor.coat.util.CoatColor;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_757;

public class CoatUtil {
    public static final CoatColor TEXT_COLOR = CoatColor.rgb(0xDDDDDD);
    public static final CoatColor SECONDARY_TEXT_COLOR = CoatColor.rgb(0xAAAAAA);
    public static final CoatColor HOVER_BG_COLOR = CoatColor.argb(0x2DFFFFFF);
    public static final int MARGIN = 2;
    public static final int DOUBLE_MARGIN = 4;
    public static final int HALF_MARGIN = 1;
    public static final String ELLIPSIS = "...";

    public static class_2561 intelliTrim(class_327 font, class_2561 baseText, int width) {
        int textWidth = font.method_27525((class_5348)baseText);
        if (textWidth > width) {
            textWidth = font.method_1727(ELLIPSIS);
            String trimmed = font.method_27523(baseText.getString(), width - textWidth);
            return class_2561.method_43470((String)(trimmed.trim() + ELLIPSIS)).method_10862(baseText.method_10866());
        }
        return baseText;
    }

    public static List<class_5481> wrapTooltip(class_327 font, class_310 minecraft, class_2561 text) {
        return font.method_1728((class_5348)text, minecraft.field_1755.field_22789 / 2);
    }

    public static void renderTooltip(class_4587 graphics, int x, int y, class_2561 text) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.depthFunc((int)519);
        class_310.method_1551().field_1755.method_25424(graphics, text, x, y);
    }

    public static void drawOutline(int x1, int y1, int x2, int y2, CoatColor color) {
        boolean stroke = true;
        class_289 tesselator = class_289.method_1348();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        CoatUtil.addRect(buffer, x1, y1, x2, y1 + 1, color);
        CoatUtil.addRect(buffer, x1, y2 - 1, x2, y2, color);
        CoatUtil.addRect(buffer, x1, y1 + 1, x1 + 1, y2 - 1, color);
        CoatUtil.addRect(buffer, x2 - 1, y1 + 1, x2, y2 - 1, color);
        tesselator.method_1350();
    }

    public static void addRect(class_287 buffer, int x1, int y1, int x2, int y2, CoatColor color) {
        CoatUtil.withColor(buffer.method_22912((double)x1, (double)y2, 0.0), color).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)x2, (double)y2, 0.0), color).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)x2, (double)y1, 0.0), color).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)x1, (double)y1, 0.0), color).method_1344();
    }

    public static void drawHorizontalGradient(int left, int top, int right, int bottom, CoatColor leftColor, CoatColor rightColor) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        CoatUtil.withColor(bufferBuilder.method_22912((double)left, (double)bottom, 0.0), leftColor).method_1344();
        CoatUtil.withColor(bufferBuilder.method_22912((double)right, (double)bottom, 0.0), rightColor).method_1344();
        CoatUtil.withColor(bufferBuilder.method_22912((double)right, (double)top, 0.0), rightColor).method_1344();
        CoatUtil.withColor(bufferBuilder.method_22912((double)left, (double)top, 0.0), leftColor).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawTintedTiledTexture(class_2960 texture, int left, int top, int right, int bottom, int z, float textureScale, int textureYOffset, CoatColor color) {
        class_289 tesselator = class_289.method_1348();
        CoatUtil.setShaderTexture(texture);
        CoatUtil.setShaderColor(color);
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912((double)left, (double)bottom, (double)z).method_22913((float)left / textureScale, (float)(bottom + textureYOffset) / textureScale).method_1344();
        bufferBuilder.method_22912((double)right, (double)bottom, (double)z).method_22913((float)right / textureScale, (float)(bottom + textureYOffset) / textureScale).method_1344();
        bufferBuilder.method_22912((double)right, (double)top, (double)z).method_22913((float)right / textureScale, (float)(top + textureYOffset) / textureScale).method_1344();
        bufferBuilder.method_22912((double)left, (double)top, (double)z).method_22913((float)left / textureScale, (float)(top + textureYOffset) / textureScale).method_1344();
        tesselator.method_1350();
        CoatUtil.resetShaderColor();
    }

    public static void drawInsetGradientTexture(class_2960 texture, int left, int top, int right, int bottom, int z, float textureScale, CoatColor outerColor, CoatColor innerColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(class_757::method_34541);
        CoatUtil.setShaderTexture(texture);
        CoatUtil.resetShaderColor();
        class_289 tesselator = class_289.method_1348();
        int width = right - left;
        int height = bottom - top;
        int middleOffset = height / 2;
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_20887);
        CoatUtil.withColor(buffer.method_22912((double)left, (double)top, (double)z), outerColor).method_22913(0.0f, 0.0f).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)(left + middleOffset), (double)(top + middleOffset), (double)z), innerColor).method_22913((float)middleOffset / textureScale, (float)middleOffset / textureScale).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)right, (double)top, (double)z), outerColor).method_22913((float)width / textureScale, 0.0f).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)(right - middleOffset), (double)(top + middleOffset), (double)z), innerColor).method_22913((float)(width - middleOffset) / textureScale, (float)middleOffset / textureScale).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)right, (double)bottom, (double)z), outerColor).method_22913((float)width / textureScale, (float)height / textureScale).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)(left + middleOffset), (double)(bottom - middleOffset), (double)z), innerColor).method_22913((float)middleOffset / textureScale, (float)(height - middleOffset) / textureScale).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)left, (double)bottom, (double)z), outerColor).method_22913(0.0f, (float)height / textureScale).method_1344();
        CoatUtil.withColor(buffer.method_22912((double)left, (double)top, (double)z), outerColor).method_22913(0.0f, 0.0f).method_1344();
        tesselator.method_1350();
    }

    private static <V extends class_4588> V withColor(V vertexConsumer, CoatColor color) {
        vertexConsumer.method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        return vertexConsumer;
    }

    public static void setShaderTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void setShaderColor(CoatColor color) {
        RenderSystem.setShaderColor((float)color.getRedF(), (float)color.getGreenF(), (float)color.getBlueF(), (float)color.getAlphaF());
    }

    public static void resetShaderColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void playClickSound() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public static void setButtonPosition(class_4185 button, int x, int y) {
        CoatUtil.setButtonX(button, x);
        CoatUtil.setButtonY(button, y);
    }

    public static void setButtonX(class_4185 button, int x) {
        button.method_46421(x);
    }

    public static void setButtonY(class_4185 button, int y) {
        button.method_46419(y);
    }
}

