/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.list.entry;

import com.google.common.collect.ImmutableList;
import de.siphalor.coat.handler.ConfigEntryHandler;
import de.siphalor.coat.handler.Message;
import de.siphalor.coat.input.ConfigInput;
import de.siphalor.coat.input.InputChangeListener;
import de.siphalor.coat.list.entry.ConfigContainerCompoundEntry;
import de.siphalor.coat.util.CoatUtil;
import de.siphalor.coat.util.TextButtonWidget;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import net.minecraft.class_7919;

public class ConfigCategoryConfigEntry<V>
extends ConfigContainerCompoundEntry
implements InputChangeListener<V> {
    private static final String DEFAULT_TEXT_KEY = "coat.default";
    private static final String DEFAULT_HOVER_TEXT_KEY = "coat.default.hover";
    private static final class_2561 DEFAULT_TEXT = class_2561.method_43471((String)"coat.default");
    private static final class_2561 DEFAULT_HOVER_TEXT = class_2561.method_43471((String)"coat.default.hover");
    private static final int TEXT_INDENT = 8;
    private final class_327 font;
    private final TextButtonWidget nameWidget;
    private final class_2561 description;
    private class_5489 descriptionMultiline;
    private final ConfigEntryHandler<V> entryHandler;
    private final ConfigInput<V> input;
    private final class_4185 defaultButton;
    private Collection<Message> messages;
    private boolean expanded;
    private boolean hovered;
    private int leftInputOffset;
    private int inputWidth;

    public ConfigCategoryConfigEntry(class_5250 name, class_5250 description, ConfigEntryHandler<V> entryHandler, ConfigInput<V> input) {
        this.nameWidget = new TextButtonWidget(0, 0, 100, 12, (class_2561)name, button -> this.setExpanded(!this.isExpanded()));
        this.nameWidget.setHoverEffect(false);
        this.setName(name.method_27661());
        this.description = description;
        this.entryHandler = entryHandler;
        this.input = input;
        input.setChangeListener(this);
        class_310 minecraft = class_310.method_1551();
        this.font = minecraft.field_1772;
        class_5250 tooltipText = DEFAULT_HOVER_TEXT.method_27662();
        tooltipText.method_27693("\n").method_10852(entryHandler.asText(entryHandler.getDefault()));
        this.defaultButton = class_4185.method_46430((class_2561)DEFAULT_TEXT, button -> input.setValue(entryHandler.getDefault())).method_46437(10, 20).method_46436(class_7919.method_47407((class_2561)tooltipText)).method_46431();
        this.inputChanged(input.getValue());
    }

    public boolean isExpansionEmpty() {
        if (this.description != null) {
            return false;
        }
        for (Message message : this.messages) {
            if (message.getLevel().getSeverity() >= 150) continue;
            return true;
        }
        return false;
    }

    public void setExpanded(boolean expanded) {
        if (expanded) {
            this.updateExpanded(this.parent.getEntryWidth());
        }
        boolean old = this.expanded;
        this.expanded = expanded;
        if (old != expanded) {
            this.parent.entryHeightChanged(this);
        }
    }

    protected void updateExpanded(int width) {
        this.descriptionMultiline = class_5489.method_30890((class_327)class_310.method_1551().field_1772, (class_5348)this.description, (int)(width - 8));
    }

    @Override
    public void widthChanged(int newWidth) {
        super.widthChanged(newWidth);
        int inputWidth = this.input.getPreferredWidth();
        int namePart = (int)((double)newWidth * 0.3);
        int controlsPart = (int)((double)newWidth * 0.2);
        if (inputWidth > 0) {
            int rest = newWidth - namePart - inputWidth - 2 - controlsPart;
            if (rest > 0) {
                namePart += rest;
            } else {
                inputWidth += rest;
            }
        } else {
            inputWidth = newWidth - namePart - 2 - controlsPart;
        }
        this.nameWidget.method_25358(namePart - 1);
        this.inputWidth = inputWidth;
        this.leftInputOffset = namePart + 1;
        this.defaultButton.method_25358(controlsPart - 1);
        if (this.isExpanded()) {
            this.updateExpanded(newWidth);
        }
    }

    protected void setName(class_5250 name) {
        Message.Level level = this.getHighestMessageLevel();
        if (level == null) {
            name.method_10862(class_2583.field_24360);
        } else {
            name.method_10862(level.getTextStyle());
        }
        this.nameWidget.method_25355((class_2561)name);
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)((Object)this.nameWidget), this.input, (Object)this.defaultButton);
    }

    @Override
    public void tick() {
        this.input.tickConfigInput();
    }

    @Override
    public void render(class_332 graphics, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int inputHeight = this.input.method_25364();
        int messageHeight = Math.max(20, inputHeight);
        int top = y + 2;
        int right = x + entryWidth;
        int bottom = y + entryHeight;
        this.hovered = hovered;
        if (hovered) {
            graphics.method_25294(x, top, right, bottom, CoatUtil.HOVER_BG_COLOR.getArgb());
        }
        int textY = top + (int)((float)(messageHeight - 8) / 2.0f);
        this.input.render(graphics, x + this.leftInputOffset, top + (messageHeight - inputHeight) / 2, this.inputWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        CoatUtil.setButtonPosition(this.defaultButton, x + entryWidth - this.defaultButton.method_25368() + 1, top);
        CoatUtil.setButtonPosition(this.nameWidget, x, textY - 2);
        this.defaultButton.method_25394(graphics, mouseX, mouseY, tickDelta);
        this.nameWidget.method_25394(graphics, mouseX, mouseY, tickDelta);
        int curY = top + messageHeight + 2;
        int msgX = x + 8;
        int msgWidth = entryWidth - 8;
        for (Message message : this.messages) {
            if (message.getLevel().getSeverity() < 150) continue;
            curY = this.drawMessageParagraph(graphics, msgX, curY, msgWidth, message);
        }
        if (this.isExpanded()) {
            for (Message message : this.messages) {
                if (message.getLevel().getSeverity() >= 150) continue;
                curY = this.drawMessageParagraph(graphics, msgX, curY, msgWidth, message);
            }
            this.descriptionMultiline.method_30896(graphics, msgX, curY, 9, CoatUtil.SECONDARY_TEXT_COLOR.getArgb());
        }
    }

    private int drawMessageParagraph(class_332 context, int x, int y, int width, Message message) {
        List lines = this.font.method_1728((class_5348)message.getText(), width);
        for (class_5481 line : lines) {
            context.method_51430(this.font, line, x, y, -1, false);
            y += 9;
        }
        return y += 2;
    }

    public int getBaseHeight() {
        int msgHeight = 0;
        for (Message message : this.messages) {
            if (message.getLevel().getSeverity() < 150) continue;
            msgHeight += this.font.method_1728((class_5348)message.getText(), this.parent.getEntryWidth()).size() * 9 + 2;
        }
        if (msgHeight > 0) {
            msgHeight += 2;
        }
        return 2 + Math.max(20, this.input.method_25364()) + msgHeight;
    }

    public int getExpansionHeight() {
        int height = 0;
        if (this.descriptionMultiline != class_5489.field_26528) {
            height += 2 + this.descriptionMultiline.method_30887() * 9;
        }
        for (Message message : this.messages) {
            if (message.getLevel().getSeverity() >= 150) continue;
            height += this.font.method_1728((class_5348)message.getText(), this.parent.getEntryWidth()).size() * 9 + 2;
        }
        return height;
    }

    @Override
    public int getHeight() {
        if (this.isExpanded()) {
            return this.getBaseHeight() + this.getExpansionHeight();
        }
        return this.getBaseHeight();
    }

    @Override
    public void method_25395(class_364 focused) {
        class_364 old = this.method_25399();
        if (old != focused) {
            if (old == this.input) {
                this.input.method_25365(false);
            }
            super.method_25395(focused);
            if (focused == this.input) {
                this.input.method_25365(true);
            }
        }
    }

    @Override
    public int getEntryWidth() {
        return this.parent.getEntryWidth();
    }

    @Override
    public void inputChanged(V newValue) {
        if (!Objects.equals(newValue, this.entryHandler.getDefault())) {
            this.defaultButton.field_22763 = true;
            this.defaultButton.method_47402(0);
        } else {
            if (this.defaultButton.method_25370()) {
                this.method_25365(false);
            }
            this.defaultButton.field_22763 = false;
            this.defaultButton.method_47402(Integer.MAX_VALUE);
        }
        this.setMessages(this.entryHandler.getMessages(newValue));
    }

    @Override
    public void save() {
        super.save();
        this.entryHandler.save(this.input.getValue());
    }

    public Message.Level getHighestMessageLevel() {
        if (this.messages == null) {
            return null;
        }
        Message.Level highestLevel = null;
        int highestSeverity = Integer.MIN_VALUE;
        for (Message message : this.messages) {
            int severity = message.getLevel().getSeverity();
            if (severity <= highestSeverity) continue;
            highestSeverity = severity;
            highestLevel = message.getLevel();
        }
        return highestLevel;
    }

    @Override
    public Collection<Message> getMessages() {
        return this.messages;
    }

    protected void setMessages(Collection<Message> messages) {
        this.messages = messages;
        for (Message message : messages) {
            message.setOrigin(this);
        }
        if (this.parent != null) {
            this.parent.entryHeightChanged(this);
        }
        this.setName(this.nameWidget.getOriginalMessage().method_27662());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            if (this.hovered && !this.isExpansionEmpty()) {
                CoatUtil.playClickSound();
                this.setExpanded(!this.isExpanded());
                return true;
            }
            return false;
        }
        return true;
    }

    @Generated
    private class_4185 getDefaultButton() {
        return this.defaultButton;
    }

    @Generated
    public boolean isExpanded() {
        return this.expanded;
    }
}

