/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.list;

import com.google.common.collect.Lists;
import de.siphalor.coat.list.EntryContainer;
import de.siphalor.coat.util.CoatColor;
import de.siphalor.coat.util.CoatUtil;
import de.siphalor.coat.util.TickableElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DynamicEntryListWidget<E extends Entry>
extends class_362
implements EntryContainer,
TickableElement,
class_6379,
class_4068 {
    private static final int TOP_PADDING = 8;
    private static final int BOTTOM_PADDING = 6;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final CoatColor SCROLLBAR_BACKGROUND_COLOR = CoatColor.rgb(0);
    private static final CoatColor SCROLLBAR_HANDLE_SHADOW_COLOR = CoatColor.rgb(0x808080);
    private static final CoatColor SCROLLBAR_HANDLE_COLOR = CoatColor.rgb(0xC0C0C0);
    protected final class_310 minecraft;
    private final Entries entries = new Entries();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    private int rowWidth;
    private double scrollYOffset;
    private float backgroundBrightness = 0.27f;
    private class_2960 background = new class_2960("textures/block/cherry_log.png");
    private boolean scrolling;

    public DynamicEntryListWidget(class_310 minecraft, int width, int height, int top, int rowWidth) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = top + height;
        this.left = 0;
        this.right = width;
        this.rowWidth = rowWidth;
    }

    public DynamicEntryListWidget(class_310 minecraft, Collection<E> entries, @Nullable class_2960 background) {
        this.minecraft = minecraft;
        this.top = 20;
        this.addEntries(entries);
        if (background != null) {
            this.background = background;
        }
    }

    public int getHorizontalPadding() {
        return 4;
    }

    @Override
    public int getEntryWidth() {
        return Math.min(this.rowWidth, this.width) - this.getHorizontalPadding() * 2;
    }

    public List<E> entries() {
        return this.entries;
    }

    public List<? extends class_364> method_25396() {
        return this.entries;
    }

    public E getEntry(int index) {
        return (E)this.entries.get(index);
    }

    public void addEntry(E entry) {
        ((Entry)entry).setParent(this);
        this.entries.add(entry);
    }

    public void addEntry(int position, E entry) {
        ((Entry)entry).setParent(this);
        this.entries.add(position, entry);
    }

    public void addEntries(Collection<E> newEntries) {
        for (Entry newEntry : newEntries) {
            newEntry.setParent(this);
        }
        this.entries.addAll(newEntries);
    }

    protected int getEntryCount() {
        return this.entries().size();
    }

    @Nullable
    protected final E getEntryAtPosition(double x, double y) {
        int halfRowWidth = this.getEntryWidth() / 2;
        int screenCenter = this.left + this.width / 2;
        int rowLeft = screenCenter - halfRowWidth;
        int rowRight = screenCenter + halfRowWidth;
        if (x >= (double)this.getScrollbarPositionX() || x < (double)rowLeft || x > (double)rowRight) {
            return null;
        }
        if ((y -= (double)this.getEntryAreaTop()) < 0.0 || y > (double)this.getMaxEntryPosition()) {
            return null;
        }
        IntListIterator iterator = this.entries.bottoms.iterator();
        while (iterator.hasNext()) {
            if (!(y < (double)iterator.nextInt())) continue;
            return this.getEntry(iterator.nextIndex() - 1);
        }
        return null;
    }

    protected int getEntryAtY(int y) {
        if ((y -= this.getEntryAreaTop()) < 0) {
            return 0;
        }
        if (y > this.getMaxEntryPosition()) {
            return this.getEntryCount();
        }
        IntListIterator iterator = this.entries.bottoms.iterator();
        while (iterator.hasNext()) {
            int cur = iterator.nextInt();
            if (y >= cur) continue;
            return iterator.previousIndex();
        }
        return this.getEntryCount() - 1;
    }

    @Override
    public void entryHeightChanged(class_364 element) {
        int index = this.entries.indexOf(element);
        int bottom = index == 0 ? 0 : this.entries.bottoms.getInt(index - 1);
        int l = this.entries.size();
        for (int i = index; i < l; ++i) {
            this.entries.bottoms.set(i, bottom += ((Entry)this.entries.get(i)).getHeight());
        }
    }

    public void resize(int newWidth, int newHeight) {
        this.height = newHeight;
        this.bottom = this.top + this.height;
        this.widthChanged(newWidth);
    }

    public void widthChanged(int newWidth) {
        this.width = newWidth;
        this.right = this.left + newWidth;
        for (Entry entry : this.entries) {
            entry.widthChanged(this.getEntryWidth());
        }
    }

    public void setPosition(int left, int top) {
        this.left = left;
        this.top = top;
        this.right = left + this.width;
        this.bottom = top + this.height;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
        this.widthChanged(this.width);
    }

    protected int getMaxEntryPosition() {
        if (this.entries.isEmpty()) {
            return 0;
        }
        return this.entries.bottoms.getInt(this.entries.bottoms.size() - 1);
    }

    protected int getMaxPosition() {
        return this.getMaxEntryPosition() + 6;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderWidget(graphics, mouseX, mouseY, delta);
    }

    public void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        this.renderScrollbar(graphics);
        this.renderList(graphics, mouseX, mouseY, delta);
        graphics.method_25296(this.left, this.top, this.right, this.top + 8, 0x77000000, 0);
    }

    protected void renderBackground(class_332 graphics) {
        int colorPart = (int)(this.backgroundBrightness * 255.0f);
        CoatColor backgroundTint = CoatColor.rgb(colorPart, colorPart, colorPart);
        graphics.method_51448().method_22904(0.0, 0.0, -100.0);
        CoatUtil.drawTintedTiledTexture(graphics, this.getListBackground(), this.left, this.top, this.right, this.bottom, 32, (int)this.getScrollYOffset(), backgroundTint);
        graphics.method_51448().method_22904(0.0, 0.0, 100.0);
    }

    protected class_2960 getListBackground() {
        return this.background;
    }

    private void renderScrollbar(class_332 graphics) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return;
        }
        int scrollbarLeft = this.getScrollbarPositionX();
        int scrollbarRight = scrollbarLeft + 6;
        int handleHeight = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
        handleHeight = class_3532.method_15340((int)handleHeight, (int)32, (int)(this.height - 8));
        int scrollableRange = this.height - handleHeight;
        int handleTop = (int)this.getScrollYOffset() * scrollableRange / maxScroll + this.top;
        if (handleTop < this.top) {
            handleTop = this.top;
        }
        graphics.method_25294(scrollbarLeft, this.top, scrollbarRight, this.bottom, SCROLLBAR_BACKGROUND_COLOR.getArgb());
        graphics.method_25294(scrollbarLeft, handleTop, scrollbarRight, handleTop + handleHeight, SCROLLBAR_HANDLE_SHADOW_COLOR.getArgb());
        graphics.method_25294(scrollbarLeft, handleTop, scrollbarRight - 1, handleTop + handleHeight - 1, SCROLLBAR_HANDLE_COLOR.getArgb());
    }

    public void renderList(class_332 graphics, int mouseX, int mouseY, float delta) {
        IntListIterator bottomIter = this.entries.bottoms.iterator();
        Iterator entryIter = this.entries.iterator();
        int relBottom = 0;
        int relTop = 0;
        int entryAreaTop = this.getEntryAreaTop();
        Entry entry = null;
        while (bottomIter.hasNext()) {
            relTop = relBottom;
            relBottom = bottomIter.nextInt();
            entry = (Entry)entryIter.next();
            if (entryAreaTop + relBottom <= this.top) continue;
        }
        E hoveredEntry = this.getEntryAtPosition(mouseX, mouseY);
        int rowWidth = this.getEntryWidth();
        int rowLeft = this.getEntryLeft();
        while (entry != null) {
            int rowTop = relTop + entryAreaTop;
            entry.render(graphics, rowLeft, rowTop, rowWidth, relBottom - relTop, mouseX, mouseY, hoveredEntry == entry, delta);
            if (!bottomIter.hasNext()) break;
            relTop = relBottom;
            relBottom = bottomIter.nextInt();
            entry = (Entry)entryIter.next();
        }
    }

    public void centerScrollOn(E entry) {
        int index = this.entries.indexOf(entry);
        this.setScrollYOffset((double)this.entries.bottoms.getInt(index) - (double)((Entry)entry).getHeight() / 2.0 - (double)(this.bottom - this.top) / 2.0);
    }

    public void ensureVisible(E entry) {
        int entryTop;
        int index = this.entries.indexOf(entry);
        int entryBottom = this.entries.bottoms.getInt(index);
        if (this.getEntryAreaTop() + entryBottom > this.bottom) {
            this.setScrollYOffset(entryBottom - this.height);
        }
        int n = entryTop = index == 0 ? 0 : this.entries.bottoms.getInt(index - 1);
        if (this.getEntryAreaTop() + entryTop < this.top) {
            this.setScrollYOffset(entryTop);
        }
    }

    private void scroll(int amount) {
        this.setScrollYOffset(this.getScrollYOffset() + (double)amount);
    }

    public void setScrollYOffset(double amount) {
        this.scrollYOffset = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height + 8);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
    }

    protected int getScrollbarPositionX() {
        return this.getEntryRight() + 2;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            boolean handled = entry.method_25402(mouseX, mouseY, button);
            if (handled && ((Entry)entry).getParent() == this) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                return true;
            }
        } else {
            this.method_25395(null);
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.setScrollYOffset(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.setScrollYOffset(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int i = this.bottom - this.top;
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double e = Math.max(1.0, d / (double)(i - j));
                this.setScrollYOffset(this.getScrollYOffset() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        double prevScroll = this.getScrollYOffset();
        this.setScrollYOffset(this.getScrollYOffset() - verticalAmount * 10.0);
        return this.getScrollYOffset() != prevScroll;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    public int getEntryLeft() {
        return this.left + this.width / 2 - this.getEntryWidth() / 2;
    }

    public int getEntryRight() {
        return this.right - this.width / 2 + this.getEntryWidth() / 2;
    }

    protected int getEntryAreaTop() {
        return this.top + 8 - (int)this.scrollYOffset;
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        class_364 old = this.method_25399();
        if (old != null && old != focused && old instanceof Entry) {
            ((Entry)old).focusLost();
        }
        if (focused != null && focused instanceof Entry) {
            this.ensureVisible((Entry)focused);
        }
        super.method_25395(focused);
    }

    protected E removeEntry(E entry) {
        if (entry == this.method_25399()) {
            this.method_25365(true);
        }
        this.entries.remove(entry);
        return entry;
    }

    protected E removeEntry(int index) {
        Object entry = this.entries.get(index);
        return (E)this.removeEntry(entry);
    }

    @Override
    public void tick() {
        for (Entry child : this.entries) {
            child.tick();
        }
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    @Generated
    public double getScrollYOffset() {
        return this.scrollYOffset;
    }

    @Generated
    public void setBackgroundBrightness(float backgroundBrightness) {
        this.backgroundBrightness = backgroundBrightness;
    }

    @Generated
    public class_2960 getBackground() {
        return this.background;
    }

    @Generated
    public void setBackground(class_2960 background) {
        this.background = background;
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final List<E> entries;
        protected final IntList bottoms = new IntArrayList();

        private Entries() {
            this.entries = Lists.newArrayList();
        }

        @Override
        public E get(int i) {
            return (Entry)this.entries.get(i);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public E set(int i, E entry) {
            ((Entry)entry).setParent(DynamicEntryListWidget.this);
            return (Entry)this.entries.set(i, entry);
        }

        @Override
        public void add(int i, E entry) {
            this.bottoms.add(0);
            ((Entry)entry).setParent(DynamicEntryListWidget.this);
            this.entries.add(i, entry);
            DynamicEntryListWidget.this.entryHeightChanged((class_364)entry);
            ((Entry)entry).widthChanged(DynamicEntryListWidget.this.getEntryWidth());
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends E> newEntries) {
            int oldSize = this.entries.size();
            int bottom = this.bottoms.isEmpty() ? 0 : this.bottoms.getInt(0);
            this.entries.addAll(newEntries);
            int l = this.entries.size();
            for (int i = oldSize; i < l; ++i) {
                this.bottoms.add(bottom += ((Entry)this.entries.get(i)).getHeight());
            }
            for (Entry newEntry : newEntries) {
                newEntry.setParent(DynamicEntryListWidget.this);
                newEntry.widthChanged(DynamicEntryListWidget.this.getEntryWidth());
            }
            return true;
        }

        @Override
        public E remove(int i) {
            Entry entry = (Entry)this.entries.remove(i);
            entry.setParent(null);
            int height = entry.getHeight();
            this.bottoms.removeInt(i);
            if (entry == DynamicEntryListWidget.this.method_25399()) {
                DynamicEntryListWidget.this.method_25395(null);
            }
            for (int j = i; j < this.entries.size(); ++j) {
                this.bottoms.set(j, this.bottoms.getInt(j) - height);
            }
            return entry;
        }

        @Override
        public void clear() {
            this.entries.clear();
            this.bottoms.clear();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    implements class_364,
    TickableElement {
        protected EntryContainer parent;

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public abstract int getHeight();

        public void widthChanged(int newWidth) {
        }

        public void focusLost() {
        }

        @Generated
        public EntryContainer getParent() {
            return this.parent;
        }

        @Generated
        public void setParent(EntryContainer parent) {
            this.parent = parent;
        }
    }
}

