/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.util;

import com.mojang.blaze3d.systems.RenderSystem;
import de.siphalor.coat.util.CoatColor;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_8030;
import net.minecraft.class_9801;

public class CoatUtil {
    public static final CoatColor TEXT_COLOR = CoatColor.rgb(0xDDDDDD);
    public static final CoatColor SECONDARY_TEXT_COLOR = CoatColor.rgb(0xAAAAAA);
    public static final CoatColor HOVER_BG_COLOR = CoatColor.argb(0x2DFFFFFF);
    public static final int MARGIN = 2;
    public static final int DOUBLE_MARGIN = 4;
    public static final int HALF_MARGIN = 1;
    public static final String ELLIPSIS = "...";

    public static class_2561 intelliTrim(class_327 font, class_2561 baseText, int width) {
        int textWidth = font.method_27525((class_5348)baseText);
        if (textWidth > width) {
            textWidth = font.method_1727(ELLIPSIS);
            String trimmed = font.method_27523(baseText.getString(), width - textWidth);
            return class_2561.method_43470((String)(trimmed.trim() + ELLIPSIS)).method_10862(baseText.method_10866());
        }
        return baseText;
    }

    public static List<class_5481> wrapTooltip(class_327 font, class_310 minecraft, class_2561 text) {
        return font.method_1728((class_5348)text, minecraft.field_1755.field_22789 / 2);
    }

    public static void renderTooltip(class_332 graphics, int x, int y, class_2561 text) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.depthFunc((int)519);
        graphics.method_51447(minecraft.field_1772, CoatUtil.wrapTooltip(minecraft.field_1772, minecraft, text), x, y);
    }

    public static void drawOutline(class_332 graphics, int x1, int y1, int x2, int y2, CoatColor color) {
        graphics.method_49601(x1, y1, x2 - x1, y2 - y1, color.getArgb());
    }

    public static void drawHorizontalGradient(class_332 graphics, int left, int top, int right, int bottom, CoatColor leftColor, CoatColor rightColor) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((float)left, (float)bottom, 0.0f).method_39415(leftColor.getArgb());
        bufferBuilder.method_22912((float)right, (float)bottom, 0.0f).method_39415(rightColor.getArgb());
        bufferBuilder.method_22912((float)right, (float)top, 0.0f).method_39415(rightColor.getArgb());
        bufferBuilder.method_22912((float)left, (float)top, 0.0f).method_39415(leftColor.getArgb());
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int left, int top, int width, int height) {
        graphics.method_52706(class_1921::method_62277, texture, left, top, width, height);
    }

    public static void drawTintedTiledTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, int textureYOffset, CoatColor color) {
        int width = right - left;
        int height = bottom - top;
        graphics.method_25291(class_1921::method_62277, texture, left, top, (float)right, (float)(bottom + textureYOffset), width, height, textureScale, textureScale, color.getArgb());
    }

    public static void drawTiledTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, int textureYOffset) {
        int width = right - left;
        int height = bottom - top;
        graphics.method_25290(class_1921::method_62277, texture, left, top, (float)right, (float)(bottom + textureYOffset), width, height, textureScale, textureScale);
    }

    public static void drawInsetGradientTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, CoatColor outerColor, CoatColor innerColor) {
        int width = right - left;
        int height = bottom - top;
        int middleOffset = height / 2;
        class_8030 topLeft = new class_8030(left, top, middleOffset, middleOffset);
        class_8030 topMiddle = new class_8030(left + middleOffset, top, width - 2 * middleOffset, middleOffset);
        class_8030 topRight = new class_8030(right - middleOffset, top, middleOffset, middleOffset);
        class_8030 bottomLeft = new class_8030(left, top + middleOffset, middleOffset, middleOffset);
        class_8030 bottomMiddle = new class_8030(left + middleOffset, top + middleOffset, width - 2 * middleOffset, middleOffset);
        class_8030 bottomRight = new class_8030(right - middleOffset, top + middleOffset, middleOffset, middleOffset);
        graphics.method_64039(bufferSource -> {
            class_4588 consumer = bufferSource.getBuffer(class_1921.method_62277((class_2960)texture));
            CoatUtil.appendTintedTexturedRect(consumer, topLeft, textureScale, outerColor, outerColor, innerColor, outerColor);
            CoatUtil.appendTintedTexturedRect(consumer, topMiddle, textureScale, outerColor, outerColor, innerColor, innerColor);
            CoatUtil.appendTintedTexturedRect(consumer, topRight, textureScale, outerColor, outerColor, outerColor, innerColor);
            CoatUtil.appendTintedTexturedRect(consumer, bottomLeft, textureScale, outerColor, innerColor, outerColor, outerColor);
            CoatUtil.appendTintedTexturedRect(consumer, bottomMiddle, textureScale, innerColor, innerColor, outerColor, outerColor);
            CoatUtil.appendTintedTexturedRect(consumer, bottomRight, textureScale, innerColor, outerColor, outerColor, outerColor);
        });
    }

    private static void appendTintedTexturedRect(class_4588 vc, class_8030 rect, float textureScale, CoatColor topLeftColor, CoatColor topRightColor, CoatColor bottomRightColor, CoatColor bottomLeftColor) {
        vc.method_22912((float)rect.method_49620(), (float)rect.method_49618(), 0.0f).method_22913((float)rect.method_49620() / textureScale, (float)rect.method_49618() / textureScale).method_39415(topLeftColor.getArgb());
        vc.method_22912((float)rect.method_49620(), (float)rect.method_49619(), 0.0f).method_22913((float)rect.method_49620() / textureScale, (float)rect.method_49619() / textureScale).method_39415(bottomLeftColor.getArgb());
        vc.method_22912((float)rect.method_49621(), (float)rect.method_49619(), 0.0f).method_22913((float)rect.method_49621() / textureScale, (float)rect.method_49619() / textureScale).method_39415(bottomRightColor.getArgb());
        vc.method_22912((float)rect.method_49621(), (float)rect.method_49618(), 0.0f).method_22913((float)rect.method_49621() / textureScale, (float)rect.method_49618() / textureScale).method_39415(topRightColor.getArgb());
    }

    public static void playClickSound() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public static void setButtonPosition(class_4185 button, int x, int y) {
        CoatUtil.setButtonX(button, x);
        CoatUtil.setButtonY(button, y);
    }

    public static void setButtonX(class_4185 button, int x) {
        button.method_46421(x);
    }

    public static void setButtonY(class_4185 button, int y) {
        button.method_46419(y);
    }
}

