/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.list.category;

import de.siphalor.coat.handler.Message;
import de.siphalor.coat.list.complex.ConfigCategoryWidget;
import de.siphalor.coat.list.entry.ConfigContainerCompoundEntry;
import de.siphalor.coat.screen.ConfigContentWidget;
import de.siphalor.coat.screen.ConfigScreen;
import de.siphalor.coat.util.CoatUtil;
import de.siphalor.coat.util.TextButtonWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public class ConfigTreeEntry
extends ConfigContainerCompoundEntry {
    private static final String EXPAND_TEXT_KEY = "coat.tree.expand";
    private static final String COLLAPSE_TEXT_KEY = "coat.tree.collapse";
    private static final class_2561 EXPAND_TEXT = class_2561.method_43471((String)"coat.tree.expand");
    private static final class_2561 COLLAPSE_TEXT = class_2561.method_43471((String)"coat.tree.collapse");
    private final TextButtonWidget collapseButton;
    private final TextButtonWidget nameButton;
    private final List<ConfigTreeEntry> subTrees;
    private final ConfigContentWidget contentWidget;
    private final boolean temporary;
    private int x;
    private int y;
    private boolean open = false;
    private boolean expanded;
    @Nullable
    protected class_364 focused;

    public ConfigTreeEntry(class_2561 name, ConfigContentWidget contentWidget) {
        this(name, contentWidget, false);
    }

    public ConfigTreeEntry(class_2561 name, ConfigContentWidget contentWidget, boolean temporary) {
        this.contentWidget = contentWidget;
        this.temporary = temporary;
        this.collapseButton = new TextButtonWidget(this.x, this.y, 7, 9, EXPAND_TEXT, button -> this.setExpanded(!this.isExpanded()));
        this.nameButton = new TextButtonWidget(this.x, this.y, 100, 9, name, button -> ((ConfigScreen)class_310.method_1551().field_1755).openCategory(this));
        ArrayList<ConfigTreeEntry> list = new ArrayList<ConfigTreeEntry>();
        if (contentWidget instanceof ConfigCategoryWidget) {
            for (ConfigCategoryWidget configCategoryWidget : ((ConfigCategoryWidget)contentWidget).getSubTrees()) {
                ConfigTreeEntry treeEntry = configCategoryWidget.getTreeEntry();
                treeEntry.setParent(this);
                list.add(treeEntry);
            }
        }
        this.subTrees = list;
    }

    @Override
    public void render(class_332 graphics, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.x = x;
        this.y = y;
        boolean hoverFound = false;
        int indent = x + 6 + 4;
        int innerWidth = this.getEntryWidth();
        if (!this.subTrees.isEmpty()) {
            CoatUtil.setButtonPosition(this.collapseButton, x, y);
            this.collapseButton.method_25394(graphics, mouseX, mouseY, tickDelta);
        }
        CoatUtil.setButtonPosition(this.nameButton, indent, y);
        this.nameButton.method_25358(innerWidth);
        this.nameButton.method_25394(graphics, mouseX, mouseY, tickDelta);
        if (this.expanded) {
            int curY = y + this.getBaseHeight();
            for (ConfigTreeEntry entry : this.subTrees) {
                if (!hoverFound && mouseY > curY) {
                    hoverFound = true;
                    entry.render(graphics, indent, curY, innerWidth, entryHeight, mouseX, mouseY, true, tickDelta);
                } else {
                    entry.render(graphics, indent, curY, innerWidth, entryHeight, mouseX, mouseY, false, tickDelta);
                }
                curY += entry.getHeight();
            }
        }
    }

    public void setOpen(boolean open) {
        if (this.open != open) {
            if (open) {
                this.nameButton.method_25355((class_2561)this.nameButton.getOriginalMessage().method_27661().method_27694(style -> this.nameButton.getOriginalMessage().method_10866().method_10978(Boolean.valueOf(true))));
                this.setExpanded(true);
            } else {
                this.nameButton.method_25355((class_2561)this.nameButton.getOriginalMessage().method_27661().method_27694(style -> this.nameButton.getOriginalMessage().method_10866().method_10978(Boolean.valueOf(false))));
            }
        }
        this.open = open;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.parent != null) {
            this.parent.entryHeightChanged(this);
        }
        if (expanded) {
            this.collapseButton.method_25355(COLLAPSE_TEXT);
        } else {
            this.collapseButton.method_25355(EXPAND_TEXT);
        }
    }

    @Override
    public int getHeight() {
        if (this.expanded) {
            return this.getBaseHeight() + this.getExpansionHeight();
        }
        return this.getBaseHeight();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX <= (double)(this.x + this.getEntryWidth()) && mouseY <= (double)(this.y + this.getHeight());
    }

    public class_8030 method_48202() {
        return new class_8030(this.x, this.y, this.getEntryWidth(), this.getHeight());
    }

    public int getBaseHeight() {
        return 4 + this.nameButton.method_25364();
    }

    public int getExpansionHeight() {
        int height = 0;
        for (ConfigTreeEntry child : this.subTrees) {
            height += child.getHeight();
        }
        return height;
    }

    @Override
    public int getEntryWidth() {
        return this.parent.getEntryWidth() - 8 - 2;
    }

    @Override
    public Collection<Message> getMessages() {
        List<Message> messages = this.subTrees.stream().flatMap(entry -> entry.getMessages().stream()).collect(Collectors.toList());
        messages.addAll(this.contentWidget.getMessages());
        return messages;
    }

    public List<class_364> method_25396() {
        ArrayList<class_364> children = new ArrayList<class_364>(this.subTrees.size() + 2);
        if (!this.subTrees.isEmpty()) {
            children.add((class_364)this.collapseButton);
        }
        children.add((class_364)this.nameButton);
        children.addAll(this.subTrees);
        return children;
    }

    public void addTemporaryTree(ConfigTreeEntry temporaryTreeEntry) {
        temporaryTreeEntry.setParent(this);
        this.subTrees.add(temporaryTreeEntry);
        this.parent.entryHeightChanged(this);
    }

    public boolean removeTemporaryTrees() {
        boolean changed = false;
        Iterator<ConfigTreeEntry> iterator = this.subTrees.iterator();
        while (iterator.hasNext()) {
            ConfigTreeEntry subTree = iterator.next();
            if (subTree.isTemporary()) {
                iterator.remove();
                continue;
            }
            changed |= subTree.removeTemporaryTrees();
        }
        return changed;
    }

    @Override
    public void tick() {
        for (ConfigTreeEntry subTree : this.subTrees) {
            subTree.tick();
        }
    }

    @Override
    public void focusLost() {
        this.method_25395(null);
    }

    @Generated
    public List<ConfigTreeEntry> getSubTrees() {
        return this.subTrees;
    }

    @Generated
    public ConfigContentWidget getContentWidget() {
        return this.contentWidget;
    }

    @Generated
    public boolean isTemporary() {
        return this.temporary;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public boolean isOpen() {
        return this.open;
    }

    @Generated
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    @Nullable
    @Generated
    public class_364 method_25399() {
        return this.focused;
    }

    @Override
    @Generated
    public void method_25395(@Nullable class_364 focused) {
        this.focused = focused;
    }
}

