/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.coat.util;

import com.mojang.blaze3d.textures.GpuTextureView;
import de.siphalor.coat.util.CoatColor;
import de.siphalor.coat.util.renderstate.CoatGuiGraphics;
import de.siphalor.coat.util.renderstate.IndividuallyColoredBlitRenderState;
import de.siphalor.coat.util.renderstate.IndividuallyColoredRectangleRenderState;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11231;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector4f;

public class CoatUtil {
    public static final CoatColor TEXT_COLOR = CoatColor.rgb(0xDDDDDD);
    public static final CoatColor SECONDARY_TEXT_COLOR = CoatColor.rgb(0xAAAAAA);
    public static final CoatColor HOVER_BG_COLOR = CoatColor.argb(0x2DFFFFFF);
    public static final int MARGIN = 2;
    public static final int DOUBLE_MARGIN = 4;
    public static final int HALF_MARGIN = 1;

    public static void drawLeftAlignedText(class_332 graphics, class_327 font, class_2561 text, class_8030 rect, CoatColor color) {
        int textWidth = font.method_27525((class_5348)text);
        if (textWidth <= rect.comp_1196()) {
            graphics.method_27535(font, text, rect.method_49620(), rect.method_49618(), color.getArgb());
        } else {
            class_339.method_52718((class_332)graphics, (class_327)font, (class_2561)text, (int)rect.method_49620(), (int)rect.method_49618(), (int)rect.method_49621(), (int)rect.method_49619(), (int)color.getArgb());
        }
    }

    public static void drawOutline(class_332 graphics, int x1, int y1, int x2, int y2, CoatColor color) {
        graphics.method_49601(x1, y1, x2 - x1, y2 - y1, color.getArgb());
    }

    public static void drawHorizontalGradient(class_332 graphics, int left, int top, int right, int bottom, CoatColor leftColor, CoatColor rightColor) {
        class_8030 rect = new class_8030(left, top, right - left, bottom - top);
        CoatGuiGraphics coatGraphics = (CoatGuiGraphics)graphics;
        coatGraphics.coat_submitGuiRenderState(new IndividuallyColoredRectangleRenderState(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), rect, leftColor.getArgb(), rightColor.getArgb(), rightColor.getArgb(), leftColor.getArgb(), coatGraphics.coat_currentScissorArea()));
    }

    public static void drawTexture(class_332 graphics, class_2960 texture, int left, int top, int width, int height) {
        graphics.method_52706(class_10799.field_56883, texture, left, top, width, height);
    }

    public static void drawTintedTiledTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, int textureYOffset, CoatColor color) {
        int width = right - left;
        int height = bottom - top;
        graphics.method_25291(class_10799.field_56883, texture, left, top, (float)right, (float)(bottom + textureYOffset), width, height, textureScale, textureScale, color.getArgb());
    }

    public static void drawTiledTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, int textureYOffset) {
        int width = right - left;
        int height = bottom - top;
        graphics.method_25290(class_10799.field_56883, texture, left, top, (float)right, (float)(bottom + textureYOffset), width, height, textureScale, textureScale);
    }

    public static void drawInsetGradientTexture(class_332 graphics, class_2960 texture, int left, int top, int right, int bottom, int textureScale, CoatColor outerColor, CoatColor innerColor) {
        int width = right - left;
        int height = bottom - top;
        int middleOffset = height / 2;
        class_8030 topLeft = new class_8030(left, top, middleOffset, middleOffset);
        class_8030 topMiddle = new class_8030(left + middleOffset, top, width - 2 * middleOffset, middleOffset);
        class_8030 topRight = new class_8030(right - middleOffset, top, middleOffset, middleOffset);
        class_8030 bottomLeft = new class_8030(left, top + middleOffset, middleOffset, middleOffset);
        class_8030 bottomMiddle = new class_8030(left + middleOffset, top + middleOffset, width - 2 * middleOffset, middleOffset);
        class_8030 bottomRight = new class_8030(right - middleOffset, top + middleOffset, middleOffset, middleOffset);
        class_11231 textureSetup = class_11231.method_70900((GpuTextureView)class_310.method_1551().method_1531().method_4619(texture).method_71659());
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, topLeft, textureScale, outerColor, outerColor, innerColor, outerColor);
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, topMiddle, textureScale, outerColor, outerColor, innerColor, innerColor);
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, topRight, textureScale, outerColor, outerColor, outerColor, innerColor);
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, bottomLeft, textureScale, outerColor, innerColor, outerColor, outerColor);
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, bottomMiddle, textureScale, innerColor, innerColor, outerColor, outerColor);
        CoatUtil.submitIndividuallyColoredBlitRectable(graphics, textureSetup, bottomRight, textureScale, innerColor, outerColor, outerColor, outerColor);
    }

    private static void submitIndividuallyColoredBlitRectable(class_332 graphics, class_11231 textureSetup, class_8030 rect, float textureScale, CoatColor topLeftColor, CoatColor topRightColor, CoatColor bottomRightColor, CoatColor bottomLeftColor) {
        CoatGuiGraphics coatGraphics = (CoatGuiGraphics)graphics;
        coatGraphics.coat_submitGuiRenderState(new IndividuallyColoredBlitRenderState(class_10799.field_56883, textureSetup, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), rect, CoatUtil.asVector4f(rect).div(textureScale), topLeftColor.getArgb(), topRightColor.getArgb(), bottomRightColor.getArgb(), bottomLeftColor.getArgb(), coatGraphics.coat_currentScissorArea()));
    }

    private static Vector4f asVector4f(class_8030 rect) {
        return new Vector4f((float)rect.method_49620(), (float)rect.method_49618(), (float)rect.method_49621(), (float)rect.method_49619());
    }

    public static void playClickSound() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public static void setButtonPosition(class_4185 button, int x, int y) {
        CoatUtil.setButtonX(button, x);
        CoatUtil.setButtonY(button, y);
    }

    public static void setButtonX(class_4185 button, int x) {
        button.method_46421(x);
    }

    public static void setButtonY(class_4185 button, int y) {
        button.method_46419(y);
    }
}

