/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl;

import de.siphalor.jcyo.core.api.JcyoOptions;
import de.siphalor.jcyo.core.impl.CommentStyle;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.CharacterLiteralToken;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.IdentifierToken;
import de.siphalor.jcyo.core.impl.token.JavaKeyword;
import de.siphalor.jcyo.core.impl.token.JavaKeywordToken;
import de.siphalor.jcyo.core.impl.token.JcyoDirectiveStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoEndToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.NumberLiteralToken;
import de.siphalor.jcyo.core.impl.token.OperatorToken;
import de.siphalor.jcyo.core.impl.token.PlainJavaCommentToken;
import de.siphalor.jcyo.core.impl.token.RepresentableToken;
import de.siphalor.jcyo.core.impl.token.StringLiteralToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.token.WhitespaceToken;
import java.io.IOException;
import java.io.Reader;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

public class JcyoLexer
implements AutoCloseable,
TokenStream {
    @Generated
    private static final Log log = LogFactory.getLog(JcyoLexer.class);
    private final Reader reader;
    private final JcyoOptions options;
    private final StringBuilder buffer = new StringBuilder();
    private int peek = -1;
    private @Nullable RepresentableToken nextToken = null;
    private boolean inDisabledFlexComment = false;

    @Override
    public Token nextToken() {
        int codepoint;
        if (this.nextToken != null) {
            RepresentableToken token = this.nextToken;
            this.nextToken = null;
            return token;
        }
        block10: while (true) {
            codepoint = this.peek();
            switch (codepoint) {
                case -1: {
                    return EofToken.instance();
                }
                case 47: {
                    this.buffer.appendCodePoint(this.eat());
                    codepoint = this.peek();
                    if (codepoint == 47) {
                        this.buffer.appendCodePoint(this.eat());
                        codepoint = this.peek();
                        if (codepoint == this.options.commandPrefix()) {
                            this.buffer.appendCodePoint(this.eat());
                            return new JcyoDirectiveStartToken(this.takeFromBuffer(), CommentStyle.LINE);
                        }
                        if (codepoint == this.options.disabledPrefix()) {
                            this.buffer.appendCodePoint(this.eat());
                            return new JcyoDisabledStartToken(this.takeFromBuffer(), CommentStyle.LINE);
                        }
                        if (codepoint == 47) {
                            this.buffer.appendCodePoint(this.eat());
                            this.chompToAnyExclusive(new int[]{10, 13});
                            return new PlainJavaCommentToken(this.takeFromBuffer(), CommentStyle.LINE, true);
                        }
                        this.chompToAnyExclusive(new int[]{10, 13});
                        return new PlainJavaCommentToken(this.takeFromBuffer(), CommentStyle.LINE, false);
                    }
                    if (codepoint == 42) {
                        boolean javadoc;
                        this.buffer.appendCodePoint(this.eat());
                        codepoint = this.peek();
                        if (codepoint == this.options.commandPrefix()) {
                            this.buffer.appendCodePoint(this.eat());
                            return new JcyoDirectiveStartToken(this.takeFromBuffer(), CommentStyle.FLEX);
                        }
                        if (codepoint == this.options.disabledPrefix()) {
                            this.buffer.appendCodePoint(this.eat());
                            if (this.inDisabledFlexComment) {
                                log.warn((Object)"Encountered nested disabled flex comment.This is not supported and will be ignored.");
                                continue block10;
                            }
                            this.inDisabledFlexComment = true;
                            return new JcyoDisabledStartToken(this.takeFromBuffer(), CommentStyle.FLEX);
                        }
                        boolean bl = javadoc = codepoint == 42;
                        if (javadoc) {
                            this.buffer.appendCodePoint(this.eat());
                        }
                        this.chompToMultilineCommentEnd();
                        if (this.inDisabledFlexComment) {
                            this.inDisabledFlexComment = false;
                            this.nextToken = JcyoEndToken.implicit();
                        }
                        return new PlainJavaCommentToken(this.takeFromBuffer(), CommentStyle.FLEX, javadoc);
                    }
                    this.clearBuffer();
                    return new OperatorToken(47);
                }
                case 42: {
                    this.buffer.appendCodePoint(this.eat());
                    if (this.peek() == 47) {
                        this.buffer.appendCodePoint(this.eat());
                        if (this.inDisabledFlexComment) {
                            this.inDisabledFlexComment = false;
                            this.nextToken = JcyoEndToken.implicit();
                        }
                        return new JcyoEndToken(this.takeFromBuffer());
                    }
                    this.clearBuffer();
                    return new OperatorToken(42);
                }
                case 39: {
                    this.buffer.appendCodePoint(this.eat());
                    this.chompToInclusive(39);
                    return new CharacterLiteralToken(this.takeFromBuffer());
                }
                case 34: {
                    this.buffer.appendCodePoint(this.eat());
                    if (this.eatToBuffer() == 34) {
                        if (this.eatToBuffer() == 34) {
                            int quoteCount = 0;
                            while (true) {
                                if ((codepoint = this.eatToBuffer()) == 92) {
                                    quoteCount = 0;
                                    this.buffer.appendCodePoint(this.eat());
                                    continue;
                                }
                                if (codepoint == 34) {
                                    if (++quoteCount < 3) continue;
                                    break;
                                }
                                if (codepoint == -1) break;
                                quoteCount = 0;
                            }
                        }
                        return new StringLiteralToken(this.takeFromBuffer());
                    }
                    while (true) {
                        if ((codepoint = this.eatToBuffer()) == 92) {
                            this.buffer.appendCodePoint(this.eat());
                            continue;
                        }
                        if (codepoint == 34) {
                            return new StringLiteralToken(this.takeFromBuffer());
                        }
                        if (codepoint == -1) break;
                    }
                    return new StringLiteralToken(this.takeFromBuffer());
                }
                case 10: {
                    this.buffer.appendCodePoint(this.eat());
                    if (this.peek() == 13) {
                        this.buffer.appendCodePoint(this.eat());
                        return new LineBreakToken(this.takeFromBuffer());
                    }
                    return new LineBreakToken(this.takeFromBuffer());
                }
                case 13: {
                    this.buffer.appendCodePoint(this.eat());
                    if (this.peek() == 10) {
                        this.buffer.appendCodePoint(this.eat());
                        return new LineBreakToken(this.takeFromBuffer());
                    }
                    return new LineBreakToken(this.takeFromBuffer());
                }
                case 46: {
                    this.eat();
                    if (Character.isDigit(this.peek())) {
                        this.buffer.appendCodePoint(46);
                        this.chompNumeric();
                        return new NumberLiteralToken(this.takeFromBuffer());
                    }
                    return new OperatorToken(46);
                }
            }
            break;
        }
        if (Character.isJavaIdentifierStart(codepoint)) {
            do {
                this.buffer.appendCodePoint(this.eat());
            } while (Character.isJavaIdentifierPart(this.peek()));
            String identifier = this.takeFromBuffer();
            JavaKeyword keyword = JavaKeyword.getKeyword(identifier);
            if (keyword != null) {
                return new JavaKeywordToken(keyword);
            }
            return new IdentifierToken(identifier);
        }
        if (Character.isWhitespace(codepoint)) {
            this.eat();
            return new WhitespaceToken(codepoint);
        }
        if (Character.isDigit(codepoint)) {
            this.chompNumeric();
            return new NumberLiteralToken(this.takeFromBuffer());
        }
        this.eat();
        return new OperatorToken(codepoint);
    }

    private void chompToMultilineCommentEnd() {
        int codepoint;
        while (!((codepoint = this.eatToBuffer()) == 42 ? (codepoint = this.eatToBuffer()) == 47 : codepoint == -1)) {
        }
    }

    private void chompNumeric() {
        int codepoint;
        while ((codepoint = this.peek()) != -1 && (Character.isDigit(codepoint) || codepoint == 46 || Character.isLetter(codepoint))) {
            this.buffer.appendCodePoint(this.eat());
        }
    }

    private void chompToInclusive(int stop) {
        int codepoint;
        while ((codepoint = this.eatToBuffer()) != stop && codepoint != -1) {
        }
    }

    private void chompToAnyExclusive(int[] stops) {
        while (true) {
            int codepoint = this.peek();
            for (int stop : stops) {
                if (codepoint != stop) continue;
                return;
            }
            if (codepoint == -1) {
                return;
            }
            this.buffer.appendCodePoint(this.eat());
        }
    }

    private int eatToBuffer() {
        int codepoint = this.eat();
        if (codepoint != -1) {
            this.buffer.appendCodePoint(codepoint);
        }
        return codepoint;
    }

    private int eat() {
        if (this.peek >= 0) {
            int value = this.peek;
            this.peek = -1;
            return value;
        }
        return this.readNextCodepoint();
    }

    private int peek() {
        if (this.peek < 0) {
            this.peek = this.readNextCodepoint();
        }
        return this.peek;
    }

    private int readNextCodepoint() {
        try {
            return this.reader.read();
        }
        catch (IOException e) {
            throw new JcyoParseException(e);
        }
    }

    private String takeFromBuffer() {
        String string = this.buffer.toString();
        this.clearBuffer();
        return string;
    }

    private void clearBuffer() {
        this.buffer.setLength(0);
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    @Generated
    public JcyoLexer(Reader reader, JcyoOptions options) {
        this.reader = reader;
        this.options = options;
    }
}

