/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl;

import de.siphalor.jcyo.core.api.JcyoOptions;
import de.siphalor.jcyo.core.api.JcyoProcessingException;
import de.siphalor.jcyo.core.api.JcyoVariables;
import de.siphalor.jcyo.core.impl.JcyoLexer;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.TokenWriter;
import de.siphalor.jcyo.core.impl.stream.TokenBuffer;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.transform.GeneratedAndDisabledTokenRemover;
import de.siphalor.jcyo.core.impl.transform.JcyoCleaner;
import de.siphalor.jcyo.core.impl.transform.JcyoDirectiveApplier;
import de.siphalor.jcyo.core.impl.transform.JcyoUnpadder;
import de.siphalor.jcyo.core.impl.transform.UnusedImportDisabler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public class JcyoProcessor {
    private final JcyoOptions options;
    private final Path baseDirectory;
    private final @Nullable Path cleanOutputDirectory;
    private final JcyoDirectiveApplier directiveApplier;
    private final UnusedImportDisabler unusedImportDisabler;

    public JcyoProcessor(JcyoVariables variables, JcyoOptions options, Path baseDirectory, @Nullable Path cleanOutputDirectory) {
        this.options = options;
        this.baseDirectory = baseDirectory.normalize().toAbsolutePath();
        this.cleanOutputDirectory = cleanOutputDirectory;
        this.directiveApplier = new JcyoDirectiveApplier(variables);
        this.unusedImportDisabler = new UnusedImportDisabler();
    }

    public void process(Path inputFile) throws JcyoProcessingException {
        Path absoluteInput = inputFile.normalize().toAbsolutePath();
        if (!absoluteInput.startsWith(this.baseDirectory)) {
            throw new IllegalArgumentException("Input files must be inside the base directory: " + String.valueOf(this.baseDirectory));
        }
        File input = absoluteInput.toFile();
        File cleanOutput = this.getCleanOutputFileForInputPath(absoluteInput);
        this.processFile(input, cleanOutput);
    }

    private @Nullable File getCleanOutputFileForInputPath(Path inputPath) {
        if (this.cleanOutputDirectory == null) {
            return null;
        }
        return this.cleanOutputDirectory.resolve(this.baseDirectory.relativize(inputPath)).toFile();
    }

    void processFile(File input, @Nullable File cleanOutput) throws JcyoProcessingException {
        InputStream inputStream = null;
        try {
            MessageDigest digest = null;
            inputStream = new FileInputStream(input);
            if (this.options.updateInput()) {
                digest = MessageDigest.getInstance("SHA-1");
                inputStream = new DigestInputStream(inputStream, digest);
            }
            TokenStream processedTokenStream = this.getProcessedTokensStreamForFile(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            if (this.options.updateInput()) {
                if (cleanOutput == null) {
                    this.updateFileOnChanged(input, digest, processedTokenStream);
                } else {
                    TokenBuffer copy = new TokenBuffer();
                    this.updateFileOnChanged(input, digest, copy.copying(processedTokenStream));
                    this.writeToFile(cleanOutput, new JcyoCleaner(copy));
                }
            } else {
                assert (cleanOutput != null);
                this.writeToFile(cleanOutput, processedTokenStream);
            }
        }
        catch (IOException e) {
            throw new JcyoProcessingException("Failed to read input file: " + String.valueOf(input), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JcyoProcessingException("Failed to initialize SHA-1 digest", e);
        }
        finally {
            assert (inputStream != null);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    TokenStream getProcessedTokensStreamForFile(Reader input) throws JcyoProcessingException {
        TokenStream tokenStream;
        JcyoLexer lexer = new JcyoLexer(input, this.options);
        try {
            GeneratedAndDisabledTokenRemover streamWithOldStuffRemoved = new GeneratedAndDisabledTokenRemover(new JcyoUnpadder(lexer), this.options);
            TokenStream streamWithDirectivesApplied = this.directiveApplier.apply(streamWithOldStuffRemoved);
            tokenStream = this.unusedImportDisabler.apply(streamWithDirectivesApplied);
        }
        catch (Throwable throwable) {
            try {
                try {
                    lexer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JcyoParseException e) {
                throw new JcyoProcessingException("Failed to parse input file: " + String.valueOf(input), e);
            }
            catch (Exception e) {
                throw new JcyoProcessingException("Unexpected exception for input file: " + String.valueOf(input), e);
            }
        }
        lexer.close();
        return tokenStream;
    }

    void updateFileOnChanged(File file, MessageDigest oldDigest, TokenStream tokenStream) throws JcyoProcessingException {
        MessageDigest newDigest;
        File tempFile = this.createTempFileForOutput(file);
        try {
            newDigest = MessageDigest.getInstance(oldDigest.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JcyoProcessingException("Missing digest algorithm: " + oldDigest.getAlgorithm(), e);
        }
        try (DigestOutputStream outputStream = new DigestOutputStream(new FileOutputStream(tempFile), newDigest);
             TokenWriter writer = new TokenWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8)), this.options);){
            writer.writeAll(tokenStream);
        }
        catch (IOException e) {
            throw new JcyoProcessingException("Failed to write to temporary output file: " + String.valueOf(tempFile), e);
        }
        if (!Arrays.equals(newDigest.digest(), oldDigest.digest())) {
            if (!file.delete()) {
                throw new JcyoProcessingException("Failed to delete file: " + String.valueOf(file));
            }
            try {
                Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new JcyoProcessingException("Failed to move temporary output file: " + String.valueOf(tempFile) + " to: " + String.valueOf(file), e);
            }
        } else {
            tempFile.deleteOnExit();
        }
    }

    private File createTempFileForOutput(File file) throws JcyoProcessingException {
        try {
            return Files.createTempFile("jcyo-processor", file.getName(), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new JcyoProcessingException("Failed to create temporary file", e);
        }
    }

    void writeToFile(File file, TokenStream tokenStream) throws JcyoProcessingException {
        file.getParentFile().mkdirs();
        try (TokenWriter writer = new TokenWriter((Writer)new BufferedWriter(new FileWriter(file)), this.options);){
            writer.writeAll(tokenStream);
        }
        catch (IOException e) {
            throw new JcyoProcessingException("Failed to write to file: " + String.valueOf(file), e);
        }
    }
}

