/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl;

import de.siphalor.jcyo.core.api.JcyoOptions;
import de.siphalor.jcyo.core.impl.CommentStyle;
import de.siphalor.jcyo.core.impl.JcyoHelper;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionEndToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoEndToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.PlainJavaCommentToken;
import de.siphalor.jcyo.core.impl.token.RepresentableToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.token.WhitespaceToken;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class TokenWriter
implements AutoCloseable {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\r\n|\r|\n|$");
    private final Writer writer;
    private final JcyoHelper helper;
    private @Nullable JcyoDisabledState disabledState;

    public TokenWriter(Writer writer, JcyoOptions options) {
        this(writer, new JcyoHelper(options));
    }

    public void writeAll(TokenStream tokenStream) throws IOException {
        Token token;
        while (!((token = tokenStream.nextToken()) instanceof EofToken)) {
            this.write(token);
        }
        return;
    }

    public void write(Token token) throws IOException {
        if (this.disabledState == null) {
            this.writePlain(token);
            return;
        }
        switch (this.disabledState.disabledStartToken().suggestedCommentStyle()) {
            case LINE: {
                this.writeInDisabledLineMode(token);
                break;
            }
            case FLEX: {
                this.writeInDisabledFlexMode(token);
            }
        }
    }

    private void writePlain(Token token) throws IOException {
        assert (this.disabledState == null);
        Token token2 = token;
        Objects.requireNonNull(token2);
        Token token3 = token2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EofToken.class, RepresentableToken.class, JcyoDisabledRegionStartToken.class}, (Token)token3, n)) {
            case 0: {
                break;
            }
            case 1: {
                RepresentableToken representableToken = (RepresentableToken)token3;
                this.writer.write(representableToken.raw());
                break;
            }
            case 2: {
                JcyoDisabledRegionStartToken startToken = (JcyoDisabledRegionStartToken)token3;
                this.disabledState = new JcyoDisabledState(startToken);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected token: " + String.valueOf(token));
            }
        }
    }

    private void writeInDisabledLineMode(Token token) throws IOException {
        assert (this.disabledState != null);
        Token token2 = token;
        Objects.requireNonNull(token2);
        Token token3 = token2;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EofToken.class, JcyoDisabledRegionEndToken.class, JcyoDisabledRegionStartToken.class, LineBreakToken.class, WhitespaceToken.class, WhitespaceToken.class, PlainJavaCommentToken.class, RepresentableToken.class, RepresentableToken.class}, (Token)token3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    break block11;
                }
                case 1: {
                    this.disabledState = null;
                    break block11;
                }
                case 2: {
                    throw new IllegalArgumentException("Unexpected disabled region start token, already in disabled region: " + String.valueOf(token));
                }
                case 3: {
                    LineBreakToken lineBreakToken = (LineBreakToken)token3;
                    this.writer.write(lineBreakToken.raw());
                    this.disabledState.reset();
                    break block11;
                }
                case 4: {
                    WhitespaceToken whitespaceToken = (WhitespaceToken)token3;
                    if (this.disabledState.disabledPending()) {
                        n = 5;
                        continue block11;
                    }
                    this.writer.write(whitespaceToken.raw());
                    break block11;
                }
                case 5: {
                    WhitespaceToken whitespaceToken = (WhitespaceToken)token3;
                    if (this.disabledState.fulfilledIndent() >= this.disabledState.disabledStartToken().suggestedIndent().length()) {
                        n = 6;
                        continue block11;
                    }
                    String suggestedIndent = this.disabledState.disabledStartToken().suggestedIndent();
                    if (whitespaceToken.codepoint() == 9 == (suggestedIndent.charAt(this.disabledState.fulfilledIndent()) == '\t')) {
                        this.disabledState.fulfilledIndent(this.disabledState.fulfilledIndent() + 1);
                        this.writer.write(whitespaceToken.raw());
                        break block11;
                    }
                    this.writer.write(this.helper.disabledForLine());
                    this.disabledState.disabledPending(false);
                    this.writer.write(whitespaceToken.raw());
                    break block11;
                }
                case 6: {
                    PlainJavaCommentToken commentToken = (PlainJavaCommentToken)token3;
                    if (commentToken.commentStyle() != CommentStyle.FLEX) {
                        n = 7;
                        continue block11;
                    }
                    this.writeFlexCommentInDisabledLineMode(commentToken);
                    break block11;
                }
                case 7: {
                    RepresentableToken representableToken = (RepresentableToken)token3;
                    if (!this.disabledState.disabledPending()) {
                        n = 8;
                        continue block11;
                    }
                    this.writer.write(this.helper.disabledForLine());
                    this.disabledState.disabledPending(false);
                    this.writer.write(representableToken.raw());
                    break block11;
                }
                case 8: {
                    RepresentableToken representableToken = (RepresentableToken)token3;
                    this.writer.write(representableToken.raw());
                    break block11;
                }
            }
            break;
        }
    }

    private void writeFlexCommentInDisabledLineMode(PlainJavaCommentToken commentToken) throws IOException {
        assert (this.disabledState != null);
        if (this.disabledState.disabledPending()) {
            this.writer.write(this.helper.disabledForLine());
            this.disabledState.disabledPending(false);
        }
        String raw = commentToken.raw();
        Matcher matcher = LINE_BREAK_PATTERN.matcher(raw);
        int pos = 0;
        if (matcher.find()) {
            this.writer.write(raw, pos, matcher.end() - pos);
            pos = matcher.end();
        }
        String suggestedIndent = this.disabledState.disabledStartToken().suggestedIndent();
        while (matcher.find()) {
            int lineStart = pos;
            while (pos < matcher.start()) {
                if (pos - lineStart >= suggestedIndent.length()) {
                    if (pos + 1 >= matcher.start()) {
                        this.writer.write(this.helper.disabledForLineNoWhitespace());
                        break;
                    }
                    this.writer.write(this.helper.disabledForLine());
                    break;
                }
                char rawChar = raw.charAt(pos);
                char suggestedIndentChar = suggestedIndent.charAt(pos - lineStart);
                if (rawChar == ' ' && suggestedIndentChar != '\t') {
                    this.writer.write(rawChar);
                } else if (rawChar == '\t' && suggestedIndentChar == '\t') {
                    this.writer.write(rawChar);
                } else {
                    if (pos + 1 >= matcher.start()) {
                        this.writer.write(this.helper.disabledForLineNoWhitespace());
                        break;
                    }
                    this.writer.write(this.helper.disabledForLine());
                    break;
                }
                ++pos;
            }
            this.writer.write(raw, pos, matcher.end() - pos);
            pos = matcher.end();
        }
    }

    private void writeInDisabledFlexMode(Token token) throws IOException {
        assert (this.disabledState != null);
        Token token2 = token;
        Objects.requireNonNull(token2);
        Token token3 = token2;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EofToken.class, JcyoDisabledRegionEndToken.class, JcyoDisabledRegionStartToken.class, JcyoEndToken.class, PlainJavaCommentToken.class, LineBreakToken.class, RepresentableToken.class, RepresentableToken.class}, (Token)token3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    break block10;
                }
                case 1: {
                    this.writer.write(this.helper.disabledForFlexEnd());
                    this.disabledState = null;
                    break block10;
                }
                case 2: {
                    throw new IllegalArgumentException("Unexpected disabled region start token, already in disabled region: " + String.valueOf(token));
                }
                case 3: {
                    JcyoEndToken endToken = (JcyoEndToken)token3;
                    this.writer.write(endToken.raw());
                    this.disabledState.disabledPending(true);
                    break block10;
                }
                case 4: {
                    PlainJavaCommentToken commentToken = (PlainJavaCommentToken)token3;
                    if (commentToken.commentStyle() != CommentStyle.FLEX) {
                        n = 5;
                        continue block10;
                    }
                    this.writer.write(commentToken.raw());
                    this.disabledState.disabledPending(true);
                    break block10;
                }
                case 5: {
                    LineBreakToken lineBreakToken = (LineBreakToken)token3;
                    if (!this.disabledState.disabledPending()) {
                        n = 6;
                        continue block10;
                    }
                    this.writer.write(this.helper.disabledForFlexStartNoWhitespace());
                    this.disabledState.disabledPending(false);
                    this.writer.write(lineBreakToken.raw());
                    break block10;
                }
                case 6: {
                    RepresentableToken representableToken = (RepresentableToken)token3;
                    if (!this.disabledState.disabledPending()) {
                        n = 7;
                        continue block10;
                    }
                    this.writer.write(this.helper.disabledForFlexStart());
                    this.disabledState.disabledPending(false);
                    this.writer.write(representableToken.raw());
                    break block10;
                }
                case 7: {
                    RepresentableToken representableToken = (RepresentableToken)token3;
                    this.writer.write(representableToken.raw());
                    break block10;
                }
            }
            break;
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Generated
    protected TokenWriter(Writer writer, JcyoHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    private static class JcyoDisabledState {
        private final JcyoDisabledRegionStartToken disabledStartToken;
        private boolean disabledPending = true;
        private int fulfilledIndent;

        public void reset() {
            this.disabledPending = true;
            this.fulfilledIndent = 0;
        }

        @Generated
        public JcyoDisabledState(JcyoDisabledRegionStartToken disabledStartToken) {
            this.disabledStartToken = disabledStartToken;
        }

        @Generated
        public JcyoDisabledRegionStartToken disabledStartToken() {
            return this.disabledStartToken;
        }

        @Generated
        public boolean disabledPending() {
            return this.disabledPending;
        }

        @Generated
        public int fulfilledIndent() {
            return this.fulfilledIndent;
        }

        @Generated
        public JcyoDisabledState disabledPending(boolean disabledPending) {
            this.disabledPending = disabledPending;
            return this;
        }

        @Generated
        public JcyoDisabledState fulfilledIndent(int fulfilledIndent) {
            this.fulfilledIndent = fulfilledIndent;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JcyoDisabledState)) {
                return false;
            }
            JcyoDisabledState other = (JcyoDisabledState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.disabledPending() != other.disabledPending()) {
                return false;
            }
            if (this.fulfilledIndent() != other.fulfilledIndent()) {
                return false;
            }
            JcyoDisabledRegionStartToken this$disabledStartToken = this.disabledStartToken();
            JcyoDisabledRegionStartToken other$disabledStartToken = other.disabledStartToken();
            return !(this$disabledStartToken == null ? other$disabledStartToken != null : !((Object)this$disabledStartToken).equals(other$disabledStartToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JcyoDisabledState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.disabledPending() ? 79 : 97);
            result = result * 59 + this.fulfilledIndent();
            JcyoDisabledRegionStartToken $disabledStartToken = this.disabledStartToken();
            result = result * 59 + ($disabledStartToken == null ? 43 : ((Object)$disabledStartToken).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TokenWriter.JcyoDisabledState(disabledStartToken=" + String.valueOf(this.disabledStartToken()) + ", disabledPending=" + this.disabledPending() + ", fulfilledIndent=" + this.fulfilledIndent() + ")";
        }
    }
}

