/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.expression;

import de.siphalor.jcyo.core.api.value.JcyoBoolean;
import de.siphalor.jcyo.core.api.value.JcyoNumber;
import de.siphalor.jcyo.core.api.value.JcyoString;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.expression.JcyoBinaryOperator;
import de.siphalor.jcyo.core.impl.expression.JcyoConstant;
import de.siphalor.jcyo.core.impl.expression.JcyoExpression;
import de.siphalor.jcyo.core.impl.expression.JcyoUnaryOperator;
import de.siphalor.jcyo.core.impl.expression.JcyoVariableReference;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.token.IdentifierToken;
import de.siphalor.jcyo.core.impl.token.JavaKeyword;
import de.siphalor.jcyo.core.impl.token.JavaKeywordToken;
import de.siphalor.jcyo.core.impl.token.NumberLiteralToken;
import de.siphalor.jcyo.core.impl.token.OperatorToken;
import de.siphalor.jcyo.core.impl.token.StringLiteralToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.token.WhitespaceToken;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ExpressionParser {
    private final PeekableTokenStream tokenStream;

    public JcyoExpression nextExpression() {
        ArrayList<JcyoExpression> values = new ArrayList<JcyoExpression>();
        values.add(this.nextValueExpression());
        ArrayList<JcyoBinaryOperator.Type> binaryOperators = new ArrayList<JcyoBinaryOperator.Type>();
        while (true) {
            this.chompWhitespace();
            Optional<JcyoBinaryOperator.Type> binaryOperator = this.tryParseBinaryOperator();
            if (binaryOperator.isEmpty()) break;
            this.chompWhitespace();
            binaryOperators.add(binaryOperator.get());
            values.add(this.nextValueExpression());
        }
        return this.stitchBinaryOperators(values, binaryOperators);
    }

    private JcyoExpression nextValueExpression() {
        this.chompWhitespace();
        return this.tryParseParenthesizedExpression().or(this::tryParsePrefixedExpression).or(this::tryParseConstant).or(this::tryParseVariableReference).orElseThrow(() -> new JcyoParseException("Unexpected token " + String.valueOf(this.tokenStream.peekToken())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<JcyoExpression> tryParseParenthesizedExpression() {
        int codepoint2;
        int n3;
        Token token = this.tokenStream.peekToken();
        if (!(token instanceof OperatorToken)) return Optional.empty();
        OperatorToken operatorToken = (OperatorToken)token;
        try {
            int codepoint;
            int n;
            int n2 = n = operatorToken.codepoint();
            if (!true || (codepoint = n) != 40) return Optional.empty();
            this.tokenStream.nextToken();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        JcyoExpression inner = this.nextExpression();
        this.chompWhitespace();
        Token token2 = this.tokenStream.nextToken();
        if (!(token2 instanceof OperatorToken)) throw new JcyoParseException("Expected closing parenthesis, got: " + String.valueOf(this.tokenStream.peekToken()));
        OperatorToken operatorToken2 = (OperatorToken)token2;
        int n4 = n3 = operatorToken2.codepoint();
        if (true && (codepoint2 = n3) == 41) return Optional.of(inner);
        throw new JcyoParseException("Expected closing parenthesis, got: " + String.valueOf(this.tokenStream.peekToken()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<JcyoExpression> tryParsePrefixedExpression() {
        int codepoint;
        Token token = this.tokenStream.peekToken();
        if (!(token instanceof OperatorToken)) return Optional.empty();
        OperatorToken operatorToken = (OperatorToken)token;
        try {
            int n;
            int n2 = n = operatorToken.codepoint();
            if (!true) return Optional.empty();
            codepoint = n;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        switch (codepoint) {
            case 45: {
                this.tokenStream.nextToken();
                return Optional.of(new JcyoUnaryOperator(JcyoUnaryOperator.Type.MINUS, this.nextValueExpression()));
            }
            case 33: {
                this.tokenStream.nextToken();
                return Optional.of(new JcyoUnaryOperator(JcyoUnaryOperator.Type.NOT, this.nextValueExpression()));
            }
        }
        return Optional.empty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Optional<JcyoConstant> tryParseConstant() {
        v0 = token = this.tokenStream.peekToken();
        Objects.requireNonNull(v0);
        var2_2 = v0;
        var3_4 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JavaKeywordToken.class, NumberLiteralToken.class, StringLiteralToken.class}, (Token)var2_2, var3_4)) {
            case 0: {
                var5_5 = (JavaKeywordToken)var2_2;
                keyword = var7_6 = var5_5.keyword();
                if (keyword != JavaKeyword.TRUE) ** GOTO lbl17
                this.tokenStream.nextToken();
                var4_9 = Optional.of(new JcyoConstant(new JcyoBoolean(true)));
                v1 /* !! */  = var4_9;
                break;
lbl17:
                // 1 sources

                if (keyword == JavaKeyword.FALSE) {
                    this.tokenStream.nextToken();
                    var4_10 = Optional.of(new JcyoConstant(new JcyoBoolean(false)));
                    v1 /* !! */  = var4_10;
                    break;
                }
                var4_11 = Optional.empty();
                v1 /* !! */  = var4_11;
                break;
            }
            case 1: {
                var7_7 = (NumberLiteralToken)var2_2;
                raw = var9_15 = var7_7.raw();
                try {
                    this.tokenStream.nextToken();
                    var4_12 = Optional.of(new JcyoConstant(new JcyoNumber(Double.parseDouble(raw))));
                    v1 /* !! */  = var4_12;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new JcyoParseException("Unexpected number literal " + raw);
                }
            }
            case 2: {
                var9_17 = (StringLiteralToken)var2_2;
                raw = var11_19 = var9_17.raw();
                this.tokenStream.nextToken();
                sb = new StringBuilder();
                end = raw.length() - 1;
                for (i = 1; i < end; ++i) {
                    c = raw.charAt(i);
                    if (c == '\\') {
                        c = raw.charAt(++i);
                        switch (c) {
                            case 'n': {
                                v2 = '\n';
                                break;
                            }
                            case 'r': {
                                v2 = '\r';
                                break;
                            }
                            case 't': {
                                v2 = '\t';
                                break;
                            }
                            case '\"': {
                                v2 = '\"';
                                break;
                            }
                            case '\\': {
                                v2 = '\\';
                                break;
                            }
                            default: {
                                throw new JcyoParseException("Unexpected escape sequence \\" + c);
                            }
                        }
                        sb.append(v2);
                        continue;
                    }
                    sb.append(c);
                }
                var4_13 = Optional.of(new JcyoConstant(new JcyoString(sb.toString())));
                v1 /* !! */  = var4_13;
                break;
            }
            default: {
                v1 /* !! */  = var4_14 = Optional.empty();
            }
        }
        return v1 /* !! */ ;
        catch (Throwable var2_3) {
            throw new MatchException(var2_3.toString(), var2_3);
        }
    }

    private Optional<JcyoVariableReference> tryParseVariableReference() {
        Token token = this.tokenStream.peekToken();
        Objects.requireNonNull(token);
        Token token2 = token;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierToken.class, JavaKeywordToken.class}, (Token)token2, n)) {
            case 0 -> {
                IdentifierToken identifierToken = (IdentifierToken)token2;
                this.tokenStream.nextToken();
                yield Optional.of(new JcyoVariableReference(identifierToken.identifier()));
            }
            case 1 -> {
                JavaKeywordToken keywordToken = (JavaKeywordToken)token2;
                this.tokenStream.peekToken();
                yield Optional.of(new JcyoVariableReference(keywordToken.raw()));
            }
            default -> Optional.empty();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<JcyoBinaryOperator.Type> tryParseBinaryOperator() {
        int codepoint;
        Token token = this.tokenStream.peekToken();
        if (!(token instanceof OperatorToken)) return Optional.empty();
        OperatorToken operatorToken = (OperatorToken)token;
        try {
            int n;
            int n2 = n = operatorToken.codepoint();
            if (!true) return Optional.empty();
            codepoint = n;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        switch (codepoint) {
            case 43: {
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.PLUS);
            }
            case 45: {
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.MINUS);
            }
            case 42: {
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.MULTIPLY);
            }
            case 47: {
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.DIVIDE);
            }
            case 38: {
                int codepoint2;
                int n;
                this.tokenStream.nextToken();
                Token token2 = this.tokenStream.peekToken();
                if (!(token2 instanceof OperatorToken)) throw new JcyoParseException("And operator requires double ampersand, got: " + String.valueOf(this.tokenStream.peekToken()));
                token = (OperatorToken)token2;
                int n3 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 38) throw new JcyoParseException("And operator requires double ampersand, got: " + String.valueOf(this.tokenStream.peekToken()));
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.AND);
            }
            case 124: {
                int n;
                int codepoint2;
                this.tokenStream.nextToken();
                Token token3 = this.tokenStream.peekToken();
                if (!(token3 instanceof OperatorToken)) throw new JcyoParseException("Or operator requires double pipe, got: " + String.valueOf(this.tokenStream.peekToken()));
                token = (OperatorToken)token3;
                int n4 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 124) throw new JcyoParseException("Or operator requires double pipe, got: " + String.valueOf(this.tokenStream.peekToken()));
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.OR);
            }
            case 61: {
                int n;
                int codepoint2;
                this.tokenStream.nextToken();
                Token token4 = this.tokenStream.peekToken();
                if (!(token4 instanceof OperatorToken)) throw new JcyoParseException("Equals operator requires double equals, got: " + String.valueOf(this.tokenStream.peekToken()));
                token = (OperatorToken)token4;
                int n5 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 61) throw new JcyoParseException("Equals operator requires double equals, got: " + String.valueOf(this.tokenStream.peekToken()));
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.EQUAL);
            }
            case 33: {
                int n;
                int codepoint2;
                this.tokenStream.nextToken();
                Token token5 = this.tokenStream.peekToken();
                if (!(token5 instanceof OperatorToken)) throw new JcyoParseException("Not equals operator requires double equals, got: " + String.valueOf(this.tokenStream.peekToken()));
                token = (OperatorToken)token5;
                int n6 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 61) throw new JcyoParseException("Not equals operator requires double equals, got: " + String.valueOf(this.tokenStream.peekToken()));
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.NOT_EQUAL);
            }
            case 60: {
                int n;
                int codepoint2;
                this.tokenStream.nextToken();
                Token token6 = this.tokenStream.peekToken();
                if (!(token6 instanceof OperatorToken)) return Optional.of(JcyoBinaryOperator.Type.LESS_THAN);
                token = (OperatorToken)token6;
                int n7 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 61) return Optional.of(JcyoBinaryOperator.Type.LESS_THAN);
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.LESS_THAN_OR_EQUAL);
            }
            case 62: {
                int n;
                int codepoint2;
                this.tokenStream.nextToken();
                Token token7 = this.tokenStream.peekToken();
                if (!(token7 instanceof OperatorToken)) return Optional.of(JcyoBinaryOperator.Type.GREATER_THAN);
                token = (OperatorToken)token7;
                int n8 = n = ((OperatorToken)token).codepoint();
                if (!true || (codepoint2 = n) != 61) return Optional.of(JcyoBinaryOperator.Type.GREATER_THAN);
                this.tokenStream.nextToken();
                return Optional.of(JcyoBinaryOperator.Type.GREATER_THAN_OR_EQUAL);
            }
        }
        return Optional.empty();
    }

    private void chompWhitespace() {
        while (this.tokenStream.peekToken() instanceof WhitespaceToken) {
            this.tokenStream.nextToken();
        }
    }

    private JcyoExpression stitchBinaryOperators(List<JcyoExpression> values, List<JcyoBinaryOperator.Type> operatorTypes) {
        if (values.size() == 1) {
            return values.getFirst();
        }
        Integer[] operatorIndices = new Integer[operatorTypes.size()];
        for (int i = 0; i < operatorTypes.size(); ++i) {
            operatorIndices[i] = i;
        }
        Arrays.sort(operatorIndices, Comparator.comparingInt(index -> this.getBinaryOperatorPriority((JcyoBinaryOperator.Type)((Object)((Object)operatorTypes.get((int)index))))));
        @Nullable JcyoExpression[] valuesArray = (JcyoExpression[])values.toArray(JcyoExpression[]::new);
        for (Integer operatorIndex : operatorIndices) {
            int leftValueIndex = this.findNonNullIndexLeft(valuesArray, operatorIndex);
            JcyoExpression leftValue = valuesArray[leftValueIndex];
            int rightValueIndex = operatorIndex + 1;
            JcyoExpression rightValue = valuesArray[rightValueIndex];
            assert (leftValue != null);
            assert (rightValue != null);
            valuesArray[rightValueIndex] = null;
            valuesArray[leftValueIndex] = new JcyoBinaryOperator(operatorTypes.get(operatorIndex), leftValue, rightValue);
        }
        assert (valuesArray[0] != null);
        return valuesArray[0];
    }

    private int getBinaryOperatorPriority(JcyoBinaryOperator.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case JcyoBinaryOperator.Type.AND, JcyoBinaryOperator.Type.OR -> 5;
            case JcyoBinaryOperator.Type.LESS_THAN, JcyoBinaryOperator.Type.LESS_THAN_OR_EQUAL, JcyoBinaryOperator.Type.GREATER_THAN, JcyoBinaryOperator.Type.GREATER_THAN_OR_EQUAL -> 4;
            case JcyoBinaryOperator.Type.EQUAL, JcyoBinaryOperator.Type.NOT_EQUAL -> 3;
            case JcyoBinaryOperator.Type.PLUS, JcyoBinaryOperator.Type.MINUS -> 2;
            case JcyoBinaryOperator.Type.MULTIPLY, JcyoBinaryOperator.Type.DIVIDE -> 1;
        };
    }

    private <T> int findNonNullIndexLeft(@Nullable T[] array, int startIndex) {
        for (int i = startIndex; i >= 0; --i) {
            if (array[i] == null) continue;
            return i;
        }
        throw new IllegalStateException("No non-null element found");
    }

    @Generated
    public ExpressionParser(PeekableTokenStream tokenStream) {
        this.tokenStream = tokenStream;
    }
}

