/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.expression;

import de.siphalor.jcyo.core.api.JcyoVariables;
import de.siphalor.jcyo.core.api.value.JcyoBoolean;
import de.siphalor.jcyo.core.api.value.JcyoNumber;
import de.siphalor.jcyo.core.api.value.JcyoString;
import de.siphalor.jcyo.core.api.value.JcyoUndefined;
import de.siphalor.jcyo.core.api.value.JcyoValue;
import de.siphalor.jcyo.core.impl.expression.JcyoBinaryOperator;
import de.siphalor.jcyo.core.impl.expression.JcyoConstant;
import de.siphalor.jcyo.core.impl.expression.JcyoExpression;
import de.siphalor.jcyo.core.impl.expression.JcyoExpressionEvaluationException;
import de.siphalor.jcyo.core.impl.expression.JcyoUnaryOperator;
import de.siphalor.jcyo.core.impl.expression.JcyoVariableReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class JcyoExpressionEvaluator {
    private final JcyoVariables variables;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JcyoValue evaluate(JcyoExpression expression) throws JcyoExpressionEvaluationException {
        Object right;
        Object left;
        JcyoBinaryOperator.Type type;
        JcyoValue jcyoValue;
        JcyoExpression jcyoExpression = expression;
        Objects.requireNonNull(jcyoExpression);
        JcyoExpression jcyoExpression2 = jcyoExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JcyoConstant.class, JcyoVariableReference.class, JcyoUnaryOperator.class, JcyoBinaryOperator.class}, (JcyoExpression)jcyoExpression2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JcyoConstant jcyoConstant = (JcyoConstant)jcyoExpression2;
                try {
                    JcyoValue jcyoValue2;
                    JcyoValue value;
                    jcyoValue = value = (jcyoValue2 = jcyoConstant.value());
                    return jcyoValue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                JcyoVariableReference jcyoVariableReference = (JcyoVariableReference)jcyoExpression2;
                {
                    String string;
                    String name = string = jcyoVariableReference.name();
                    jcyoValue = this.variables.get(name).orElse(new JcyoUndefined(name));
                    return jcyoValue;
                }
            }
            case 2: {
                Object inner;
                JcyoUnaryOperator.Type type2;
                JcyoUnaryOperator jcyoUnaryOperator = (JcyoUnaryOperator)jcyoExpression2;
                {
                    Object object;
                    type2 = object = jcyoUnaryOperator.type();
                    inner = object = jcyoUnaryOperator.expression();
                }
                switch (type2) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case MINUS: {
                        jcyoValue = new JcyoNumber(-this.assertNumber(this.evaluate((JcyoExpression)inner), "in unary minus").value());
                        return jcyoValue;
                    }
                    case NOT: 
                }
                jcyoValue = new JcyoBoolean(!this.evaluate((JcyoExpression)inner).truthy());
                return jcyoValue;
            }
            case 3: 
        }
        JcyoBinaryOperator jcyoBinaryOperator = (JcyoBinaryOperator)jcyoExpression2;
        {
            Object object;
            type = object = jcyoBinaryOperator.type();
            left = object = jcyoBinaryOperator.left();
            right = object = jcyoBinaryOperator.right();
        }
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case PLUS: {
                JcyoValue leftValue = this.evaluate((JcyoExpression)left);
                JcyoValue rightValue = this.evaluate((JcyoExpression)right);
                if (!(leftValue instanceof JcyoString) && !(rightValue instanceof JcyoString)) {
                    jcyoValue = new JcyoNumber(this.assertNumber(leftValue, "on left side of plus").value() + this.assertNumber(rightValue, "on right side of plus").value());
                    return jcyoValue;
                }
                jcyoValue = new JcyoString(this.valueToString(leftValue) + this.valueToString(rightValue));
                return jcyoValue;
            }
            case MINUS: {
                jcyoValue = new JcyoNumber(this.assertNumber(this.evaluate((JcyoExpression)left), "on left side of minus").value() - this.assertNumber(this.evaluate((JcyoExpression)right), "on right side of minus").value());
                return jcyoValue;
            }
            case MULTIPLY: {
                jcyoValue = new JcyoNumber(this.assertNumber(this.evaluate((JcyoExpression)left), "on left side of multiply").value() * this.assertNumber(this.evaluate((JcyoExpression)right), "on right side of multiply").value());
                return jcyoValue;
            }
            case DIVIDE: {
                jcyoValue = new JcyoNumber(this.assertNumber(this.evaluate((JcyoExpression)left), "on left side of divide").value() / this.assertNumber(this.evaluate((JcyoExpression)right), "on right side of divide").value());
                return jcyoValue;
            }
            case AND: {
                jcyoValue = new JcyoBoolean(this.evaluate((JcyoExpression)left).truthy() && this.evaluate((JcyoExpression)right).truthy());
                return jcyoValue;
            }
            case OR: {
                jcyoValue = new JcyoBoolean(this.evaluate((JcyoExpression)left).truthy() || this.evaluate((JcyoExpression)right).truthy());
                return jcyoValue;
            }
            case EQUAL: {
                jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) == 0);
                return jcyoValue;
            }
            case NOT_EQUAL: {
                jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) != 0);
                return jcyoValue;
            }
            case GREATER_THAN: {
                jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) > 0);
                return jcyoValue;
            }
            case GREATER_THAN_OR_EQUAL: {
                jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) >= 0);
                return jcyoValue;
            }
            case LESS_THAN: {
                jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) < 0);
                return jcyoValue;
            }
            case LESS_THAN_OR_EQUAL: 
        }
        jcyoValue = new JcyoBoolean(this.compare(this.evaluate((JcyoExpression)left), this.evaluate((JcyoExpression)right)) <= 0);
        return jcyoValue;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String valueToString(JcyoValue value) {
        JcyoValue jcyoValue = value;
        Objects.requireNonNull(jcyoValue);
        JcyoValue jcyoValue2 = jcyoValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JcyoString.class, JcyoNumber.class, JcyoBoolean.class, JcyoUndefined.class}, (JcyoValue)jcyoValue2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object object;
                Object object2;
                JcyoString jcyoString = (JcyoString)jcyoValue2;
                try {
                    Object string;
                    object = string = (object2 = jcyoString.value());
                    return object;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                double d;
                Object object2 = (JcyoNumber)jcyoValue2;
                {
                    double d2 = d = ((JcyoNumber)object2).value();
                }
                double number = d;
                Object object = Double.toString(number);
                return object;
            }
            case 2: {
                boolean bl;
                JcyoBoolean jcyoBoolean = (JcyoBoolean)jcyoValue2;
                {
                    boolean bl2 = bl = jcyoBoolean.value();
                }
                boolean bool = bl;
                Object object = Boolean.toString(bool);
                return object;
            }
            case 3: 
        }
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int compare(JcyoValue left, JcyoValue right) throws JcyoExpressionEvaluationException {
        Integer cmp;
        if (left instanceof JcyoString) {
            String leftString;
            String string;
            JcyoString jcyoString = (JcyoString)left;
            try {
                leftString = string = jcyoString.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (right instanceof JcyoString) {
                JcyoString jcyoString2 = (JcyoString)right;
                {
                    String rightString = string = jcyoString2.value();
                    return leftString.compareTo(rightString);
                }
            }
        }
        if ((cmp = this.tryCompareAsNumbers(left, right)) != null) {
            return cmp;
        }
        throw new JcyoExpressionEvaluationException("Cannot compare " + String.valueOf(left) + " and " + String.valueOf(right) + ": Both must be numbers or strings");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable Integer tryCompareAsNumbers(JcyoValue left, JcyoValue right) throws JcyoExpressionEvaluationException {
        double value;
        double d;
        double d2;
        JcyoNumber jcyoNumber;
        Double leftNumber = null;
        Double rightNumber = null;
        if (left instanceof JcyoNumber) {
            jcyoNumber = (JcyoNumber)left;
            try {
                d = d2 = jcyoNumber.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            value = d2;
            leftNumber = value;
        }
        if (right instanceof JcyoNumber) {
            jcyoNumber = (JcyoNumber)right;
            {
                d = d2 = jcyoNumber.value();
            }
            value = d2;
            rightNumber = value;
        }
        if (leftNumber != null) {
            if (rightNumber != null) {
                return Double.compare(leftNumber, rightNumber);
            }
            rightNumber = this.tryParseAsDouble(this.valueToString(right));
            if (rightNumber == null) return null;
            return Double.compare(leftNumber, rightNumber);
        } else {
            if (rightNumber == null || (leftNumber = this.tryParseAsDouble(this.valueToString(left))) == null) return null;
            return Double.compare(leftNumber, rightNumber);
        }
    }

    private @Nullable Double tryParseAsDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private JcyoNumber assertNumber(JcyoValue value, String context) throws JcyoExpressionEvaluationException {
        if (value instanceof JcyoNumber) {
            JcyoNumber number = (JcyoNumber)value;
            return number;
        }
        throw new JcyoExpressionEvaluationException("Expected number " + context + ", got: " + String.valueOf(value));
    }

    @Generated
    public JcyoExpressionEvaluator(JcyoVariables variables) {
        this.variables = variables;
    }
}

