/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.transform;

import de.siphalor.jcyo.core.api.JcyoVariables;
import de.siphalor.jcyo.core.impl.CommentStyle;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.directive.DirectiveParser;
import de.siphalor.jcyo.core.impl.directive.ElifDirective;
import de.siphalor.jcyo.core.impl.directive.ElseDirective;
import de.siphalor.jcyo.core.impl.directive.IfDirective;
import de.siphalor.jcyo.core.impl.directive.JcyoDirective;
import de.siphalor.jcyo.core.impl.expression.JcyoExpression;
import de.siphalor.jcyo.core.impl.expression.JcyoExpressionEvaluationException;
import de.siphalor.jcyo.core.impl.expression.JcyoExpressionEvaluator;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.stream.TokenBuffer;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.JcyoDirectiveStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionEndToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionStartToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.RepresentableToken;
import de.siphalor.jcyo.core.impl.token.Token;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class JcyoDirectiveApplier {
    private final JcyoExpressionEvaluator expressionEvaluator;

    public JcyoDirectiveApplier(JcyoVariables variables) {
        this.expressionEvaluator = new JcyoExpressionEvaluator(variables);
    }

    public TokenStream apply(TokenStream stream) {
        return new StreamTransformer(PeekableTokenStream.from(stream));
    }

    private class StreamTransformer
    implements TokenStream {
        private final PeekableTokenStream input;
        private final TokenBuffer buffer = new TokenBuffer();
        private final Deque<StackEntry> stack = new ArrayDeque<StackEntry>();
        private int indentLength;
        private final List<String> indentBuilder = new ArrayList<String>();

        @Override
        public Token nextToken() {
            block6: while (true) {
                Token token;
                if (!this.buffer.isEmpty()) {
                    return this.buffer.nextToken();
                }
                Objects.requireNonNull(this.input.peekToken());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EofToken.class, JcyoDirectiveStartToken.class, LineBreakToken.class, RepresentableToken.class, Token.class}, (Token)token, n)) {
                    case 0: {
                        return this.input.nextToken();
                    }
                    case 1: {
                        JcyoDirectiveStartToken startToken = (JcyoDirectiveStartToken)token;
                        DirectiveParser parser = new DirectiveParser(this.buffer.copying(this.input));
                        JcyoDirective directive = parser.nextDirective();
                        this.evaluateDirective(startToken, directive);
                        continue block6;
                    }
                    case 2: {
                        this.clearIndent();
                        return this.input.nextToken();
                    }
                    case 3: {
                        RepresentableToken representableToken = (RepresentableToken)token;
                        this.pushIndent(representableToken.raw());
                        return this.input.nextToken();
                    }
                }
                break;
            }
            return this.input.nextToken();
        }

        private void pushIndent(String indent) {
            this.indentBuilder.add(indent);
            this.indentLength += indent.length();
        }

        private void clearIndent() {
            this.indentBuilder.clear();
            this.indentLength = 0;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void evaluateDirective(JcyoDirectiveStartToken startToken, JcyoDirective directive) {
            JcyoDirective jcyoDirective = directive;
            Objects.requireNonNull(jcyoDirective);
            JcyoDirective jcyoDirective2 = jcyoDirective;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IfDirective.class, ElifDirective.class, ElseDirective.class}, (JcyoDirective)jcyoDirective2, n)) {
                case 0: {
                    JcyoExpression condition;
                    IfDirective ifDirective = (IfDirective)jcyoDirective2;
                    try {
                        JcyoExpression jcyoExpression;
                        condition = jcyoExpression = ifDirective.condition();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    try {
                        boolean enabled = this.isCurrentStackEntryEnabled() && JcyoDirectiveApplier.this.expressionEvaluator.evaluate(condition).truthy();
                        this.pushStackEntry(new StackEntry(directive, enabled, startToken.commentStyle()));
                        return;
                    }
                    catch (JcyoExpressionEvaluationException e) {
                        throw new DirectiveApplicationException("Failed to evaluate if condition", e);
                    }
                }
                case 1: {
                    JcyoExpression condition;
                    ElifDirective elifDirective = (ElifDirective)jcyoDirective2;
                    {
                        JcyoExpression jcyoExpression;
                        condition = jcyoExpression = elifDirective.condition();
                    }
                    try {
                        StackEntry oldEntry = this.popStackEntry();
                        this.validateEndDirective(startToken, directive, oldEntry);
                        boolean enabled = this.isCurrentStackEntryEnabled() && !oldEntry.encounteredEnabledBranch() && JcyoDirectiveApplier.this.expressionEvaluator.evaluate(condition).truthy();
                        StackEntry newEntry = new StackEntry(directive, enabled, startToken.commentStyle());
                        newEntry.encounteredEnabledBranch(oldEntry.encounteredEnabledBranch() || enabled);
                        this.pushStackEntry(newEntry);
                        return;
                    }
                    catch (JcyoExpressionEvaluationException e) {
                        throw new DirectiveApplicationException("Failed to evaluate elif condition", e);
                    }
                }
                case 2: {
                    StackEntry oldEntry = this.popStackEntry();
                    this.validateEndDirective(startToken, directive, oldEntry);
                    boolean enabled = this.isCurrentStackEntryEnabled() && !oldEntry.encounteredEnabledBranch();
                    StackEntry newEntry = new StackEntry(directive, enabled, startToken.commentStyle());
                    newEntry.encounteredEnabledBranch(oldEntry.encounteredEnabledBranch() || enabled);
                    this.pushStackEntry(newEntry);
                    return;
                }
            }
            if (directive.isBlockEnd()) {
                StackEntry entry = this.popStackEntry();
                this.validateEndDirective(startToken, directive, entry);
            }
            if (!directive.isBlockBegin()) return;
            this.currentStackEntry().ifPresentOrElse(stackEntry -> this.pushStackEntry(new StackEntry(directive, stackEntry.enabled(), stackEntry.commentStyle())), () -> this.pushStackEntry(new StackEntry(directive, false, startToken.commentStyle())));
        }

        private boolean isCurrentStackEntryEnabled() {
            return this.currentStackEntry().map(StackEntry::enabled).orElse(true);
        }

        private void pushStackEntry(StackEntry entry) {
            if (!entry.enabled() && this.isCurrentStackEntryEnabled()) {
                this.buffer.pushToken(new JcyoDisabledRegionStartToken(entry.commentStyle(), entry.commentStyle() == CommentStyle.LINE ? this.concatIndent() : ""));
            }
            this.stack.push(entry);
        }

        private StackEntry popStackEntry() {
            StackEntry innerEntry = this.stack.pop();
            if (!innerEntry.enabled() && this.isCurrentStackEntryEnabled()) {
                this.buffer.pushFrontToken(new JcyoDisabledRegionEndToken());
            }
            return innerEntry;
        }

        private String concatIndent() {
            StringBuilder sb = new StringBuilder(this.indentLength);
            for (String indent : this.indentBuilder) {
                sb.append(indent);
            }
            return sb.toString();
        }

        private void validateEndDirective(JcyoDirectiveStartToken startToken, JcyoDirective directive, StackEntry entry) {
            if (!directive.ends(entry.startDirective())) {
                throw new JcyoParseException("Incorrect end directive for " + String.valueOf(entry.startDirective()) + ": " + String.valueOf(directive));
            }
            if (entry.commentStyle() != startToken.commentStyle()) {
                throw new JcyoParseException("You must not mix comment styles for start and end of block directives");
            }
        }

        private Optional<StackEntry> currentStackEntry() {
            return Optional.ofNullable(this.stack.peek());
        }

        @Generated
        public StreamTransformer(PeekableTokenStream input) {
            this.input = input;
        }
    }

    private static class DirectiveApplicationException
    extends RuntimeException {
        public DirectiveApplicationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class StackEntry {
        private final JcyoDirective startDirective;
        private final boolean enabled;
        private final CommentStyle commentStyle;
        private boolean encounteredEnabledBranch;

        public StackEntry(JcyoDirective startDirective, boolean enabled, CommentStyle commentStyle) {
            this.startDirective = startDirective;
            this.enabled = enabled;
            this.commentStyle = commentStyle;
            this.encounteredEnabledBranch = enabled;
        }

        @Generated
        public JcyoDirective startDirective() {
            return this.startDirective;
        }

        @Generated
        public boolean enabled() {
            return this.enabled;
        }

        @Generated
        public CommentStyle commentStyle() {
            return this.commentStyle;
        }

        @Generated
        public boolean encounteredEnabledBranch() {
            return this.encounteredEnabledBranch;
        }

        @Generated
        public StackEntry encounteredEnabledBranch(boolean encounteredEnabledBranch) {
            this.encounteredEnabledBranch = encounteredEnabledBranch;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StackEntry)) {
                return false;
            }
            StackEntry other = (StackEntry)o;
            if (this.enabled() != other.enabled()) {
                return false;
            }
            if (this.encounteredEnabledBranch() != other.encounteredEnabledBranch()) {
                return false;
            }
            JcyoDirective this$startDirective = this.startDirective();
            JcyoDirective other$startDirective = other.startDirective();
            if (this$startDirective == null ? other$startDirective != null : !this$startDirective.equals(other$startDirective)) {
                return false;
            }
            CommentStyle this$commentStyle = this.commentStyle();
            CommentStyle other$commentStyle = other.commentStyle();
            return !(this$commentStyle == null ? other$commentStyle != null : !((Object)((Object)this$commentStyle)).equals((Object)other$commentStyle));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled() ? 79 : 97);
            result = result * 59 + (this.encounteredEnabledBranch() ? 79 : 97);
            JcyoDirective $startDirective = this.startDirective();
            result = result * 59 + ($startDirective == null ? 43 : $startDirective.hashCode());
            CommentStyle $commentStyle = this.commentStyle();
            result = result * 59 + ($commentStyle == null ? 43 : ((Object)((Object)$commentStyle)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JcyoDirectiveApplier.StackEntry(startDirective=" + String.valueOf(this.startDirective()) + ", enabled=" + this.enabled() + ", commentStyle=" + String.valueOf((Object)this.commentStyle()) + ", encounteredEnabledBranch=" + this.encounteredEnabledBranch() + ")";
        }
    }
}

