/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.transform;

import de.siphalor.jcyo.core.impl.CommentStyle;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.stream.TokenBuffer;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.IdentifierToken;
import de.siphalor.jcyo.core.impl.token.JavaKeyword;
import de.siphalor.jcyo.core.impl.token.JavaKeywordToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionEndToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledRegionStartToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.OperatorToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.transform.JcyoCleaner;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class UnusedImportDisabler {
    public TokenStream apply(TokenStream tokenStream) {
        TokenBuffer copy = new TokenBuffer();
        Set<String> usedIdentifiers = this.collectUsedIdentifiers(copy.copying(tokenStream));
        return this.disableUnusedImports(copy, usedIdentifiers);
    }

    private Set<String> collectUsedIdentifiers(TokenStream tokenStream) {
        tokenStream = new JcyoCleaner(tokenStream);
        HashSet<String> identifiers = new HashSet<String>();
        boolean afterDot = false;
        block6: while (true) {
            Token token;
            Objects.requireNonNull(tokenStream.nextToken());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EofToken.class, JavaKeywordToken.class, OperatorToken.class, IdentifierToken.class}, (Token)token, n)) {
                case 0: {
                    return identifiers;
                }
                case 1: {
                    JavaKeywordToken keywordToken = (JavaKeywordToken)token;
                    if (keywordToken.keyword() == JavaKeyword.PACKAGE || keywordToken.keyword() == JavaKeyword.IMPORT) {
                        this.chompToSemicolon(tokenStream);
                    }
                    afterDot = false;
                    continue block6;
                }
                case 2: {
                    OperatorToken operatorToken = (OperatorToken)token;
                    afterDot = operatorToken.codepoint() == 46;
                    continue block6;
                }
                case 3: {
                    IdentifierToken identifierToken = (IdentifierToken)token;
                    if (afterDot) continue block6;
                    identifiers.add(identifierToken.identifier());
                    continue block6;
                }
            }
            afterDot = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void chompToSemicolon(TokenStream tokenStream) {
        while (true) {
            int n;
            Token token;
            if ((token = tokenStream.nextToken()) instanceof EofToken) {
                return;
            }
            if (!(token instanceof OperatorToken)) continue;
            OperatorToken operatorToken = (OperatorToken)token;
            try {
                int n2 = n = operatorToken.codepoint();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int codepoint = n;
            if (codepoint == 59) break;
        }
    }

    private TokenStream disableUnusedImports(TokenStream source, final Set<String> usedIdentifiers) {
        final PeekableTokenStream peekableSource = PeekableTokenStream.from(source);
        return new TokenStream(){
            private final TokenBuffer buffer = new TokenBuffer();
            private boolean inDisabledRegion;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Token nextToken() {
                Token token;
                if (!this.buffer.isEmpty()) {
                    return this.buffer.nextToken();
                }
                Token token2 = token = peekableSource.nextToken();
                Objects.requireNonNull(token2);
                Token token3 = token2;
                int n = 0;
                block9: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JcyoDisabledRegionStartToken.class, JcyoDisabledRegionStartToken.class, JcyoDisabledRegionEndToken.class, JcyoDisabledRegionEndToken.class, JavaKeywordToken.class}, (Token)token3, n)) {
                        case 0: {
                            JcyoDisabledRegionStartToken startToken = (JcyoDisabledRegionStartToken)token3;
                            if (this.inDisabledRegion) throw new IllegalStateException("Encountered disabled region start token " + String.valueOf(startToken) + "while already in disabled region");
                            n = 1;
                            continue block9;
                        }
                        case 1: {
                            this.inDisabledRegion = true;
                            return token;
                        }
                        case 2: {
                            JcyoDisabledRegionEndToken endToken = (JcyoDisabledRegionEndToken)token3;
                            if (!this.inDisabledRegion) throw new IllegalStateException("Encountered disabled region end token " + String.valueOf(endToken) + "while not in disabled region");
                            n = 3;
                            continue block9;
                        }
                        case 3: {
                            this.inDisabledRegion = false;
                            return token;
                        }
                        case 4: {
                            JavaKeywordToken javaKeywordToken = (JavaKeywordToken)token3;
                            try {
                                JavaKeyword javaKeyword;
                                JavaKeyword keyword = javaKeyword = javaKeywordToken.keyword();
                                if (this.inDisabledRegion || keyword != JavaKeyword.IMPORT) {
                                    n = 5;
                                    continue block9;
                                }
                                this.buffer.pushToken(token);
                                boolean used = this.parseImportAndDetermineIfUsed();
                                if (used) {
                                    return this.buffer.nextToken();
                                }
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            if (peekableSource.peekToken() instanceof LineBreakToken) {
                                this.buffer.pushToken(peekableSource.nextToken());
                                this.buffer.pushToken(new JcyoDisabledRegionEndToken());
                                return new JcyoDisabledRegionStartToken(CommentStyle.LINE, "");
                            }
                            this.buffer.pushToken(new JcyoDisabledRegionEndToken());
                            return new JcyoDisabledRegionStartToken(CommentStyle.FLEX, "");
                        }
                    }
                    break;
                }
                return token;
            }

            private boolean parseImportAndDetermineIfUsed() {
                return this.buffer.copying(peekableSource).stream().takeWhile(t -> {
                    if (!(t instanceof OperatorToken)) return true;
                    OperatorToken $b$0 = (OperatorToken)t;
                    try {
                        int patt1$temp;
                        int tmp0$ = patt1$temp = $b$0.codepoint();
                        if (!true) return true;
                        int codepoint = patt1$temp;
                        if (codepoint == 46) return true;
                        if (codepoint != 42) return false;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    return true;
                }).map(t -> {
                    Token token = t;
                    Objects.requireNonNull(token);
                    Token selector3$temp = token;
                    int index$4 = 0;
                    block9: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierToken.class, JavaKeywordToken.class, OperatorToken.class}, (Token)selector3$temp, index$4)) {
                            case 0: {
                                String string;
                                IdentifierToken $b$0 = (IdentifierToken)selector3$temp;
                                try {
                                    String patt5$temp;
                                    String identifier;
                                    string = identifier = (patt5$temp = $b$0.identifier());
                                    return string;
                                }
                                catch (Throwable throwable) {
                                    throw new MatchException(throwable.toString(), throwable);
                                }
                            }
                            case 1: {
                                JavaKeyword kw;
                                JavaKeywordToken $b$1 = (JavaKeywordToken)selector3$temp;
                                {
                                    JavaKeyword patt6$temp;
                                    kw = patt6$temp = $b$1.keyword();
                                }
                                String string = kw.name();
                                return string;
                            }
                            case 2: {
                                int patt7$temp;
                                String string;
                                OperatorToken $b$2 = (OperatorToken)selector3$temp;
                                {
                                    int tmp0$ = patt7$temp = $b$2.codepoint();
                                }
                                int codepoint = patt7$temp;
                                if (codepoint == 42) {
                                    string = Character.toString((char)codepoint);
                                    return string;
                                }
                                index$4 = 3;
                                continue block9;
                            }
                        }
                        break;
                    }
                    return null;
                }).filter(Objects::nonNull).reduce((string, second) -> second).map(t -> t.equals("*") || usedIdentifiers.contains(t)).orElse(false);
            }
        };
    }

    @Generated
    public UnusedImportDisabler() {
    }
}

