/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.directive;

import de.siphalor.jcyo.core.impl.CommentStyle;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.directive.ElifDirective;
import de.siphalor.jcyo.core.impl.directive.ElseDirective;
import de.siphalor.jcyo.core.impl.directive.EndDirective;
import de.siphalor.jcyo.core.impl.directive.GeneratedDirective;
import de.siphalor.jcyo.core.impl.directive.IfDirective;
import de.siphalor.jcyo.core.impl.directive.JcyoDirective;
import de.siphalor.jcyo.core.impl.expression.ExpressionParser;
import de.siphalor.jcyo.core.impl.expression.JcyoExpression;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.token.IdentifierToken;
import de.siphalor.jcyo.core.impl.token.JavaKeyword;
import de.siphalor.jcyo.core.impl.token.JavaKeywordToken;
import de.siphalor.jcyo.core.impl.token.JcyoDirectiveStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoEndToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.OperatorToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.token.WhitespaceToken;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class DirectiveParser {
    private final PeekableTokenStream tokenStream;
    private final ExpressionParser expressionParser;
    private @Nullable CommentStyle commentStyle;

    public DirectiveParser(PeekableTokenStream tokenStream) {
        this.tokenStream = tokenStream;
        this.expressionParser = new ExpressionParser(tokenStream);
    }

    public JcyoDirective nextDirective() {
        String name;
        Token token = this.tokenStream.nextToken();
        if (!(token instanceof JcyoDirectiveStartToken)) {
            throw new IllegalArgumentException("Expected a directive start token but got " + String.valueOf(token));
        }
        JcyoDirectiveStartToken startToken = (JcyoDirectiveStartToken)token;
        this.commentStyle = startToken.commentStyle();
        this.chompWhitespace();
        Token nameToken = this.tokenStream.nextToken();
        return switch (name = this.getIdentifier(nameToken).orElseThrow(() -> new JcyoParseException("Expected a directive identifier token but got " + String.valueOf(nameToken)))) {
            case "end" -> this.parseEndDirective();
            case "generated" -> this.parseGeneratedDirective();
            case "if" -> this.parseIfDirective();
            case "elif" -> this.parseElifDirective();
            case "else" -> this.parseElseDirective();
            default -> throw new JcyoParseException("Unknown directive " + name);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EndDirective parseEndDirective() {
        this.chompWhitespace();
        Token token = this.tokenStream.peekToken();
        if (token instanceof OperatorToken) {
            int n;
            OperatorToken operatorToken = (OperatorToken)token;
            try {
                int n2 = n = operatorToken.codepoint();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int codepoint = n;
            if (codepoint == 58) {
                this.tokenStream.nextToken();
                this.chompWhitespace();
                Token nameToken = this.tokenStream.nextToken();
                String name = this.getIdentifier(nameToken).orElseThrow(() -> new JcyoParseException("Expected a directive identifier as end directive target but got " + String.valueOf(nameToken)));
                this.chompDirectiveEnd();
                return new EndDirective(name);
            }
        }
        this.chompDirectiveEnd();
        return new EndDirective(null);
    }

    private GeneratedDirective parseGeneratedDirective() {
        this.chompDirectiveEnd();
        return new GeneratedDirective();
    }

    private IfDirective parseIfDirective() {
        this.chompWhitespace();
        JcyoExpression condition = this.expressionParser.nextExpression();
        this.chompDirectiveEnd();
        return new IfDirective(condition);
    }

    private ElifDirective parseElifDirective() {
        this.chompWhitespace();
        JcyoExpression condition = this.expressionParser.nextExpression();
        this.chompDirectiveEnd();
        return new ElifDirective(condition);
    }

    private ElseDirective parseElseDirective() {
        this.chompDirectiveEnd();
        return new ElseDirective();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> getIdentifier(Token token) {
        Optional<String> optional;
        Token token2 = token;
        Objects.requireNonNull(token2);
        Token token3 = token2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierToken.class, JavaKeywordToken.class}, (Token)token3, n)) {
            case 0: {
                String identifier;
                IdentifierToken identifierToken = (IdentifierToken)token3;
                try {
                    String string;
                    identifier = string = identifierToken.identifier();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                optional = Optional.of(identifier);
                return optional;
            }
            case 1: {
                JavaKeyword keyword;
                JavaKeywordToken javaKeywordToken = (JavaKeywordToken)token3;
                {
                    JavaKeyword javaKeyword;
                    keyword = javaKeyword = javaKeywordToken.keyword();
                }
                optional = Optional.of(keyword.text());
                return optional;
            }
        }
        optional = Optional.empty();
        return optional;
    }

    private void chompDirectiveEnd() {
        this.chompWhitespace();
        Token token = this.tokenStream.nextToken();
        if (this.commentStyle == CommentStyle.LINE) {
            if (!(token instanceof LineBreakToken)) {
                throw new JcyoParseException("Expected a line break after full line directive, but got: " + String.valueOf(token));
            }
        } else if (!(token instanceof JcyoEndToken)) {
            throw new JcyoParseException("Expected end of directive, but got: " + String.valueOf(token));
        }
    }

    private void chompWhitespace() {
        Token token;
        while ((token = this.tokenStream.peekToken()) instanceof WhitespaceToken || this.commentStyle == CommentStyle.FLEX && token instanceof LineBreakToken) {
            this.tokenStream.nextToken();
        }
    }

    @Generated
    public DirectiveParser(PeekableTokenStream tokenStream, ExpressionParser expressionParser) {
        this.tokenStream = tokenStream;
        this.expressionParser = expressionParser;
    }
}

