/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.transform;

import de.siphalor.jcyo.core.api.JcyoOptions;
import de.siphalor.jcyo.core.impl.JcyoHelper;
import de.siphalor.jcyo.core.impl.JcyoParseException;
import de.siphalor.jcyo.core.impl.directive.DirectiveParser;
import de.siphalor.jcyo.core.impl.directive.GeneratedDirective;
import de.siphalor.jcyo.core.impl.directive.JcyoDirective;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.stream.TokenBuffer;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.JcyoDirectiveStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoDisabledStartToken;
import de.siphalor.jcyo.core.impl.token.JcyoEndToken;
import de.siphalor.jcyo.core.impl.token.PlainJavaCommentToken;
import de.siphalor.jcyo.core.impl.token.Token;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class GeneratedAndDisabledTokenRemover
implements TokenStream {
    private final PeekableTokenStream inner;
    private final JcyoHelper jcyoHelper;
    private final TokenBuffer buffer = new TokenBuffer();
    private boolean inDisabledSection = false;

    public GeneratedAndDisabledTokenRemover(TokenStream inner, JcyoOptions options) {
        this.inner = PeekableTokenStream.from(inner);
        this.jcyoHelper = new JcyoHelper(options);
    }

    @Override
    public Token nextToken() {
        block6: while (true) {
            if (!this.buffer.isEmpty()) {
                return this.buffer.nextToken();
            }
            Token token = this.inner.peekToken();
            Objects.requireNonNull(token);
            int n = 0;
            block7: while (true) {
                Token token2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JcyoDirectiveStartToken.class, JcyoDisabledStartToken.class, JcyoEndToken.class, PlainJavaCommentToken.class}, (Token)token2, n)) {
                    case 0: {
                        DirectiveParser parser = new DirectiveParser(PeekableTokenStream.from(this.buffer.copying(this.inner)));
                        JcyoDirective directive = parser.nextDirective();
                        if (!(directive instanceof GeneratedDirective)) continue block6;
                        GeneratedDirective generatedDirective = (GeneratedDirective)directive;
                        this.chompToDirectiveEnd(generatedDirective);
                        this.buffer.clear();
                        continue block6;
                    }
                    case 1: {
                        this.inner.nextToken();
                        this.inDisabledSection = true;
                        continue block6;
                    }
                    case 2: {
                        if (!this.inDisabledSection) {
                            n = 3;
                            continue block7;
                        }
                        this.inner.nextToken();
                        this.inDisabledSection = false;
                        continue block6;
                    }
                    case 3: {
                        PlainJavaCommentToken commentToken = (PlainJavaCommentToken)token2;
                        this.inner.nextToken();
                        return this.processPlainJavaComment(commentToken);
                    }
                }
                break;
            }
            break;
        }
        return this.inner.nextToken();
    }

    private void chompToDirectiveEnd(GeneratedDirective startDirective) {
        Token token;
        while (!((token = this.inner.peekToken()) instanceof EofToken)) {
            if (token instanceof JcyoDirectiveStartToken) {
                JcyoDirective directive = new DirectiveParser(this.inner).nextDirective();
                if (!directive.ends(startDirective)) {
                    throw new JcyoParseException("Nesting directives is not allowed inside generated code");
                }
                return;
            }
            this.inner.nextToken();
        }
        return;
    }

    private PlainJavaCommentToken processPlainJavaComment(PlainJavaCommentToken token) {
        String disabledTokenForLineNoWhitespace = this.jcyoHelper.disabledForLineNoWhitespace();
        String rawComment = token.raw();
        int disabledTokenMatch = rawComment.indexOf(disabledTokenForLineNoWhitespace);
        if (disabledTokenMatch == -1) {
            return token;
        }
        StringBuilder plainCommentBuilder = new StringBuilder(rawComment.length());
        plainCommentBuilder.append(rawComment, 0, disabledTokenMatch);
        int currentPos = disabledTokenMatch;
        String disabledTokenForLine = this.jcyoHelper.disabledForLine();
        while (true) {
            currentPos = rawComment.startsWith(disabledTokenForLine, currentPos) ? (currentPos += disabledTokenForLine.length()) : (currentPos += disabledTokenForLineNoWhitespace.length());
            disabledTokenMatch = rawComment.indexOf(disabledTokenForLineNoWhitespace, currentPos);
            if (disabledTokenMatch == -1) break;
            plainCommentBuilder.append(rawComment, currentPos, disabledTokenMatch);
            currentPos = disabledTokenMatch;
        }
        plainCommentBuilder.append(rawComment, currentPos, rawComment.length());
        return new PlainJavaCommentToken(plainCommentBuilder.toString(), token.commentStyle(), token.javadoc());
    }
}

