/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.api;

import de.siphalor.jcyo.core.api.JcyoOptions;
import de.siphalor.jcyo.core.api.JcyoProcessingException;
import de.siphalor.jcyo.core.api.JcyoVariables;
import de.siphalor.jcyo.core.impl.JcyoProcessor;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

public class Jcyo {
    @Generated
    private static final Log log = LogFactory.getLog(Jcyo.class);
    private final Path baseDirectory;
    private final JcyoProcessor processor;

    private Jcyo(JcyoVariables variables, JcyoOptions options, Path baseDirectory, @Nullable Path cleanOutputDirectory) {
        this.baseDirectory = baseDirectory;
        this.processor = new JcyoProcessor(variables, options, baseDirectory, cleanOutputDirectory);
    }

    public void process(Path inputFile) throws JcyoProcessingException {
        this.processor.process(inputFile);
    }

    public void processAll() throws JcyoProcessingException {
        try {
            Files.walk(this.baseDirectory, new FileVisitOption[0]).filter(path -> {
                String fileName = path.getFileName().toString();
                return fileName.endsWith(".java") && !fileName.contains("-");
            }).forEach(path -> {
                try {
                    this.processor.process((Path)path);
                }
                catch (JcyoProcessingException e) {
                    log.error((Object)("Failed to process file: " + String.valueOf(path)), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new JcyoProcessingException("Failed to walk input directory: " + String.valueOf(this.baseDirectory), e);
        }
    }

    @Generated
    public static JcyoBuilder builder() {
        return new JcyoBuilder();
    }

    @Generated
    public static class JcyoBuilder {
        @Generated
        private JcyoVariables variables;
        @Generated
        private JcyoOptions options;
        @Generated
        private Path baseDirectory;
        @Generated
        private Path cleanOutputDirectory;

        @Generated
        JcyoBuilder() {
        }

        @Generated
        public JcyoBuilder variables(JcyoVariables variables) {
            this.variables = variables;
            return this;
        }

        @Generated
        public JcyoBuilder options(JcyoOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public JcyoBuilder baseDirectory(Path baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        @Generated
        public JcyoBuilder cleanOutputDirectory(@Nullable Path cleanOutputDirectory) {
            this.cleanOutputDirectory = cleanOutputDirectory;
            return this;
        }

        @Generated
        public Jcyo build() {
            return new Jcyo(this.variables, this.options, this.baseDirectory, this.cleanOutputDirectory);
        }

        @Generated
        public String toString() {
            return "Jcyo.JcyoBuilder(variables=" + String.valueOf(this.variables) + ", options=" + String.valueOf(this.options) + ", baseDirectory=" + String.valueOf(this.baseDirectory) + ", cleanOutputDirectory=" + String.valueOf(this.cleanOutputDirectory) + ")";
        }
    }
}

