/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.stream;

import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.Token;
import org.jspecify.annotations.Nullable;

public interface PeekableTokenStream
extends TokenStream {
    public static PeekableTokenStream from(TokenStream tokenStream) {
        return new PeekableTokenStreamImpl(tokenStream);
    }

    @Override
    public Token nextToken();

    public Token peekToken();

    public static class PeekableTokenStreamImpl
    implements PeekableTokenStream {
        private final TokenStream inner;
        private @Nullable Token peek;

        private PeekableTokenStreamImpl(TokenStream inner) {
            this.inner = inner;
        }

        @Override
        public Token nextToken() {
            if (this.peek != null) {
                Token token = this.peek;
                this.peek = null;
                return token;
            }
            return this.inner.nextToken();
        }

        @Override
        public Token peekToken() {
            if (this.peek == null) {
                this.peek = this.inner.nextToken();
            }
            return this.peek;
        }
    }
}

