/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.api.import_order;

import de.siphalor.jcyo.core.api.import_order.ImportOrderElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public class ImportOrder {
    private static final Pattern SPOTLESS_IMPORT_DELIMITER = Pattern.compile("\\|");
    private static final Pattern IMPORT_PREFIX = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*)*");
    private final List<ImportOrderElement> elements;

    public static ImportOrder fromSpotless(List<String> elements) {
        ArrayList<ImportOrderElement> mapped = new ArrayList<ImportOrderElement>(elements.size() * 2);
        for (String element : elements) {
            boolean _static;
            if (!mapped.isEmpty()) {
                mapped.add(ImportOrderElement.blankLine());
            }
            if (_static = element.startsWith("\\#")) {
                element = element.substring(2);
            }
            if (element.isEmpty()) {
                mapped.add(ImportOrderElement.rest(_static));
                continue;
            }
            SPOTLESS_IMPORT_DELIMITER.splitAsStream(element).map(part -> new ImportOrderElement.Prefix((String)part, _static)).forEachOrdered(mapped::add);
        }
        return ImportOrder.ofElements(mapped);
    }

    /*
     * Loose catch block
     */
    public static ImportOrder ofElements(List<ImportOrderElement> elements) {
        if (elements.getFirst() instanceof ImportOrderElement.BlankLine || elements.getLast() instanceof ImportOrderElement.BlankLine) {
            throw new IllegalArgumentException("Import order must not begin or end with a blank line");
        }
        Map<Boolean, Long> rests = elements.stream().filter(element -> element instanceof ImportOrderElement.Rest).collect(Collectors.groupingBy(element -> ((ImportOrderElement.Rest)element).staticImport(), Collectors.counting()));
        if (rests.getOrDefault(true, 0L) > 1L || rests.getOrDefault(false, 0L) > 1L) {
            throw new IllegalArgumentException("Import order must contain at most one rest");
        }
        for (ImportOrderElement element2 : elements) {
            String string;
            if (!(element2 instanceof ImportOrderElement.Prefix)) continue;
            ImportOrderElement.Prefix prefix = (ImportOrderElement.Prefix)element2;
            String importPrefix = string = prefix.importPrefix();
            boolean bl = prefix.staticImport();
            if (IMPORT_PREFIX.matcher(importPrefix).matches()) continue;
            throw new IllegalArgumentException("Import prefix element \"" + importPrefix + "\" isn't in correct format");
        }
        return new ImportOrder(elements);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Generated
    private ImportOrder(List<ImportOrderElement> elements) {
        this.elements = elements;
    }

    @Generated
    public List<ImportOrderElement> elements() {
        return this.elements;
    }
}

