/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.stream;

import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.Token;
import java.util.ArrayDeque;
import java.util.Deque;

public class TokenBuffer
implements TokenStream {
    private final Deque<Token> buffer = new ArrayDeque<Token>();
    private boolean eofPushed;
    private boolean eofReached;

    public void finish() {
        if (!this.eofPushed) {
            this.pushToken(EofToken.instance());
        }
    }

    public void pushToken(Token token) {
        if (this.eofPushed) {
            throw new IllegalStateException("EOF token already pushed, but got: " + String.valueOf(token));
        }
        if (token instanceof EofToken) {
            this.eofPushed = true;
        }
        this.buffer.add(token);
    }

    public void pushFrontToken(Token token) {
        if (this.eofReached) {
            throw new IllegalStateException("EOF token already reached, but got: " + String.valueOf(token));
        }
        if (token instanceof EofToken) {
            this.eofPushed = true;
            this.buffer.clear();
        }
        this.buffer.addFirst(token);
    }

    public void clear() {
        this.buffer.clear();
    }

    @Override
    public Token nextToken() {
        if (this.eofReached) {
            return EofToken.instance();
        }
        Token token = this.buffer.remove();
        if (token instanceof EofToken) {
            this.eofReached = true;
        }
        return token;
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public TokenStream copying(TokenStream other) {
        return () -> {
            Token token = other.nextToken();
            if (!this.eofPushed || !(token instanceof EofToken)) {
                this.pushToken(token);
            }
            return token;
        };
    }

    public PeekableTokenStream copying(final PeekableTokenStream other) {
        return new PeekableTokenStream(){
            final /* synthetic */ TokenBuffer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Token nextToken() {
                Token token = other.nextToken();
                if (!this.this$0.eofPushed || !(token instanceof EofToken)) {
                    this.this$0.pushToken(token);
                }
                return token;
            }

            @Override
            public Token peekToken() {
                return other.peekToken();
            }
        };
    }
}

