/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.jcyo.core.impl.transform;

import de.siphalor.jcyo.core.api.import_order.ImportOrder;
import de.siphalor.jcyo.core.api.import_order.ImportOrderElement;
import de.siphalor.jcyo.core.impl.directive.DirectiveParser;
import de.siphalor.jcyo.core.impl.directive.JcyoDirective;
import de.siphalor.jcyo.core.impl.stream.PeekableTokenStream;
import de.siphalor.jcyo.core.impl.stream.TokenBuffer;
import de.siphalor.jcyo.core.impl.stream.TokenStream;
import de.siphalor.jcyo.core.impl.token.EofToken;
import de.siphalor.jcyo.core.impl.token.IdentifierToken;
import de.siphalor.jcyo.core.impl.token.JavaKeyword;
import de.siphalor.jcyo.core.impl.token.JavaKeywordToken;
import de.siphalor.jcyo.core.impl.token.JcyoDirectiveStartToken;
import de.siphalor.jcyo.core.impl.token.LineBreakToken;
import de.siphalor.jcyo.core.impl.token.OperatorToken;
import de.siphalor.jcyo.core.impl.token.PlainJavaCommentToken;
import de.siphalor.jcyo.core.impl.token.RepresentableToken;
import de.siphalor.jcyo.core.impl.token.Token;
import de.siphalor.jcyo.core.impl.token.WhitespaceToken;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class JcyoImportReorderer {
    private final ImportOrder importOrder;
    private final List<Map.Entry<Integer, ImportOrderElement.Prefix>> prefixOrderElements;
    private static final Comparator<@Nullable String> IMPORT_PATH_COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());

    public JcyoImportReorderer(ImportOrder importOrder) {
        this.importOrder = importOrder;
        this.prefixOrderElements = new ArrayList<Map.Entry<Integer, ImportOrderElement.Prefix>>(importOrder.elements().size());
        for (int i = 0; i < importOrder.elements().size(); ++i) {
            ImportOrderElement element = importOrder.elements().get(i);
            if (!(element instanceof ImportOrderElement.Prefix)) continue;
            ImportOrderElement.Prefix prefix = (ImportOrderElement.Prefix)element;
            this.prefixOrderElements.add(Map.entry(i, prefix));
        }
    }

    public TokenStream apply(PeekableTokenStream input) {
        ArrayList<Token> buffer = new ArrayList<Token>();
        block4: while (true) {
            Objects.requireNonNull(input.peekToken());
            int n = 0;
            block5: while (true) {
                Token token;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WhitespaceToken.class, LineBreakToken.class, PlainJavaCommentToken.class, IdentifierToken.class, OperatorToken.class, JavaKeywordToken.class}, (Token)token, n)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (!(token instanceof WhitespaceToken || token instanceof LineBreakToken || token instanceof PlainJavaCommentToken || token instanceof IdentifierToken || token instanceof OperatorToken)) {
                            n = 5;
                            continue block5;
                        }
                        buffer.add(input.nextToken());
                        continue block4;
                    }
                    case 5: {
                        JavaKeywordToken keywordToken = (JavaKeywordToken)token;
                        if (keywordToken.keyword() != JavaKeyword.PACKAGE) {
                            n = 6;
                            continue block5;
                        }
                        buffer.add(input.nextToken());
                        continue block4;
                    }
                }
                break;
            }
            break;
        }
        SectionProcessResult sectionProcessResult = this.processSection(input);
        Section section = sectionProcessResult.section();
        ArrayList<Stream<Object>> tokenStreams = new ArrayList<Stream<Object>>(4);
        tokenStreams.add(buffer.stream());
        tokenStreams.add(section.tokens().stream());
        if (!(input.peekToken() instanceof EofToken)) {
            if (!section.tokens().isEmpty()) {
                tokenStreams.add(Stream.of(LineBreakToken.defaultInstance()));
            }
            if (sectionProcessResult.pendingWhitespace() != null) {
                tokenStreams.add(sectionProcessResult.pendingWhitespace().stream());
            }
            tokenStreams.add(input.stream());
        }
        return TokenStream.from(tokenStreams.stream().flatMap(Function.identity()).iterator());
    }

    private Section processBlockDirectiveSection(PeekableTokenStream input, JcyoDirective startDirective, TokenBuffer buffer) {
        SectionBuilder sectionBuilder = new SectionBuilder(buffer);
        SectionProcessResult sectionProcessResult = this.processSection(input);
        sectionBuilder.append(sectionProcessResult.section);
        if (sectionProcessResult.pendingWhitespace() != null) {
            sectionProcessResult.pendingWhitespace().stream().forEach(sectionBuilder.buffer()::pushToken);
        }
        if (sectionProcessResult.endDirective != null) {
            if (sectionProcessResult.endDirective.isBlockBegin()) {
                Section sibling = this.processBlockDirectiveSection(input, sectionProcessResult.endDirective, new TokenBuffer());
                sectionBuilder.append(sibling);
            }
        } else {
            JcyoDirective endingDirective = this.chompToEndingDirective(input, buffer, startDirective);
            if (endingDirective != null && endingDirective.isBlockBegin()) {
                Section sibling = this.processBlockDirectiveSection(input, endingDirective, new TokenBuffer());
                sectionBuilder.append(sibling);
            }
        }
        return sectionBuilder.build();
    }

    private @Nullable JcyoDirective chompToEndingDirective(PeekableTokenStream input, TokenBuffer buffer, JcyoDirective startDirective) {
        ArrayDeque<JcyoDirective> directiveStack = new ArrayDeque<JcyoDirective>();
        directiveStack.push(startDirective);
        Token token;
        while (!((token = input.peekToken()) instanceof EofToken)) {
            if (token instanceof JcyoDirectiveStartToken) {
                JcyoDirective directive = new DirectiveParser(buffer.copying(input)).nextDirective();
                if (directive.ends(Objects.requireNonNull((JcyoDirective)directiveStack.peek()))) {
                    directiveStack.pop();
                    if (directiveStack.isEmpty()) {
                        return directive;
                    }
                }
                if (!directive.isBlockBegin()) continue;
                directiveStack.push(directive);
                continue;
            }
            buffer.pushToken(input.nextToken());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private SectionProcessResult processSection(PeekableTokenStream input) {
        ArrayList<Element> elements = new ArrayList<Element>();
        TokenBuffer endBuffer = new TokenBuffer();
        JcyoDirective endDirective = null;
        block8: while (true) {
            Token token = input.peekToken();
            Objects.requireNonNull(token);
            int n = 0;
            block9: while (true) {
                Token token2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JavaKeywordToken.class, LineBreakToken.class, WhitespaceToken.class, JcyoDirectiveStartToken.class}, (Token)token2, n)) {
                    case 0: {
                        JavaKeyword javaKeyword;
                        JavaKeywordToken javaKeywordToken = (JavaKeywordToken)token2;
                        JavaKeyword keyword = javaKeyword = javaKeywordToken.keyword();
                        if (keyword != JavaKeyword.IMPORT) {
                            n = 1;
                            continue block9;
                        }
                        endBuffer.clear();
                        elements.add(this.parseImport(input));
                        continue block8;
                    }
                    case 1: {
                        endBuffer.clear();
                        input.nextToken();
                        continue block8;
                    }
                    case 2: {
                        endBuffer.pushToken(input.nextToken());
                        continue block8;
                    }
                    case 3: {
                        JcyoDirective directive = new DirectiveParser(endBuffer.copying(input)).nextDirective();
                        if (directive.isBlockEnd()) {
                            endDirective = directive;
                            break block8;
                        }
                        if (!directive.isBlockBegin()) continue block8;
                        Section section = this.processBlockDirectiveSection(input, directive, endBuffer);
                        elements.add(section);
                        endBuffer = new TokenBuffer();
                        continue block8;
                    }
                }
                break;
            }
            break;
        }
        elements.sort(Comparator.naturalOrder());
        Import firstImport = elements.stream().filter(element -> element instanceof Import).findFirst().map(Import.class::cast).orElse(null);
        Import lastImport = elements.reversed().stream().filter(element -> element instanceof Import).findFirst().map(Import.class::cast).orElse(null);
        SequencedCollection<Token> resultTokens = this.orderAndRenderElements(elements);
        if (endDirective != null) {
            endBuffer.finish();
            endBuffer.stream().forEach(resultTokens::add);
            return new SectionProcessResult(new Section(resultTokens, firstImport, lastImport), endDirective, null);
        }
        if (!endBuffer.isEmpty()) {
            endBuffer.finish();
            return new SectionProcessResult(new Section(resultTokens, firstImport, lastImport), null, endBuffer);
        }
        return new SectionProcessResult(new Section(resultTokens, firstImport, lastImport), null, null);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private SequencedCollection<Token> orderAndRenderElements(SequencedCollection<Element> elements) {
        ArrayList<Token> result = new ArrayList<Token>();
        int lastOrderIndex = -2147483647;
        String lastImportPath = null;
        block4: for (Element element : elements) {
            Element element2;
            Objects.requireNonNull(element);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Import.class, Section.class}, (Element)element2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Import _import = (Import)element2;
                    if (lastOrderIndex >= 0 && _import.orderIndex() != lastOrderIndex) {
                        if (this.importOrder.elements().subList(lastOrderIndex, _import.orderIndex()).contains(ImportOrderElement.blankLine())) {
                            result.add(LineBreakToken.defaultInstance());
                        }
                    } else if (lastImportPath != null && lastImportPath.length() == _import.importPath.length() && _import.importPath.endsWith(lastImportPath)) continue block4;
                    result.addAll(_import.tokens());
                    lastOrderIndex = _import.orderIndex();
                    lastImportPath = _import.importPath;
                    result.add(LineBreakToken.defaultInstance());
                    continue block4;
                }
                case 1: 
            }
            Section section = (Section)element2;
            if (section.firstImport != null) {
                if (lastOrderIndex >= 0 && section.firstImport.orderIndex() != lastOrderIndex && this.importOrder.elements().subList(lastOrderIndex, section.firstImport.orderIndex()).contains(ImportOrderElement.blankLine())) {
                    result.add(LineBreakToken.defaultInstance());
                }
            } else if (lastOrderIndex >= 0) {
                result.add(LineBreakToken.defaultInstance());
            }
            result.addAll(section.tokens());
            if (section.lastImport != null) {
                lastOrderIndex = section.lastImport.orderIndex();
            }
            lastImportPath = null;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Import parseImport(PeekableTokenStream input) {
        Token pToken;
        boolean isStatic;
        Iterator iter;
        StringBuilder pathBuilder;
        ArrayList<Token> importTokens;
        block11: {
            block10: {
                Token token;
                importTokens = new ArrayList<Token>();
                while (!((token = input.peekToken()) instanceof EofToken)) {
                    if (token instanceof OperatorToken) {
                        int n;
                        OperatorToken operatorToken = (OperatorToken)token;
                        try {
                            int n2 = n = operatorToken.codepoint();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        int codepoint = n;
                        if (codepoint == 59) {
                            importTokens.add(input.nextToken());
                            break;
                        }
                    }
                    importTokens.add(input.nextToken());
                }
                pathBuilder = new StringBuilder();
                iter = importTokens.stream().filter(t -> !(t instanceof WhitespaceToken)).iterator();
                iter.next();
                isStatic = false;
                pToken = (Token)iter.next();
                {
                    JavaKeywordToken javaKeywordToken;
                    JavaKeyword javaKeyword;
                    JavaKeyword pKeyword;
                    if (!(pToken instanceof JavaKeywordToken) || (pKeyword = (javaKeyword = (javaKeywordToken = (JavaKeywordToken)pToken).keyword())) != JavaKeyword.STATIC) break block10;
                    isStatic = true;
                    break block11;
                }
            }
            if (pToken instanceof RepresentableToken) {
                RepresentableToken rToken = (RepresentableToken)pToken;
                pathBuilder.append(rToken.raw());
            }
        }
        while (iter.hasNext()) {
            pToken = (Token)iter.next();
            if (pToken instanceof OperatorToken) {
                int n;
                OperatorToken operatorToken = (OperatorToken)pToken;
                {
                    int n3 = n = operatorToken.codepoint();
                }
                int codepoint = n;
                if (codepoint == 59) break;
            }
            if (!(pToken instanceof RepresentableToken)) continue;
            RepresentableToken rToken = (RepresentableToken)pToken;
            pathBuilder.append(rToken.raw());
        }
        String path = pathBuilder.toString();
        int orderIndex = this.getImportOrderIndex(isStatic, path);
        return new Import(importTokens, isStatic, path, orderIndex);
    }

    private int getImportOrderIndex(boolean isStatic, String importPath) {
        return this.prefixOrderElements.stream().filter(element -> ((ImportOrderElement.Prefix)element.getValue()).staticImport() == isStatic && importPath.startsWith(((ImportOrderElement.Prefix)element.getValue()).importPrefix())).max(Map.Entry.comparingByValue(Comparator.comparingInt(element -> element.importPrefix().length()))).map(Map.Entry::getKey).or(() -> {
            int i = this.importOrder.elements().indexOf(ImportOrderElement.rest(isStatic));
            return i >= 0 ? Optional.of(i) : Optional.empty();
        }).orElse(this.prefixOrderElements.size());
    }

    private static Optional<Import> getRepresentativeImportForElement(Element element) {
        Element element2 = element;
        Objects.requireNonNull(element2);
        Element element3 = element2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Import.class, Section.class}, (Element)element3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Import _import = (Import)element3;
                yield Optional.of(_import);
            }
            case 1 -> {
                Section section = (Section)element3;
                yield Optional.ofNullable(section.firstImport);
            }
        };
    }

    record SectionProcessResult(Section section, @Nullable JcyoDirective endDirective, @Nullable TokenStream pendingWhitespace) {
    }

    record Section(SequencedCollection<Token> tokens, @Nullable Import firstImport, @Nullable Import lastImport) implements Element
    {
    }

    static class SectionBuilder {
        private final TokenBuffer buffer;
        private @Nullable Import firstImport;
        private @Nullable Import lastImport;

        Section build() {
            this.buffer.finish();
            return new Section(this.buffer.stream().toList(), this.firstImport, this.lastImport);
        }

        void append(Section section) {
            section.tokens().forEach(this.buffer::pushToken);
            if (this.firstImport == null) {
                this.firstImport = section.firstImport;
            }
            this.lastImport = section.lastImport;
        }

        @Generated
        public SectionBuilder(TokenBuffer buffer) {
            this.buffer = buffer;
        }

        @Generated
        public TokenBuffer buffer() {
            return this.buffer;
        }

        @Generated
        public @Nullable Import firstImport() {
            return this.firstImport;
        }

        @Generated
        public @Nullable Import lastImport() {
            return this.lastImport;
        }

        @Generated
        public SectionBuilder firstImport(@Nullable Import firstImport) {
            this.firstImport = firstImport;
            return this;
        }

        @Generated
        public SectionBuilder lastImport(@Nullable Import lastImport) {
            this.lastImport = lastImport;
            return this;
        }
    }

    record Import(SequencedCollection<Token> tokens, boolean isStatic, String importPath, int orderIndex) implements Element
    {
    }

    static sealed interface Element
    extends Comparable<Element>
    permits Import, Section {
        @Override
        default public int compareTo(Element other) {
            Optional<Import> thisImport = JcyoImportReorderer.getRepresentativeImportForElement(this);
            Optional<Import> otherImport = JcyoImportReorderer.getRepresentativeImportForElement(other);
            int cmp = Integer.compare(thisImport.map(Import::orderIndex).orElse(Integer.MAX_VALUE), otherImport.map(Import::orderIndex).orElse(Integer.MAX_VALUE));
            if (cmp != 0) {
                return cmp;
            }
            return IMPORT_PATH_COMPARATOR.compare(thisImport.map(Import::importPath).orElse(null), otherImport.map(Import::importPath).orElse(null));
        }
    }
}

