/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.modsoftheworld.client;

import de.siphalor.modsoftheworld.client.Logo;
import de.siphalor.modsoftheworld.client.SplashProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.lwjgl.opengl.GL32;

public class MOTWClient {
    public static final String MOD_ID = "modsoftheworld";
    public static final class_2960 LOGO_KEY = new class_2960("modsoftheworld", "logo");
    public static final class_2960 SPLASHES_KEY = new class_2960("modsoftheworld", "splashes");
    public static final Pattern FABRIC_PATTERN = Pattern.compile("fabric-api-base|fabric-.*-v\\d");
    public static final float SHOW_TIME = 15.0f;
    public static final float FADE_TIME = 10.0f;
    public static final float WHOLE_TIME = 35.0f;
    public static final Random RANDOM = new Random();
    private static ArrayList<Logo> modLogos = null;

    public static ArrayList<Logo> getLogos() {
        if (modLogos != null) {
            return modLogos;
        }
        modLogos = new ArrayList();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata modMetadata = mod.getMetadata();
            Optional iconPath = modMetadata.getIconPath(8);
            if (FABRIC_PATTERN.matcher(modMetadata.getId()).find() || modMetadata.containsCustomValue("modmenu:api") && !modMetadata.containsCustomValue(LOGO_KEY.toString()) && !modMetadata.containsCustomValue(SPLASHES_KEY.toString())) continue;
            SplashProvider splashProvider = MOTWClient.loadSplashes(modMetadata);
            if (modMetadata.containsCustomValue(LOGO_KEY.toString()) && MOTWClient.loadLogo(class_2960.method_12829((String)modMetadata.getCustomValue(LOGO_KEY.toString()).getAsString()), modMetadata.getName(), splashProvider, true)) continue;
            try {
                iconPath.ifPresent(s -> {
                    s = s.toLowerCase(Locale.ENGLISH);
                    MOTWClient.loadLogo(new class_2960(s.replace("assets/", "").replaceFirst("/", ":")), modMetadata.getName(), splashProvider, true);
                });
            }
            catch (class_151 e) {
                System.err.println("[MOTW] Found invalid icon identifier \"" + (String)iconPath.get() + "\" for mod " + modMetadata.getName());
            }
        }
        Collections.shuffle(modLogos);
        MOTWClient.loadLogo(new class_2960(MOD_ID, "java.png"), "Java", SplashProvider.DEFAULT, false);
        return modLogos;
    }

    public static boolean loadLogo(class_2960 logoId, String modName, SplashProvider splashProvider, boolean pushBack) {
        class_1049 resourceTexture = new class_1049(logoId);
        try {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_3298 resource = resourceManager.method_14486(logoId);
            class_1011 nativeImage = class_1011.method_4309((InputStream)resource.method_14482());
            resourceTexture.method_4625(resourceManager);
            Logo logo = new Logo(resourceTexture, logoId, nativeImage.method_4307(), nativeImage.method_4323(), modName, splashProvider);
            modLogos.add(pushBack ? modLogos.size() : 0, logo);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SplashProvider loadSplashes(ModMetadata modMetadata) {
        if (modMetadata.containsCustomValue(SPLASHES_KEY.toString())) {
            try {
                class_3298 resource = class_310.method_1551().method_1478().method_14486(class_2960.method_12829((String)modMetadata.getCustomValue(SPLASHES_KEY.toString()).getAsString()));
                if (resource != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));
                    final String[] splashes = (String[])reader.lines().map(String::trim).toArray(String[]::new);
                    reader.close();
                    resource.close();
                    return new SplashProvider(){

                        @Override
                        public String get() {
                            return splashes[RANDOM.nextInt(splashes.length)];
                        }
                    };
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (modMetadata.getDescription().length() > 0) {
            final String[] splashes = (String[])Arrays.stream(modMetadata.getDescription().split("(?<=[.!?]|$)(?=\\s|$)")).map(s -> {
                if ((s = s.trim()).length() == 0) {
                    return null;
                }
                return s;
            }).toArray(String[]::new);
            return new SplashProvider(){

                @Override
                public String get() {
                    return splashes[RANDOM.nextInt(splashes.length)];
                }
            };
        }
        return SplashProvider.DEFAULT;
    }

    public static int getCurrentTexWidth() {
        return GL32.glGetTexParameteri((int)3553, (int)4096);
    }

    public static int getCurrentTexHeight() {
        return GL32.glGetTexParameteri((int)3553, (int)4097);
    }
}

